<?php
/**
 * ملف لإضافة طلبات تجريبية إلى قاعدة البيانات
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// التحقق من وجود جدول الطلبات
function checkOrdersTable($conn) {
    try {
        $stmt = $conn->query("SHOW TABLES LIKE 'orders'");
        return $stmt->rowCount() > 0;
    } catch (PDOException $e) {
        return false;
    }
}

// إضافة طلب جديد
function addOrder($conn, $orderData) {
    try {
        // إعداد استعلام الإدراج
        $sql = "INSERT INTO orders (
            order_number, client_name, service_type, 
            departure_area, second_destination, delivery_area, goods_name, goods_type, 
            country_of_origin, weight, quantity, unit, service_fees, 
            currency, payment_type, delivery_duration, amount_paid, remaining_amount, 
            order_upload_date, scheduled_delivery_date, recipient_name, phone_number, 
            notes, amount_agreed_with_customer, amount_agreed_with_agent, other_expenses, 
            profit, payment_status, status
        ) VALUES (
            :order_number, :client_name, :service_type, 
            :departure_area, :second_destination, :delivery_area, :goods_name, :goods_type, 
            :country_of_origin, :weight, :quantity, :unit, :service_fees, 
            :currency, :payment_type, :delivery_duration, :amount_paid, :remaining_amount, 
            :order_upload_date, :scheduled_delivery_date, :recipient_name, :phone_number, 
            :notes, :amount_agreed_with_customer, :amount_agreed_with_agent, :other_expenses, 
            :profit, :payment_status, :status
        )";
        
        $stmt = $conn->prepare($sql);
        $stmt->execute($orderData);
        
        return [
            'status' => 'success',
            'message' => 'تم إضافة الطلب بنجاح',
            'orderId' => $conn->lastInsertId()
        ];
    } catch (PDOException $e) {
        return [
            'status' => 'error',
            'message' => 'فشل في إضافة الطلب: ' . $e->getMessage()
        ];
    }
}

// التحقق من وجود جدول الطلبات
if (!checkOrdersTable($conn)) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'جدول الطلبات غير موجود'
    ]);
    exit;
}

// بيانات الطلبات التجريبية
$testOrders = [
    [
        'order_number' => 'ADN23-01',
        'client_name' => 'محمد علي',
        'service_type' => 'شحن بحري',
        'departure_area' => 'عدن',
        'second_destination' => '',
        'delivery_area' => 'صنعاء',
        'goods_name' => 'أجهزة كهربائية',
        'goods_type' => 'إلكترونيات',
        'country_of_origin' => 'الصين',
        'weight' => 150.00,
        'quantity' => 10,
        'unit' => 'كرتون',
        'service_fees' => 1000.00,
        'currency' => 'دولار',
        'payment_type' => 'كاش',
        'delivery_duration' => '3-5 أيام',
        'amount_paid' => 500.00,
        'remaining_amount' => 500.00,
        'order_upload_date' => date('Y-m-d'),
        'scheduled_delivery_date' => date('Y-m-d', strtotime('+5 days')),
        'recipient_name' => 'أحمد محمد',
        'phone_number' => '777123456',
        'notes' => 'يرجى الاتصال قبل التسليم',
        'amount_agreed_with_customer' => 1200.00,
        'amount_agreed_with_agent' => 800.00,
        'other_expenses' => 100.00,
        'profit' => 300.00,
        'payment_status' => 'جزئي',
        'status' => 'قيد المعالجة'
    ],
    [
        'order_number' => 'SNA23-01',
        'client_name' => 'علي محمد',
        'service_type' => 'شحن جوي',
        'departure_area' => 'صنعاء',
        'second_destination' => 'دبي',
        'delivery_area' => 'المكلا',
        'goods_name' => 'ملابس',
        'goods_type' => 'نسيج',
        'country_of_origin' => 'تركيا',
        'weight' => 100.00,
        'quantity' => 5,
        'unit' => 'كيس',
        'service_fees' => 800.00,
        'currency' => 'دولار',
        'payment_type' => 'تحويل بنكي',
        'delivery_duration' => '1-2 أيام',
        'amount_paid' => 800.00,
        'remaining_amount' => 0.00,
        'order_upload_date' => date('Y-m-d'),
        'scheduled_delivery_date' => date('Y-m-d', strtotime('+2 days')),
        'recipient_name' => 'سعيد عمر',
        'phone_number' => '777654321',
        'notes' => 'بضاعة قابلة للكسر',
        'amount_agreed_with_customer' => 1000.00,
        'amount_agreed_with_agent' => 600.00,
        'other_expenses' => 50.00,
        'profit' => 350.00,
        'payment_status' => 'مدفوع',
        'status' => 'في الطريق'
    ],
    [
        'order_number' => 'ADN23-02',
        'client_name' => 'حسن علي',
        'service_type' => 'شحن بري',
        'departure_area' => 'عدن',
        'second_destination' => '',
        'delivery_area' => 'المكلا',
        'goods_name' => 'أثاث منزلي',
        'goods_type' => 'أثاث',
        'country_of_origin' => 'الصين',
        'weight' => 150.00,
        'quantity' => 10,
        'unit' => 'قطعة',
        'service_fees' => 1000.00,
        'currency' => 'دولار',
        'payment_type' => 'كاش',
        'delivery_duration' => '5-7 أيام',
        'amount_paid' => 1000.00,
        'remaining_amount' => 0.00,
        'order_upload_date' => date('Y-m-d'),
        'scheduled_delivery_date' => date('Y-m-d', strtotime('+7 days')),
        'recipient_name' => 'عبدالله سالم',
        'phone_number' => '777987654',
        'notes' => 'توصيل إلى باب المنزل',
        'amount_agreed_with_customer' => 1200.00,
        'amount_agreed_with_agent' => 700.00,
        'other_expenses' => 150.00,
        'profit' => 350.00,
        'payment_status' => 'مدفوع',
        'status' => 'قيد المعالجة'
    ]
];

// إضافة الطلبات
$results = [];
foreach ($testOrders as $orderData) {
    $results[] = addOrder($conn, $orderData);
}

// إرجاع النتائج
header('Content-Type: application/json');
echo json_encode([
    'status' => 'success',
    'message' => 'تم إضافة الطلبات التجريبية بنجاح',
    'results' => $results
]);
?>
