<?php
// تضمين ملف التكوين
require_once '../config/config.php';

// التحقق من تسجيل الدخول
if (!isLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'غير مصرح لك بالوصول'
    ]);
    exit;
}

// التحقق من أن الطلب هو طلب POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'يجب استخدام طريقة POST'
    ]);
    exit;
}

// الحصول على بيانات الطلب
$data = json_decode(file_get_contents('php://input'), true);

// التحقق من وجود معرف الطلب
if (!isset($data['id']) || empty($data['id'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'معرف الطلب مطلوب'
    ]);
    exit;
}

// الحصول على معرف الطلب
$orderId = (int)$data['id'];

// الحصول على معلومات المستخدم الحالي
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$currentUser = $stmt->fetch();

// التحقق من صلاحيات المستخدم
$canDeleteOrder = ($currentUser['role'] === 'admin' || $currentUser['role'] === 'manager');

if (!$canDeleteOrder) {
    // التحقق مما إذا كان الطلب ينتمي للمستخدم الحالي
    $stmt = $pdo->prepare("SELECT user_id FROM orders WHERE id = ?");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch();
    
    if (!$order || $order['user_id'] != $_SESSION['user_id']) {
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => 'ليس لديك صلاحية لحذف هذا الطلب'
        ]);
        exit;
    }
}

try {
    // بدء المعاملة
    $pdo->beginTransaction();
    
    // حذف الطلب
    $stmt = $pdo->prepare("DELETE FROM orders WHERE id = ?");
    $stmt->execute([$orderId]);
    
    // التحقق من نجاح الحذف
    if ($stmt->rowCount() === 0) {
        throw new Exception('لم يتم العثور على الطلب');
    }
    
    // تأكيد المعاملة
    $pdo->commit();
    
    // إرجاع رسالة نجاح
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'message' => 'تم حذف الطلب بنجاح'
    ]);
} catch (Exception $e) {
    // التراجع عن المعاملة في حالة حدوث خطأ
    $pdo->rollBack();
    
    // إرجاع رسالة الخطأ
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'فشل في حذف الطلب: ' . $e->getMessage()
    ]);
}
