<?php
// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// التحقق من أن الطلب هو طلب GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'يجب استخدام طريقة GET']);
    exit;
}

// الحصول على اسم الفرع من الطلب
$branch = isset($_GET['branch']) ? $_GET['branch'] : null;

if (!$branch) {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'يجب تحديد الفرع']);
    exit;
}

try {
    // إنشاء رقم طلب جديد
    $orderNumber = generateOrderNumber($branch);
    
    // إرجاع رقم الطلب
    header('Content-Type: application/json');
    echo json_encode(['status' => 'success', 'orderNumber' => $orderNumber]);
    
} catch (Exception $e) {
    // إرجاع رسالة الخطأ
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'فشل إنشاء رقم الطلب: ' . $e->getMessage()]);
}
?>
