<?php
/**
 * ملف جلب قائمة الفروع
 * يستخدم هذا الملف لجلب قائمة الفروع من قاعدة البيانات
 */

// بدء الجلسة
session_start();

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// التحقق من تسجيل دخول المستخدم
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'يجب تسجيل الدخول لعرض الفروع']);
    exit;
}

try {
    // إعداد استعلام جلب الفروع
    $stmt = $conn->prepare("SELECT id, name, code FROM branches WHERE is_active = 1 ORDER BY name");
    $stmt->execute();
    
    // الحصول على النتائج
    $branches = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // إرجاع النتائج
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'branches' => $branches
    ]);
    
} catch (PDOException $e) {
    // إرجاع رسالة الخطأ
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'حدث خطأ أثناء جلب الفروع: ' . $e->getMessage()
    ]);
}
?>
