<?php
/**
 * API للحصول على قائمة المستخدمين المعلقين
 */

// بدء الجلسة
session_start();

// التحقق من تسجيل دخول المستخدم
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'يجب تسجيل الدخول للوصول إلى هذه البيانات'
    ]);
    exit;
}

// التحقق من صلاحيات المستخدم (مسموح فقط للمدير)
if ($_SESSION['role'] !== 'admin') {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'ليس لديك صلاحية الوصول إلى هذه البيانات'
    ]);
    exit;
}

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

try {
    // استعلام للحصول على المستخدمين المعلقين
    $stmt = $conn->prepare("
        SELECT id, username, full_name, email, phone, role, created_at
        FROM users
        WHERE is_active = 0 AND is_deleted = 0
        ORDER BY created_at DESC
    ");
    $stmt->execute();
    
    // الحصول على النتائج
    $pendingUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // إرجاع البيانات
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'users' => $pendingUsers
    ]);
} catch (PDOException $e) {
    // تسجيل الخطأ
    error_log('خطأ في قاعدة البيانات: ' . $e->getMessage());
    
    // إرجاع رسالة الخطأ
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'حدث خطأ أثناء استرجاع بيانات المستخدمين المعلقين'
    ]);
}
?>
