<?php
/**
 * واجهة برمجة التطبيقات للحصول على صلاحيات المستخدم
 * يستخدم هذا الملف للحصول على صلاحيات المستخدم بتنسيق JSON
 *
 * @version 1.0
 * @author فريق التطوير
 */

// بدء الجلسة
session_start();

// تضمين ملف التكوين
require_once '../config/config.php';

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// تضمين ملفات إدارة الصلاحيات
require_once '../includes/permissions_manager.php';

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

// تعيين نوع المحتوى إلى JSON
header('Content-Type: application/json; charset=utf-8');

// التحقق من حالة تسجيل الدخول
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    echo json_encode([
        'success' => false,
        'message' => 'غير مصرح به',
        'permissions' => []
    ]);
    exit;
}

// الحصول على معلومات المستخدم
$user = [
    'id' => $_SESSION['user_id'] ?? 0,
    'username' => $_SESSION['username'] ?? '',
    'role' => $_SESSION['role'] ?? 'user'
];

// تحديد ما إذا كان المستخدم مديرًا
$isAdmin = (isset($_SESSION['role']) && $_SESSION['role'] === 'admin');

// التحقق من صلاحيات المستخدم للوصول إلى هذه الواجهة
$hasPermission = $isAdmin;

// التحقق من وجود دالة checkUserPermission
if (!$hasPermission && function_exists('checkUserPermission')) {
    $hasPermission = checkUserPermission('view_users');
}

if (!$hasPermission) {
    echo json_encode([
        'success' => false,
        'message' => 'غير مصرح به',
        'permissions' => []
    ]);
    exit;
}

// التحقق من وجود معرف المستخدم
if (!isset($_GET['user_id']) || !is_numeric($_GET['user_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'معرف المستخدم غير صالح',
        'permissions' => []
    ]);
    exit;
}

$userId = (int)$_GET['user_id'];

// الحصول على صلاحيات المستخدم
try {
    // التحقق من وجود دالة getUserPermissions
    if (function_exists('getUserPermissions')) {
        $permissions = getUserPermissions($userId);
    } else {
        // إذا لم تكن الدالة موجودة، استخدم الاستعلام المباشر
        $permissions = [];
        
        // التحقق من وجود جدول صلاحيات المستخدمين
        $stmt = $pdo->query("SHOW TABLES LIKE 'user_permissions'");
        if ($stmt->rowCount() > 0) {
            $stmt = $pdo->prepare("
                SELECT p.*
                FROM permissions p
                JOIN user_permissions up ON p.id = up.permission_id
                WHERE up.user_id = ?
                ORDER BY p.category, p.id
            ");
            $stmt->execute([$userId]);
            $permissions = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'تم جلب الصلاحيات بنجاح',
        'permissions' => $permissions
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'حدث خطأ أثناء جلب صلاحيات المستخدم: ' . $e->getMessage(),
        'permissions' => []
    ]);
}
