<?php
/**
 * API لتعيين إشعار واحد كمقروء
 */

// بدء الجلسة
session_start();

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'غير مصرح به']);
    exit;
}

// الحصول على اتصال قاعدة البيانات
require_once __DIR__ . '/../config/db_connection.php';

// تضمين مدير الإشعارات
require_once __DIR__ . '/../includes/notifications_manager.php';

// الحصول على بيانات الطلب
$data = json_decode(file_get_contents('php://input'), true);

// التحقق من وجود معرف الإشعار
if (!isset($data['id']) || !is_numeric($data['id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'معرف الإشعار مطلوب']);
    exit;
}

// تعيين الإشعار كمقروء
$success = markNotificationAsRead($data['id']);

// إرجاع النتيجة
header('Content-Type: application/json');
echo json_encode(['success' => $success]);
