/**
 * تأثيرات صفحة تسجيل الدخول المميزة
 * 
 * @version 1.0
 * @author System Developer
 */

document.addEventListener('DOMContentLoaded', function() {
  // إضافة تأثير الدوائر المتحركة
  createFloatingCircles();
  
  // إضافة تأثير الخطوط المتحركة
  createMovingLines();
  
  // إضافة تأثير التموج للزر
  addRippleEffect();
  
  // إضافة تأثير التركيز على حقول الإدخال
  enhanceInputFields();
  
  // إضافة تأثير الظهور التدريجي للعناصر
  animateElements();
});

/**
 * إنشاء دوائر متحركة في الخلفية
 */
function createFloatingCircles() {
  const background = document.querySelector('.animated-background');
  if (!background) return;
  
  // إنشاء الدوائر
  for (let i = 1; i <= 4; i++) {
    const circle = document.createElement('div');
    circle.classList.add('circle', `circle-${i}`);
    background.appendChild(circle);
  }
}

/**
 * إنشاء خطوط متحركة في الخلفية
 */
function createMovingLines() {
  const linesContainer = document.querySelector('.lines');
  if (!linesContainer) return;
  
  // إنشاء الخطوط
  for (let i = 1; i <= 4; i++) {
    const line = document.createElement('div');
    line.classList.add('line');
    linesContainer.appendChild(line);
  }
}

/**
 * إضافة تأثير التموج للزر
 */
function addRippleEffect() {
  const buttons = document.querySelectorAll('.login-button');
  
  buttons.forEach(button => {
    button.addEventListener('click', function(e) {
      const rect = button.getBoundingClientRect();
      const x = e.clientX - rect.left;
      const y = e.clientY - rect.top;
      
      const ripple = document.createElement('span');
      ripple.classList.add('ripple');
      ripple.style.left = `${x}px`;
      ripple.style.top = `${y}px`;
      
      button.appendChild(ripple);
      
      // إزالة عنصر التموج بعد انتهاء التأثير
      setTimeout(() => {
        ripple.remove();
      }, 800);
    });
  });
}

/**
 * تحسين تأثيرات حقول الإدخال
 */
function enhanceInputFields() {
  const inputs = document.querySelectorAll('.login-input');
  
  inputs.forEach(input => {
    // تأثير التركيز
    input.addEventListener('focus', function() {
      this.parentElement.classList.add('focused');
    });
    
    input.addEventListener('blur', function() {
      this.parentElement.classList.remove('focused');
    });
    
    // تأثير التحقق من الإدخال
    input.addEventListener('input', function() {
      if (this.value.trim() !== '') {
        this.classList.add('has-value');
      } else {
        this.classList.remove('has-value');
      }
    });
  });
}

/**
 * تحريك العناصر بتأثير الظهور التدريجي
 */
function animateElements() {
  // تأثير ظهور الشعار
  const logo = document.querySelector('.company-logo');
  if (logo) {
    setTimeout(() => {
      logo.classList.add('visible');
    }, 200);
  }
  
  // تأثير ظهور العنوان
  const title = document.querySelector('.login-title');
  if (title) {
    setTimeout(() => {
      title.classList.add('visible');
    }, 400);
  }
  
  // تأثير ظهور حقول الإدخال
  const inputGroups = document.querySelectorAll('.input-group');
  inputGroups.forEach((group, index) => {
    setTimeout(() => {
      group.classList.add('visible');
    }, 600 + (index * 200));
  });
  
  // تأثير ظهور الزر
  const button = document.querySelector('.login-button');
  if (button) {
    setTimeout(() => {
      button.classList.add('visible');
    }, 1200);
  }
}

/**
 * إضافة تأثير الخلفية المتحركة
 */
function createDynamicBackground() {
  const background = document.querySelector('.animated-background');
  if (!background) return;
  
  // إنشاء نقاط متحركة في الخلفية
  for (let i = 0; i < 50; i++) {
    const dot = document.createElement('div');
    dot.classList.add('background-dot');
    
    // تعيين موقع عشوائي
    const posX = Math.random() * 100;
    const posY = Math.random() * 100;
    
    // تعيين حجم عشوائي
    const size = Math.random() * 5 + 1;
    
    // تعيين سرعة عشوائية
    const duration = Math.random() * 20 + 10;
    
    // تعيين الخصائص
    dot.style.left = `${posX}%`;
    dot.style.top = `${posY}%`;
    dot.style.width = `${size}px`;
    dot.style.height = `${size}px`;
    dot.style.animationDuration = `${duration}s`;
    
    background.appendChild(dot);
  }
}
