<?php
/**
 * ملف التحقق من تسجيل دخول المستخدم
 * يستخدم هذا الملف للتحقق من تسجيل دخول المستخدم وتوجيهه إلى صفحة تسجيل الدخول إذا لم يكن مسجلاً
 */

// بدء الجلسة
session_start();

// التحقق من تسجيل دخول المستخدم
if (!isset($_SESSION['user_id'])) {
    // تخزين الصفحة الحالية للعودة إليها بعد تسجيل الدخول
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];

    // إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
    header('Location: login.php');
    exit;
}

// التحقق من صلاحية الوصول إلى الصفحة بناءً على دور المستخدم
function checkRole($allowedRoles = ['admin', 'manager', 'employee']) {
    // التحقق من وجود دور المستخدم في قائمة الأدوار المسموح بها
    if (!in_array($_SESSION['role'], $allowedRoles)) {
        // إعادة توجيه المستخدم إلى الصفحة الرئيسية
        header('Location: index.php');
        exit;
    }
}

// الحصول على معلومات المستخدم الحالي
$currentUser = [
    'id' => $_SESSION['user_id'] ?? 0,
    'username' => $_SESSION['username'] ?? '',
    'full_name' => $_SESSION['full_name'] ?? $_SESSION['user_name'] ?? 'مستخدم النظام',
    'email' => $_SESSION['email'] ?? $_SESSION['user_email'] ?? '',
    'role' => $_SESSION['role'] ?? $_SESSION['user_role'] ?? 'user',
    'branch_id' => $_SESSION['branch_id'] ?? $_SESSION['user_branch_id'] ?? null
];
?>
