<?php
/**
 * ملف التحقق من الجلسة
 * يستخدم هذا الملف للتحقق من تسجيل دخول المستخدم قبل السماح له بالوصول إلى الصفحات المحمية
 */

// بدء الجلسة
session_start();

// قائمة الصفحات المستثناة من التحقق (يمكن الوصول إليها بدون تسجيل دخول)
$excluded_pages = [
    'login.php',
    'register.php',
    'index.html',
    'test_login.php',
    'test_db.php',
    'debug_session.php',
    'deploy_config.php',
    'import_database.php'
];

// الحصول على اسم الصفحة الحالية
$current_page = basename($_SERVER['PHP_SELF']);

// التحقق مما إذا كانت الصفحة الحالية مستثناة
$is_excluded = in_array($current_page, $excluded_pages);

// التحقق من تسجيل دخول المستخدم
$is_logged_in = isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;

// إذا لم تكن الصفحة مستثناة ولم يكن المستخدم مسجل الدخول، قم بتوجيهه إلى صفحة تسجيل الدخول
if (!$is_excluded && !$is_logged_in) {
    // تخزين الصفحة المطلوبة للعودة إليها بعد تسجيل الدخول
    $_SESSION['requested_page'] = $_SERVER['REQUEST_URI'];
    
    // توجيه المستخدم إلى صفحة تسجيل الدخول
    header('Location: login.php');
    exit;
}

// دالة للتحقق من صلاحيات المستخدم
function check_permission($required_role) {
    // التحقق من تسجيل دخول المستخدم
    if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
        return false;
    }
    
    // الحصول على دور المستخدم
    $user_role = $_SESSION['role'] ?? '';
    
    // التحقق من الصلاحيات
    switch ($required_role) {
        case 'admin':
            return $user_role === 'admin';
        case 'manager':
            return $user_role === 'admin' || $user_role === 'manager';
        case 'employee':
            return $user_role === 'admin' || $user_role === 'manager' || $user_role === 'employee';
        default:
            return false;
    }
}

// دالة للحصول على معلومات المستخدم الحالي
function get_current_user() {
    if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
        return null;
    }
    
    return [
        'id' => $_SESSION['user_id'] ?? null,
        'username' => $_SESSION['username'] ?? '',
        'full_name' => $_SESSION['full_name'] ?? '',
        'email' => $_SESSION['email'] ?? '',
        'role' => $_SESSION['role'] ?? '',
        'branch_id' => $_SESSION['branch_id'] ?? null
    ];
}
?>
