<?php
/**
 * صفحة تسجيل الدخول
 * تقوم هذه الصفحة بعرض نموذج تسجيل الدخول والتحقق من بيانات المستخدم
 */

// تضمين ملف التكوين
require_once 'config/config.php';

// تضمين ملف الدوال المساعدة
require_once 'includes/functions.php';

// التحقق من حالة تسجيل الدخول
if (isLoggedIn()) {
    // إعادة توجيه المستخدم إلى لوحة التحكم
    header('Location: dashboard.php');
    exit;
}

// متغيرات الخطأ والنجاح
$error = '';
$success = '';

// التحقق من وجود رسالة خطأ في الجلسة
if (isset($_SESSION['login_error'])) {
    $error = $_SESSION['login_error'];
    unset($_SESSION['login_error']);
}

// التحقق من وجود رسالة نجاح في الجلسة
if (isset($_SESSION['login_success'])) {
    $success = $_SESSION['login_success'];
    unset($_SESSION['login_success']);
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>تسجيل الدخول - نظام طلبات الشحن</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Tajawal', sans-serif;
    }
    
    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      background: linear-gradient(to bottom, #ff6ec4, #7873f5); /* تدرج احتياطي في حالة عدم تحميل الصورة */
      direction: rtl;
      overflow: hidden;
      position: relative;
      background-image: url('assets/images/Login6.png');
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
    }
    
    .mountains-bg {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-image: url('assets/images/mountains-bg.svg');
      background-size: cover;
      background-position: center;
      z-index: 0;
      opacity: 0.3; /* تقليل الشفافية لإظهار الصورة الخلفية بشكل أفضل */
    }
    
    .auth-container {
      position: relative;
      z-index: 1;
      width: 100%;
      max-width: 420px;
      padding: 40px;
      background: rgba(0, 0, 0, 0.6); /* تغيير لون الخلفية ليناسب الصورة الجديدة */
      backdrop-filter: blur(10px);
      border-radius: 16px;
      border: 1px solid rgba(255, 255, 255, 0.3);
      box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
      text-align: center;
    }
    
    .close-btn {
      position: absolute;
      top: 15px;
      left: 15px;
      width: 24px;
      height: 24px;
      background: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      text-decoration: none;
      font-size: 14px;
      transition: all 0.3s ease;
    }
    
    .close-btn:hover {
      background: rgba(255, 255, 255, 0.4);
      transform: rotate(90deg);
    }
    
    .auth-title {
      font-size: 28px;
      color: #fff;
      margin-bottom: 30px;
      font-weight: 600;
      text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    
    .input-group {
      position: relative;
      margin-bottom: 25px;
    }
    
    .auth-input {
      width: 100%;
      padding: 15px 15px 15px 40px;
      background: rgba(255, 255, 255, 0.1);
      border: none;
      border-bottom: 1px solid rgba(255, 255, 255, 0.4);
      border-radius: 8px;
      color: white;
      font-size: 16px;
      transition: all 0.3s ease;
    }
    
    .auth-input::placeholder {
      color: rgba(255, 255, 255, 0.6);
    }
    
    .auth-input:focus {
      outline: none;
      background: rgba(255, 255, 255, 0.2);
      border-bottom-color: rgba(255, 255, 255, 0.8);
    }
    
    .input-icon {
      position: absolute;
      left: 12px;
      top: 50%;
      transform: translateY(-50%);
      color: rgba(255, 255, 255, 0.7);
      font-size: 18px;
    }
    
    .remember-forgot {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 25px;
      color: white;
      font-size: 14px;
    }
    
    .checkbox-container {
      display: flex;
      align-items: center;
    }
    
    .auth-checkbox {
      margin-left: 8px;
      appearance: none;
      width: 18px;
      height: 18px;
      background: rgba(255, 255, 255, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.4);
      border-radius: 4px;
      position: relative;
      cursor: pointer;
    }
    
    .auth-checkbox:checked::before {
      content: '✓';
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      color: white;
      font-size: 12px;
    }
    
    .forgot-password {
      color: white;
      text-decoration: none;
      transition: all 0.3s ease;
    }
    
    .forgot-password:hover {
      text-decoration: underline;
    }
    
    .auth-button {
      width: 100%;
      padding: 15px;
      background: rgba(120, 115, 245, 0.8);
      border: none;
      border-radius: 8px;
      color: white;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      margin-bottom: 25px;
    }
    
    .auth-button:hover {
      background: rgba(120, 115, 245, 1);
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }
    
    .auth-switch {
      color: white;
      font-size: 14px;
    }
    
    .auth-switch a {
      color: #fff;
      text-decoration: none;
      font-weight: 600;
      margin-right: 5px;
      transition: all 0.3s ease;
    }
    
    .auth-switch a:hover {
      text-decoration: underline;
    }
    
    @media (max-width: 480px) {
      .auth-container {
        max-width: 90%;
        padding: 30px 20px;
      }
    
      .auth-title {
        font-size: 24px;
      }
    
      .auth-input {
        padding: 12px 12px 12px 35px;
        font-size: 14px;
      }
    
      .input-icon {
        font-size: 16px;
      }
    }
  </style>
</head>

<body>
  <!-- خلفية الجبال -->
  <div class="mountains-bg"></div>

  <!-- حاوية النموذج -->
  <div class="auth-container">
    <a href="#" class="close-btn">×</a>

    <h2 class="auth-title">تسجيل الدخول</h2>

    <form id="loginForm" action="login_process.php" method="post">
      <div class="input-group">
        <input type="email" name="email" class="auth-input" placeholder="البريد الإلكتروني" required>
        <i class="fas fa-envelope input-icon"></i>
      </div>

      <div class="input-group">
        <input type="password" name="password" class="auth-input" placeholder="كلمة المرور" required>
        <i class="fas fa-lock input-icon"></i>
      </div>

      <div class="remember-forgot">
        <div class="checkbox-container">
          <input type="checkbox" id="remember" name="remember" class="auth-checkbox">
          <label for="remember">تذكرني</label>
        </div>
        <a href="#" class="forgot-password">نسيت كلمة المرور؟</a>
      </div>

      <?php if (!empty($error)): ?>
      <div class="error-message">
        <?php echo $error; ?>
      </div>
      <?php endif; ?>

      <button type="submit" class="auth-button">تسجيل الدخول</button>
    </form>

    <div class="auth-switch">
      <span>ليس لديك حساب؟</span>
      <a href="register.php">إنشاء حساب</a>
    </div>
  </div>

  <script>
    // إضافة تأثيرات بسيطة
    document.addEventListener('DOMContentLoaded', function() {
      const inputs = document.querySelectorAll('.auth-input');

      inputs.forEach(input => {
        input.addEventListener('focus', function() {
          this.parentElement.style.transform = 'translateY(-5px)';
        });

        input.addEventListener('blur', function() {
          this.parentElement.style.transform = 'translateY(0)';
        });
      });
    });
  </script>
</body>

</html>
