<?php
/**
 * صفحة إنشاء حساب جديد
 * تقوم هذه الصفحة بعرض نموذج إنشاء حساب جديد
 */

// بدء الجلسة
session_start();

// تضمين ملف التكوين
require_once 'config/config.php';

// التحقق من حالة تسجيل الدخول
if (isLoggedIn()) {
    // إعادة توجيه المستخدم إلى لوحة التحكم
    header('Location: dashboard.php');
    exit;
}

// متغيرات الخطأ والنجاح
$error = '';
$success = '';

// التحقق من وجود رسالة خطأ في الجلسة
if (isset($_SESSION['register_error'])) {
    $error = $_SESSION['register_error'];
    unset($_SESSION['register_error']);
}

// التحقق من وجود رسالة نجاح في الجلسة
if (isset($_SESSION['register_success'])) {
    $success = $_SESSION['register_success'];
    unset($_SESSION['register_success']);
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>إنشاء حساب جديد - نظام طلبات الشحن</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="../assets/css/modern-auth-new.css">
</head>

<body class="modern-auth">
  <!-- خلفية الجبال -->
  <div class="mountains-bg"></div>

  <!-- حاوية النموذج -->
  <div class="auth-container">
    <a href="#" class="close-btn">×</a>

    <h2 class="auth-title">إنشاء حساب</h2>

    <form id="registerForm" action="register_process.php" method="post">
      <!-- رمز CSRF للحماية من هجمات CSRF -->
      <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">

      <div class="input-group">
        <input type="text" name="fullName" class="auth-input" placeholder="الاسم الكامل" required>
        <i class="fas fa-user input-icon"></i>
      </div>

      <div class="input-group">
        <input type="email" name="email" class="auth-input" placeholder="البريد الإلكتروني" required>
        <i class="fas fa-envelope input-icon"></i>
      </div>

      <div class="input-group">
        <input type="password" name="password" class="auth-input" placeholder="كلمة المرور" required>
        <i class="fas fa-lock input-icon"></i>
        <small style="color: #ddd; font-size: 11px; display: block; margin-top: 5px; text-align: right;">
          يجب أن تحتوي كلمة المرور على 6 أحرف على الأقل
        </small>
      </div>

      <div class="input-group">
        <input type="password" name="confirm_password" class="auth-input" placeholder="تأكيد كلمة المرور" required>
        <i class="fas fa-lock input-icon"></i>
      </div>

      <div class="input-group">
        <input type="tel" name="phone" class="auth-input" placeholder="رقم الهاتف">
        <i class="fas fa-phone input-icon"></i>
      </div>

      <div class="checkbox-container" style="margin-bottom: 20px; display: flex; align-items: flex-start;">
        <input type="checkbox" id="terms" name="terms" class="auth-checkbox" required>
        <label for="terms" style="margin-right: 8px;">أوافق على الشروط والأحكام</label>
      </div>

      <?php if (isset($_SESSION['register_error'])): ?>
      <div class="error-message" style="color: #ff3333; margin-bottom: 15px; background-color: rgba(255, 51, 51, 0.1); padding: 10px; border-radius: 5px; text-align: center;">
        <?php echo $_SESSION['register_error']; unset($_SESSION['register_error']); ?>
      </div>
      <?php endif; ?>

      <?php if (isset($_SESSION['register_success'])): ?>
      <div class="success-message" style="color: #33cc33; margin-bottom: 15px; background-color: rgba(51, 204, 51, 0.1); padding: 10px; border-radius: 5px; text-align: center;">
        <?php echo $_SESSION['register_success']; unset($_SESSION['register_success']); ?>
      </div>
      <?php endif; ?>

      <button type="submit" class="auth-button">إنشاء حساب</button>
    </form>

    <div class="auth-switch">
      <span>لديك حساب بالفعل؟</span>
      <a href="login.php">تسجيل الدخول</a>
    </div>
  </div>

  <script>
    // إضافة تأثيرات بسيطة
    document.addEventListener('DOMContentLoaded', function() {
      const inputs = document.querySelectorAll('.auth-input');

      inputs.forEach(input => {
        input.addEventListener('focus', function() {
          this.parentElement.style.transform = 'translateY(-5px)';
        });

        input.addEventListener('blur', function() {
          this.parentElement.style.transform = 'translateY(0)';
        });
      });
    });
  </script>
</body>

</html>
