<?php
/**
 * ملف معالجة إنشاء حساب جديد
 * يستخدم هذا الملف لمعالجة طلب إنشاء حساب جديد
 */

// بدء الجلسة
session_start();

// تضمين ملف التكوين
require_once 'config/config.php';

// تسجيل معلومات التصحيح
error_log("بدء معالجة التسجيل - " . date('Y-m-d H:i:s'));
error_log("متغير الاتصال conn: " . (isset($conn) ? 'موجود' : 'غير موجود'));
error_log("متغير الاتصال pdo: " . (isset($pdo) ? 'موجود' : 'غير موجود'));

// التحقق من هيكل جدول المستخدمين
try {
    // تحديد نوع قاعدة البيانات
    $dbType = $pdo->getAttribute(PDO::ATTR_DRIVER_NAME);
    error_log("نوع قاعدة البيانات: " . $dbType);

    if ($dbType === 'mysql') {
        $tableInfoStmt = $pdo->prepare("DESCRIBE users");
    } else {
        $tableInfoStmt = $pdo->prepare("PRAGMA table_info(users)");
    }

    $tableInfoStmt->execute();
    $columns = $tableInfoStmt->fetchAll(PDO::FETCH_ASSOC);
    error_log("هيكل جدول المستخدمين:");

    if ($dbType === 'mysql') {
        foreach ($columns as $column) {
            error_log("العمود: " . $column['Field'] . ", النوع: " . $column['Type']);
        }
    } else {
        foreach ($columns as $column) {
            error_log("العمود: " . $column['name'] . ", النوع: " . $column['type']);
        }
    }
} catch (Exception $e) {
    error_log("خطأ في الحصول على هيكل الجدول: " . $e->getMessage());
}

// التحقق من طريقة الطلب
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    // إعادة توجيه المستخدم إلى صفحة إنشاء الحساب
    header('Location: register.php');
    exit;
}

// التحقق من حالة تسجيل الدخول
if (isLoggedIn()) {
    // إعادة توجيه المستخدم إلى لوحة التحكم
    header('Location: dashboard.php');
    exit;
}

// التحقق من رمز CSRF
if (!isset($_POST['csrf_token']) || !verifyCSRFToken($_POST['csrf_token'])) {
    // تخزين رسالة الخطأ في الجلسة
    $_SESSION['register_error'] = 'خطأ في التحقق من صحة النموذج. يرجى المحاولة مرة أخرى.';

    // إعادة توجيه المستخدم إلى صفحة إنشاء الحساب
    header('Location: register.php');
    exit;
}

// الحصول على بيانات النموذج
$fullName = sanitizeInput($_POST['fullName'] ?? '');
$email = sanitizeInput($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$confirm_password = $_POST['confirm_password'] ?? '';
$terms = isset($_POST['terms']);

// التحقق من البيانات
if (empty($fullName) || empty($email) || empty($password) || empty($confirm_password)) {
    // تخزين رسالة الخطأ في الجلسة
    $_SESSION['register_error'] = 'يرجى إدخال جميع البيانات المطلوبة.';

    // إعادة توجيه المستخدم إلى صفحة إنشاء الحساب
    header('Location: register.php');
    exit;
}

// التحقق من تطابق كلمة المرور
if ($password !== $confirm_password) {
    // تخزين رسالة الخطأ في الجلسة
    $_SESSION['register_error'] = 'كلمة المرور وتأكيد كلمة المرور غير متطابقين.';

    // إعادة توجيه المستخدم إلى صفحة إنشاء الحساب
    header('Location: register.php');
    exit;
}

// التحقق من الموافقة على الشروط والأحكام
if (!$terms) {
    // تخزين رسالة الخطأ في الجلسة
    $_SESSION['register_error'] = 'يجب الموافقة على الشروط والأحكام.';

    // إعادة توجيه المستخدم إلى صفحة إنشاء الحساب
    header('Location: register.php');
    exit;
}

// إنشاء اسم مستخدم فريد من البريد الإلكتروني
$username = explode('@', $email)[0];

// التحقق من وجود اسم المستخدم
$stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
$stmt->execute([$username]);

// إذا كان اسم المستخدم موجودًا، أضف رقمًا عشوائيًا إليه
if ($stmt->rowCount() > 0) {
    $username = $username . rand(100, 999);
}

// إضافة تعليمات للتصحيح
error_log("بدء عملية التسجيل: $fullName, $email, $username");

try {
    // تشفير كلمة المرور
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // تاريخ التسجيل الحالي
    $registrationDate = date('Y-m-d H:i:s');

    // تحديد نوع قاعدة البيانات
    $dbType = $pdo->getAttribute(PDO::ATTR_DRIVER_NAME);
    error_log("نوع قاعدة البيانات عند الإدراج: " . $dbType);

    // التحقق من وجود عمود full_name أو fullname
    if ($dbType === 'mysql') {
        $checkColumnStmt = $pdo->prepare("SHOW COLUMNS FROM `users` LIKE 'full_name'");
    } else {
        $checkColumnStmt = $pdo->prepare("PRAGMA table_info(users)");
    }

    $checkColumnStmt->execute();
    $columns = $checkColumnStmt->fetchAll(PDO::FETCH_ASSOC);

    $fullNameColumnExists = false;
    $fullnameColumnExists = false;

    if ($dbType === 'mysql') {
        $fullNameColumnExists = $checkColumnStmt->rowCount() > 0;

        if (!$fullNameColumnExists) {
            $checkColumnStmt = $pdo->prepare("SHOW COLUMNS FROM `users` LIKE 'fullname'");
            $checkColumnStmt->execute();
            $fullnameColumnExists = $checkColumnStmt->rowCount() > 0;
        }
    } else {
        foreach ($columns as $column) {
            if ($column['name'] === 'full_name') {
                $fullNameColumnExists = true;
            } else if ($column['name'] === 'fullname') {
                $fullnameColumnExists = true;
            }
        }
    }

    error_log("عمود full_name موجود: " . ($fullNameColumnExists ? 'نعم' : 'لا'));
    error_log("عمود fullname موجود: " . ($fullnameColumnExists ? 'نعم' : 'لا'));

    // إدراج المستخدم الجديد مباشرة باستخدام $pdo
    if ($fullNameColumnExists) {
        $insertStmt = $pdo->prepare("
            INSERT INTO users (username, full_name, email, password, role, status, registration_date, phone)
            VALUES (?, ?, ?, ?, 'client', 'pending', ?, ?)
        ");
        error_log("استخدام عمود full_name للإدراج");
    } else if ($fullnameColumnExists) {
        $insertStmt = $pdo->prepare("
            INSERT INTO users (username, fullname, email, password, role, status, registration_date, phone)
            VALUES (?, ?, ?, ?, 'client', 'pending', ?, ?)
        ");
        error_log("استخدام عمود fullname للإدراج");
    } else {
        throw new Exception("لم يتم العثور على عمود full_name أو fullname في جدول المستخدمين");
    }

    $phone = isset($_POST['phone']) ? sanitizeInput($_POST['phone']) : '';
    $result = $insertStmt->execute([$username, $fullName, $email, $hashedPassword, $registrationDate, $phone]);

    if ($result) {
        $resultArray = [
            'success' => true,
            'message' => 'تم إنشاء الحساب بنجاح. يرجى الانتظار حتى يتم تفعيل حسابك من قبل الإدارة'
        ];
    } else {
        $resultArray = [
            'success' => false,
            'message' => 'فشل إدراج المستخدم الجديد في قاعدة البيانات'
        ];
    }

    error_log("نتيجة التسجيل: " . ($resultArray['success'] ? 'نجاح' : 'فشل') . " - " . $resultArray['message']);
    $result = $resultArray;
} catch (Exception $e) {
    error_log("استثناء أثناء التسجيل: " . $e->getMessage());
    error_log("رمز الخطأ: " . $e->getCode());
    error_log("تتبع الخطأ: " . $e->getTraceAsString());

    // تخزين رسالة الخطأ في الجلسة مع تفاصيل أكثر للتصحيح
    $_SESSION['register_error'] = 'حدث خطأ أثناء إنشاء الحساب: ' . $e->getMessage() . ' (رمز: ' . $e->getCode() . ')';
    header('Location: register.php');
    exit;
}

if ($result['success']) {
    // تخزين رسالة النجاح في الجلسة
    $_SESSION['register_success'] = $result['message'];

    // إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
    header('Location: login.php');
    exit;
} else {
    // تخزين رسالة الخطأ في الجلسة
    $_SESSION['register_error'] = $result['message'];

    // إعادة توجيه المستخدم إلى صفحة إنشاء الحساب
    header('Location: register.php');
    exit;
}
?>
