<?php
/**
 * سكريبت للتحقق من جدول الفروع في قاعدة البيانات
 */

// عرض جميع الأخطاء للمساعدة في التشخيص
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once 'config/db_connection.php';

// التحقق من وجود اتصال بقاعدة البيانات
if (!isset($conn) || !$conn) {
    die("فشل الاتصال بقاعدة البيانات");
}

// التحقق من وجود جدول الفروع
try {
    $stmt = $conn->query("SHOW TABLES LIKE 'branches'");
    $tableExists = $stmt->rowCount() > 0;

    echo "<h2>نتائج التحقق من جدول الفروع</h2>";
    echo "<p>حالة جدول الفروع: " . ($tableExists ? "موجود" : "غير موجود") . "</p>";

    if ($tableExists) {
        // التحقق من هيكل جدول الفروع
        $stmt = $conn->query("DESCRIBE branches");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h3>هيكل جدول الفروع:</h3>";
        echo "<ul>";
        foreach ($columns as $column) {
            echo "<li>{$column['Field']} - {$column['Type']}</li>";
        }
        echo "</ul>";

        // التحقق من وجود المركز الرئيسي
        $stmt = $conn->prepare("SELECT * FROM branches WHERE name = 'المركز الرئيسي'");
        $stmt->execute();
        $headquarters = $stmt->fetch(PDO::FETCH_ASSOC);

        echo "<h3>معلومات المركز الرئيسي:</h3>";
        if ($headquarters) {
            echo "<p>تم العثور على المركز الرئيسي:</p>";
            echo "<ul>";
            echo "<li>المعرف: {$headquarters['id']}</li>";
            echo "<li>الاسم: {$headquarters['name']}</li>";
            echo "<li>الرمز: {$headquarters['code']}</li>";
            echo "<li>الحالة: " . ($headquarters['is_active'] ? 'نشط' : 'غير نشط') . "</li>";
            echo "</ul>";
        } else {
            echo "<p>لم يتم العثور على المركز الرئيسي</p>";
        }

        // عرض جميع الفروع
        $stmt = $conn->query("SELECT * FROM branches");
        $branches = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h3>جميع الفروع في النظام:</h3>";
        if (count($branches) > 0) {
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr><th>المعرف</th><th>الاسم</th><th>الرمز</th><th>الحالة</th></tr>";
            foreach ($branches as $branch) {
                echo "<tr>";
                echo "<td>{$branch['id']}</td>";
                echo "<td>{$branch['name']}</td>";
                echo "<td>{$branch['code']}</td>";
                echo "<td>" . ($branch['is_active'] ? 'نشط' : 'غير نشط') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p>لا يوجد فروع في النظام</p>";
        }
    }
} catch (PDOException $e) {
    echo "<p>حدث خطأ أثناء التحقق من قاعدة البيانات: " . $e->getMessage() . "</p>";
}
?>
