<?php
/**
 * ملف التحقق من قاعدة البيانات
 * يستخدم هذا الملف للتحقق من الاتصال بقاعدة البيانات وعرض معلومات عن الجداول
 */

// تعيين ترميز الصفحة
header('Content-Type: text/html; charset=utf-8');

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف التكوين
require_once 'config/config.php';

// التحقق من الاتصال بقاعدة البيانات
if (!isset($pdo) || !$pdo) {
    die('<div class="alert alert-danger">فشل الاتصال بقاعدة البيانات</div>');
}

// دالة للتحقق من وجود جدول
function tableExists($pdo, $table) {
    try {
        $result = $pdo->query("SHOW TABLES LIKE '{$table}'");
        return $result->rowCount() > 0;
    } catch (PDOException $e) {
        return false;
    }
}

// دالة لإنشاء جدول إذا لم يكن موجوداً
function createTableIfNotExists($pdo, $table, $sql) {
    if (!tableExists($pdo, $table)) {
        try {
            $pdo->exec($sql);
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }
    return true;
}

// دالة لعرض معلومات الجدول
function showTableInfo($pdo, $table) {
    $result = [
        'exists' => false,
        'count' => 0,
        'columns' => [],
        'sample' => []
    ];

    if (tableExists($pdo, $table)) {
        $result['exists'] = true;

        // عدد السجلات
        $stmt = $pdo->query("SELECT COUNT(*) FROM `{$table}`");
        $result['count'] = $stmt->fetchColumn();

        // معلومات الأعمدة
        $stmt = $pdo->query("SHOW COLUMNS FROM `{$table}`");
        $result['columns'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // عينة من البيانات
        if ($result['count'] > 0) {
            $stmt = $pdo->query("SELECT * FROM `{$table}` LIMIT 5");
            $result['sample'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }

    return $result;
}

// الحصول على معلومات الجداول الرئيسية
$tablesInfo = [
    'orders' => showTableInfo($pdo, 'orders'),
    'branches' => showTableInfo($pdo, 'branches'),
    'users' => showTableInfo($pdo, 'users'),
    'order_sequences' => showTableInfo($pdo, 'order_sequences')
];

// الحصول على قائمة جميع الجداول
$stmt = $pdo->query('SHOW TABLES');
$allTables = $stmt->fetchAll(PDO::FETCH_COLUMN);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>التحقق من قاعدة البيانات</title>
    <link rel="stylesheet" href="assets/css/bootstrap.rtl.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        .card {
            margin-bottom: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .card-header {
            font-weight: bold;
            background-color: #f8f9fa;
        }
        .table-responsive {
            max-height: 400px;
            overflow-y: auto;
        }
        .status-badge {
            font-size: 0.8rem;
            padding: 0.25rem 0.5rem;
            border-radius: 50px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="mb-4">التحقق من قاعدة البيانات</h1>

        <div class="alert alert-success">
            <strong>تم الاتصال بقاعدة البيانات بنجاح!</strong>
            <p class="mb-0">اسم قاعدة البيانات: <?php echo DB_NAME; ?></p>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        ملخص الجداول الرئيسية
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>اسم الجدول</th>
                                    <th>الحالة</th>
                                    <th>عدد السجلات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($tablesInfo as $table => $info): ?>
                                <tr>
                                    <td><?php echo $table; ?></td>
                                    <td>
                                        <?php if ($info['exists']): ?>
                                            <span class="status-badge bg-success text-white">موجود</span>
                                        <?php else: ?>
                                            <span class="status-badge bg-danger text-white">غير موجود</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $info['exists'] ? $info['count'] : '-'; ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        جميع الجداول (<?php echo count($allTables); ?>)
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>اسم الجدول</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($allTables as $index => $table): ?>
                                    <tr>
                                        <td><?php echo $index + 1; ?></td>
                                        <td><?php echo $table; ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-4">
            <a href="ASDRF43/unified-dashboard.php" class="btn btn-primary">العودة إلى لوحة التحكم</a>
            <a href="check_requirements.php" class="btn btn-secondary">التحقق من متطلبات النظام</a>
            <a href="backup_database.php" class="btn btn-success">عمل نسخة احتياطية</a>
        </div>
    </div>
</body>
</html>
