<?php
/**
 * سكريبت للتحقق من جدول الطلبات في قاعدة البيانات
 */

// عرض جميع الأخطاء للمساعدة في التشخيص
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once 'config/db_connection.php';

// التحقق من وجود اتصال بقاعدة البيانات
if (!isset($conn) || !$conn) {
    die("فشل الاتصال بقاعدة البيانات");
}

// التحقق من وجود جدول الطلبات
try {
    $stmt = $conn->query("SHOW TABLES LIKE 'orders'");
    $tableExists = $stmt->rowCount() > 0;

    echo "<h2>نتائج التحقق من جدول الطلبات</h2>";
    echo "<p>حالة جدول الطلبات: " . ($tableExists ? "موجود" : "غير موجود") . "</p>";

    if ($tableExists) {
        // التحقق من هيكل جدول الطلبات
        $stmt = $conn->query("DESCRIBE orders");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h3>هيكل جدول الطلبات:</h3>";
        echo "<ul>";
        foreach ($columns as $column) {
            echo "<li>{$column['Field']} - {$column['Type']}</li>";
        }
        echo "</ul>";

        // التحقق من وجود حقل الموظف وحقل المستخدم
        $hasEmployeeField = false;
        $hasUserIdField = false;
        foreach ($columns as $column) {
            if ($column['Field'] === 'employee_name') {
                $hasEmployeeField = true;
            }
            if ($column['Field'] === 'user_id') {
                $hasUserIdField = true;
            }
        }

        echo "<p>حقل اسم الموظف (employee_name): " . ($hasEmployeeField ? "موجود" : "غير موجود") . "</p>";
        echo "<p>حقل معرف المستخدم (user_id): " . ($hasUserIdField ? "موجود" : "غير موجود") . "</p>";

        // عرض عينة من الطلبات
        $stmt = $conn->query("SELECT id, order_number, client_name, employee_name, user_id, status FROM orders LIMIT 10");
        $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h3>عينة من الطلبات:</h3>";
        if (count($orders) > 0) {
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr><th>المعرف</th><th>رقم الطلب</th><th>العميل</th><th>الموظف</th><th>معرف المستخدم</th><th>الحالة</th></tr>";
            foreach ($orders as $order) {
                echo "<tr>";
                echo "<td>{$order['id']}</td>";
                echo "<td>{$order['order_number']}</td>";
                echo "<td>{$order['client_name']}</td>";
                echo "<td>{$order['employee_name']}</td>";
                echo "<td>{$order['user_id']}</td>";
                echo "<td>{$order['status']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p>لا توجد طلبات في النظام</p>";
        }

        // التحقق من العلاقة بين المستخدمين والطلبات
        if ($hasUserIdField) {
            $stmt = $conn->query("
                SELECT 
                    u.id as user_id, 
                    u.username, 
                    u.full_name, 
                    COUNT(o.id) as orders_count 
                FROM 
                    users u 
                LEFT JOIN 
                    orders o ON u.id = o.user_id 
                GROUP BY 
                    u.id 
                LIMIT 10
            ");
            $userOrders = $stmt->fetchAll(PDO::FETCH_ASSOC);

            echo "<h3>علاقة المستخدمين بالطلبات:</h3>";
            if (count($userOrders) > 0) {
                echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
                echo "<tr><th>معرف المستخدم</th><th>اسم المستخدم</th><th>الاسم الكامل</th><th>عدد الطلبات</th></tr>";
                foreach ($userOrders as $userOrder) {
                    echo "<tr>";
                    echo "<td>{$userOrder['user_id']}</td>";
                    echo "<td>{$userOrder['username']}</td>";
                    echo "<td>{$userOrder['full_name']}</td>";
                    echo "<td>{$userOrder['orders_count']}</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>لا توجد علاقات بين المستخدمين والطلبات</p>";
            }
        }
    }
} catch (PDOException $e) {
    echo "<p>حدث خطأ أثناء التحقق من قاعدة البيانات: " . $e->getMessage() . "</p>";
}
?>
