<?php
/**
 * ملف التكوين الرئيسي
 *
 * يحتوي هذا الملف على إعدادات النظام الأساسية
 *
 * @version 1.0
 * @author فريق التطوير
 */

// تعريف وضع التطوير
define('DEBUG_MODE', true);

// معلومات النظام
define('SYSTEM_NAME', 'نظام طلبات الشحن');
define('COMPANY_NAME', 'شركة الشحن');
define('SYSTEM_VERSION', '1.0.0');

// إعدادات قاعدة البيانات
define('DB_HOST', 'localhost'); // عادة ما يكون localhost في cPanel
define('DB_NAME', 'shipping_db'); // استبدل بـ اسم قاعدة البيانات التي أنشأتها
define('DB_USER', 'root'); // استبدل بـ اسم المستخدم الذي أنشأته
define('DB_PASS', ''); // استبدل بـ كلمة المرور التي حددتها
define('DB_CHARSET', 'utf8mb4');

// المسارات
define('BASE_URL', '');
define('ADMIN_URL', BASE_URL . '/admin');
define('ASSETS_URL', BASE_URL . '/assets');

// إعدادات الأمان
define('SESSION_LIFETIME', 3600); // مدة الجلسة بالثواني (ساعة واحدة)
define('CSRF_TOKEN_LIFETIME', 1800); // مدة صلاحية رمز CSRF بالثواني (30 دقيقة)

// إعدادات البريد الإلكتروني
define('MAIL_HOST', 'smtp.example.com');
define('MAIL_PORT', 587);
define('MAIL_USERNAME', 'info@example.com');
define('MAIL_PASSWORD', 'password');
define('MAIL_FROM', 'info@example.com');
define('MAIL_FROM_NAME', COMPANY_NAME);

// إعدادات التحميل
define('UPLOAD_DIR', __DIR__ . '/uploads');
define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024); // 5 ميجابايت
define('ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx', 'xls', 'xlsx']);

// إعدادات التصحيح
if (DEBUG_MODE) {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    error_reporting(0);
}
?>
