<?php
/**
 * ملف إعدادات قاعدة البيانات
 * 
 * هذا الملف يحتوي على إعدادات الاتصال بقاعدة البيانات
 * 
 * @version 1.0
 * @author فريق التطوير
 */

// منع الوصول المباشر للملف
if (basename($_SERVER['PHP_SELF']) === basename(__FILE__)) {
    header('HTTP/1.0 403 Forbidden');
    exit('الوصول المباشر لهذا الملف غير مسموح به');
}

// معلومات الاتصال بقاعدة البيانات MySQL
$db_host = 'localhost'; // عادة ما تكون localhost أو 127.0.0.1
$db_name = 'shipping_db'; // اسم قاعدة البيانات
$db_user = 'root'; // اسم المستخدم الافتراضي في XAMPP
$db_pass = ''; // كلمة المرور الافتراضية في XAMPP فارغة

// تحديد ما إذا كان يجب استخدام MySQL أو SQLite
$use_mysql = true; // تعيين القيمة إلى false لاستخدام SQLite

// معلومات الاتصال بقاعدة البيانات SQLite
$sqlite_db_file = __DIR__ . '/../database/shipping.sqlite';

// إعدادات الاتصال بقاعدة البيانات
$db_options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
    PDO::ATTR_PERSISTENT => true
];

// إعدادات النسخ الاحتياطي
$backup_path = __DIR__ . '/../backups';
$backup_max_files = 10;
$backup_frequency = 'daily'; // daily, weekly, monthly

// إعدادات التخزين المؤقت
$cache_enabled = true;
$cache_path = __DIR__ . '/../cache';
$cache_lifetime = 3600; // ساعة واحدة

// إعدادات الأمان
$db_encryption_key = 'your-encryption-key';
$db_encryption_method = 'aes-256-cbc';

// إعدادات الاتصال المتعدد
$db_max_connections = 10;
$db_connection_timeout = 30;
$db_idle_timeout = 60;

// إعدادات التسجيل
$db_log_enabled = true;
$db_log_path = __DIR__ . '/../logs/db.log';
$db_log_level = 'error'; // debug, info, warning, error, critical

// إعدادات الاستعلامات
$db_query_cache_enabled = true;
$db_query_cache_lifetime = 60; // ثانية
$db_query_timeout = 30; // ثانية

// إعدادات التحقق من الصحة
$db_validation_enabled = true;
$db_validation_rules = [
    'users' => [
        'username' => ['required', 'min:3', 'max:50', 'unique'],
        'email' => ['required', 'email', 'unique'],
        'password' => ['required', 'min:8', 'max:100'],
        'role' => ['required', 'in:admin,manager,employee,user']
    ],
    'orders' => [
        'order_number' => ['required', 'unique'],
        'client_name' => ['required', 'min:3', 'max:100'],
        'client_phone' => ['required', 'min:10', 'max:15'],
        'status' => ['required', 'in:pending,processing,shipped,delivered,cancelled,returned']
    ]
];

// إعدادات التحديثات
$db_update_enabled = true;
$db_update_path = __DIR__ . '/../database/updates';
$db_update_frequency = 'daily'; // daily, weekly, monthly

// إعدادات الترحيل
$db_migration_enabled = true;
$db_migration_path = __DIR__ . '/../database/migrations';
$db_migration_table = 'migrations';

// إعدادات البذور
$db_seed_enabled = true;
$db_seed_path = __DIR__ . '/../database/seeds';
$db_seed_table = 'seeds';

// إعدادات النماذج
$db_model_path = __DIR__ . '/../models';
$db_model_namespace = 'App\\Models';

// إعدادات الاستعلامات المخصصة
$db_custom_queries_path = __DIR__ . '/../database/queries';
$db_custom_queries_enabled = true;

// إعدادات التحقق من الصحة
$db_integrity_check_enabled = true;
$db_integrity_check_frequency = 'daily'; // daily, weekly, monthly

// إعدادات الأداء
$db_performance_monitoring_enabled = true;
$db_performance_monitoring_threshold = 1.0; // ثانية
$db_performance_monitoring_log_path = __DIR__ . '/../logs/db_performance.log';

// إعدادات التصحيح
$db_debug_enabled = DEVELOPMENT_MODE;
$db_debug_log_path = __DIR__ . '/../logs/db_debug.log';
$db_debug_log_level = 'debug'; // debug, info, warning, error, critical

// إعدادات الاسترداد
$db_recovery_enabled = true;
$db_recovery_path = __DIR__ . '/../database/recovery';
$db_recovery_max_attempts = 3;

// إعدادات التوثيق
$db_documentation_enabled = true;
$db_documentation_path = __DIR__ . '/../docs/database';
$db_documentation_format = 'markdown'; // markdown, html, pdf

// إعدادات الإصدار
$db_version = '1.0.0';
$db_build = '20230101';
$db_release_date = '2023-01-01';
$db_release_notes = 'الإصدار الأول من قاعدة البيانات';

// التأكد من وجود المجلدات الضرورية
if (!is_dir($backup_path)) {
    mkdir($backup_path, 0755, true);
}

if ($cache_enabled && !is_dir($cache_path)) {
    mkdir($cache_path, 0755, true);
}

if ($db_log_enabled && !is_dir(dirname($db_log_path))) {
    mkdir(dirname($db_log_path), 0755, true);
}

// إرجاع إعدادات قاعدة البيانات
return [
    'host' => $db_host,
    'name' => $db_name,
    'user' => $db_user,
    'pass' => $db_pass,
    'use_mysql' => $use_mysql,
    'sqlite_file' => $sqlite_db_file,
    'options' => $db_options,
    'backup' => [
        'path' => $backup_path,
        'max_files' => $backup_max_files,
        'frequency' => $backup_frequency
    ],
    'cache' => [
        'enabled' => $cache_enabled,
        'path' => $cache_path,
        'lifetime' => $cache_lifetime
    ],
    'security' => [
        'encryption_key' => $db_encryption_key,
        'encryption_method' => $db_encryption_method
    ],
    'connection' => [
        'max_connections' => $db_max_connections,
        'connection_timeout' => $db_connection_timeout,
        'idle_timeout' => $db_idle_timeout
    ],
    'logging' => [
        'enabled' => $db_log_enabled,
        'path' => $db_log_path,
        'level' => $db_log_level
    ],
    'query' => [
        'cache_enabled' => $db_query_cache_enabled,
        'cache_lifetime' => $db_query_cache_lifetime,
        'timeout' => $db_query_timeout
    ],
    'validation' => [
        'enabled' => $db_validation_enabled,
        'rules' => $db_validation_rules
    ],
    'update' => [
        'enabled' => $db_update_enabled,
        'path' => $db_update_path,
        'frequency' => $db_update_frequency
    ],
    'migration' => [
        'enabled' => $db_migration_enabled,
        'path' => $db_migration_path,
        'table' => $db_migration_table
    ],
    'seed' => [
        'enabled' => $db_seed_enabled,
        'path' => $db_seed_path,
        'table' => $db_seed_table
    ],
    'model' => [
        'path' => $db_model_path,
        'namespace' => $db_model_namespace
    ],
    'custom_queries' => [
        'enabled' => $db_custom_queries_enabled,
        'path' => $db_custom_queries_path
    ],
    'integrity' => [
        'enabled' => $db_integrity_check_enabled,
        'frequency' => $db_integrity_check_frequency
    ],
    'performance' => [
        'enabled' => $db_performance_monitoring_enabled,
        'threshold' => $db_performance_monitoring_threshold,
        'log_path' => $db_performance_monitoring_log_path
    ],
    'debug' => [
        'enabled' => $db_debug_enabled,
        'log_path' => $db_debug_log_path,
        'log_level' => $db_debug_log_level
    ],
    'recovery' => [
        'enabled' => $db_recovery_enabled,
        'path' => $db_recovery_path,
        'max_attempts' => $db_recovery_max_attempts
    ],
    'documentation' => [
        'enabled' => $db_documentation_enabled,
        'path' => $db_documentation_path,
        'format' => $db_documentation_format
    ],
    'version' => [
        'version' => $db_version,
        'build' => $db_build,
        'release_date' => $db_release_date,
        'release_notes' => $db_release_notes
    ]
];
