<?php
/**
 * ملف تكوين الأمان
 * يستخدم هذا الملف لتكوين إعدادات الأمان للنظام
 */

// تضمين ملف التكوين الذي يحتوي على دوال CSRF وتنظيف المدخلات
// تم تعليق هذا السطر لأن ملف config.php يتم استدعاؤه بالفعل في ملف login.php
// require_once __DIR__ . '/config.php';

// تكوين الجلسة
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    ini_set('session.cookie_secure', 1);
}
ini_set('session.cookie_samesite', 'Strict');
ini_set('session.gc_maxlifetime', 3600); // مدة الجلسة: ساعة واحدة

// بدء الجلسة إذا لم تكن قد بدأت بالفعل
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ملاحظة: تم نقل دوال CSRF وتنظيف المدخلات إلى ملف config.php لتجنب التكرار

// دالة للتحقق من صحة البريد الإلكتروني
function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

// دالة للتحقق من قوة كلمة المرور
function validatePassword($password) {
    // كلمة المرور يجب أن تكون على الأقل 8 أحرف
    if (strlen($password) < 8) {
        return false;
    }

    // كلمة المرور يجب أن تحتوي على حرف كبير واحد على الأقل
    if (!preg_match('/[A-Z]/', $password)) {
        return false;
    }

    // كلمة المرور يجب أن تحتوي على حرف صغير واحد على الأقل
    if (!preg_match('/[a-z]/', $password)) {
        return false;
    }

    // كلمة المرور يجب أن تحتوي على رقم واحد على الأقل
    if (!preg_match('/[0-9]/', $password)) {
        return false;
    }

    return true;
}

// دالة لتشفير كلمة المرور
function hashPassword($password) {
    return password_hash($password, PASSWORD_DEFAULT);
}

// دالة للتحقق من كلمة المرور
function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}

// ملاحظة: تم نقل دوال isLoggedIn و hasPermission إلى ملف config.php لتجنب التكرار

// دالة لتسجيل خروج المستخدم
function logout() {
    // تدمير جميع بيانات الجلسة
    $_SESSION = [];

    // تدمير ملف تعريف ارتباط الجلسة
    if (ini_get('session.use_cookies')) {
        $params = session_get_cookie_params();
        setcookie(
            session_name(),
            '',
            time() - 42000,
            $params['path'],
            $params['domain'],
            $params['secure'],
            $params['httponly']
        );
    }

    // تدمير الجلسة
    session_destroy();
}

// ملاحظة: تم نقل دوال redirectIfNotLoggedIn و redirectIfLoggedIn إلى ملف config.php لتجنب التكرار
?>
