<?php
/**
 * ملف إضافة الفهارس لتحسين أداء قاعدة البيانات
 * يقوم هذا الملف بتنفيذ ملف SQL الخاص بإضافة الفهارس
 * 
 * @version 1.0
 * @author فريق التطوير
 */

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/database.php';

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// دالة لتنفيذ ملف SQL
function executeSqlFile($pdo, $file) {
    try {
        // قراءة محتوى ملف SQL
        $sql = file_get_contents($file);
        
        // تقسيم الملف إلى استعلامات منفصلة
        $queries = explode(';', $sql);
        
        // تنفيذ كل استعلام على حدة
        foreach ($queries as $query) {
            $query = trim($query);
            
            // تخطي الاستعلامات الفارغة والتعليقات
            if (empty($query) || strpos($query, '--') === 0) {
                continue;
            }
            
            // تنفيذ الاستعلام
            $pdo->exec($query);
        }
        
        return [
            'success' => true,
            'message' => 'تم تنفيذ ملف SQL بنجاح'
        ];
    } catch (PDOException $e) {
        return [
            'success' => false,
            'message' => 'حدث خطأ أثناء تنفيذ ملف SQL: ' . $e->getMessage()
        ];
    }
}

// مسار ملف SQL الخاص بإضافة الفهارس
$sqlFile = __DIR__ . '/add_indexes.sql';

// التحقق من وجود ملف SQL
if (!file_exists($sqlFile)) {
    die('ملف SQL غير موجود: ' . $sqlFile);
}

// تنفيذ ملف SQL
$result = executeSqlFile($conn, $sqlFile);

// عرض نتيجة التنفيذ
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إضافة الفهارس لتحسين أداء قاعدة البيانات</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            color: #4f46e5;
            margin-bottom: 20px;
        }
        .alert {
            margin-top: 20px;
        }
        .btn-primary {
            background-color: #4f46e5;
            border-color: #4f46e5;
        }
        .btn-primary:hover {
            background-color: #4338ca;
            border-color: #4338ca;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4">إضافة الفهارس لتحسين أداء قاعدة البيانات</h1>
        
        <?php if ($result['success']): ?>
            <div class="alert alert-success">
                <h4 class="alert-heading">تم بنجاح!</h4>
                <p><?php echo $result['message']; ?></p>
                <hr>
                <p class="mb-0">تم إضافة الفهارس بنجاح لتحسين أداء قاعدة البيانات. ستلاحظ تحسنًا في سرعة تحميل الصفحات وأداء الاستعلامات.</p>
            </div>
        <?php else: ?>
            <div class="alert alert-danger">
                <h4 class="alert-heading">حدث خطأ!</h4>
                <p><?php echo $result['message']; ?></p>
                <hr>
                <p class="mb-0">يرجى التحقق من ملف SQL والمحاولة مرة أخرى.</p>
            </div>
        <?php endif; ?>
        
        <div class="text-center mt-4">
            <a href="../unified-dashboard.php" class="btn btn-primary">العودة إلى لوحة التحكم</a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
