<?php
// تضمين ملف الاتصال بقاعدة البيانات
require_once __DIR__ . '/../config/db_connection.php';

// تحديد ما إذا كان يجب إعادة إنشاء الجداول
$recreateTables = true;

try {
    // استخدام الاتصال الموجود في ملف db_connection.php
    global $conn, $pdo;

    // إنشاء قاعدة البيانات إذا لم تكن موجودة
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "تم إنشاء قاعدة البيانات $dbname بنجاح أو كانت موجودة بالفعل.\n";

    // استخدام قاعدة البيانات
    $pdo->exec("USE `$dbname`");

    // إذا كان يجب إعادة إنشاء الجداول، قم بحذفها أولاً
    if ($recreateTables) {
        // حذف الجداول بترتيب عكسي لتجنب مشاكل المفاتيح الأجنبية
        $pdo->exec("DROP TABLE IF EXISTS `archived_orders`");
        $pdo->exec("DROP TABLE IF EXISTS `orders`");
        $pdo->exec("DROP TABLE IF EXISTS `order_sequences`");
        $pdo->exec("DROP TABLE IF EXISTS `branches`");
        echo "تم حذف الجداول الموجودة بنجاح.\n";
    }

    // قراءة ملف SQL لإنشاء جدول الطلبات
    $ordersTableSQL = file_get_contents(__DIR__ . '/create_orders_table.sql');

    // تنفيذ استعلامات SQL لإنشاء جدول الطلبات
    $pdo->exec($ordersTableSQL);
    echo "تم إنشاء جدول الطلبات بنجاح.\n";

    // قراءة ملف SQL لإنشاء جدول تسلسل أرقام الطلبات
    $orderSequencesTableSQL = file_get_contents(__DIR__ . '/create_order_sequences_table.sql');

    // تنفيذ استعلامات SQL لإنشاء جدول تسلسل أرقام الطلبات
    $pdo->exec($orderSequencesTableSQL);
    echo "تم إنشاء جدول تسلسل أرقام الطلبات بنجاح.\n";

    // قراءة ملف SQL لإنشاء جدول المستخدمين
    $usersTableSQL = file_get_contents(__DIR__ . '/create_users_table.sql');

    // تنفيذ استعلامات SQL لإنشاء جدول المستخدمين
    $pdo->exec($usersTableSQL);
    echo "تم إنشاء جدول المستخدمين بنجاح.\n";

    echo "تم إنشاء جميع الجداول بنجاح.\n";

} catch (PDOException $e) {
    // عرض رسالة الخطأ
    echo "خطأ في إنشاء قاعدة البيانات أو الجداول: " . $e->getMessage() . "\n";
}
?>
