<?php
/**
 * ملف تنفيذ استعلامات SQL
 * يستخدم هذا الملف لتنفيذ ملفات SQL
 */

// تفعيل عرض الأخطاء
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once __DIR__ . '/../config/database.php';

// مسار ملف SQL
$sqlFile = __DIR__ . '/settings_permissions_tables.sql';

// التحقق من وجود الملف
if (!file_exists($sqlFile)) {
    die("خطأ: ملف SQL غير موجود في المسار: $sqlFile");
}

// قراءة محتوى الملف
$sql = file_get_contents($sqlFile);

// تقسيم الاستعلامات
$queries = explode(';', $sql);

// تنفيذ الاستعلامات
$success = true;
$errorMessages = [];

foreach ($queries as $query) {
    $query = trim($query);
    
    if (empty($query)) {
        continue;
    }
    
    try {
        $result = $pdo->exec($query);
        echo "تم تنفيذ الاستعلام بنجاح.<br>";
    } catch (PDOException $e) {
        $success = false;
        $errorMessages[] = $e->getMessage();
        echo "خطأ في تنفيذ الاستعلام: " . $e->getMessage() . "<br>";
    }
}

// عرض النتيجة النهائية
if ($success) {
    echo "<h2 style='color: green;'>تم تنفيذ جميع الاستعلامات بنجاح!</h2>";
} else {
    echo "<h2 style='color: red;'>حدثت أخطاء أثناء تنفيذ الاستعلامات:</h2>";
    echo "<ul>";
    foreach ($errorMessages as $error) {
        echo "<li>$error</li>";
    }
    echo "</ul>";
}
?>
