-- ملف قاعدة البيانات الموحد النهائي
-- تم توحيد جميع ملفات قاعدة البيانات في هذا الملف
-- آخر تحديث: 15/05/2025

-- إنشاء قاعدة البيانات إذا لم تكن موجودة
CREATE DATABASE IF NOT EXISTS `shipping_db` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- استخدام قاعدة البيانات
USE `shipping_db`;

-- إنشاء جدول الفروع
CREATE TABLE IF NOT EXISTS `branches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(10) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `manager` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج البيانات الأولية لجدول الفروع
INSERT IGNORE INTO `branches` (`name`, `code`, `address`, `phone`, `is_active`) VALUES
('فرع عدن', 'ADN', 'عدن - المنصورة', '777123456', 1),
('فرع صنعاء', 'SNA', 'صنعاء - شارع الستين', '777654321', 1),
('فرع المكلا', 'MKL', 'المكلا - الشرج', '777987654', 1),
('فرع الصين', 'CN', 'قوانزو - الصين', '777456789', 1),
('فرع شحن', 'SH', 'شحن - حضرموت', '777789123', 1);

-- إنشاء جدول تسلسل أرقام الطلبات
CREATE TABLE IF NOT EXISTS `order_sequences` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `branch_code` VARCHAR(10) NOT NULL UNIQUE COMMENT 'رمز الفرع',
  `last_sequence_number` INT NOT NULL DEFAULT 0 COMMENT 'آخر رقم تسلسلي',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج البيانات الأولية لجدول تسلسل أرقام الطلبات
INSERT IGNORE INTO `order_sequences` (`branch_code`, `last_sequence_number`) VALUES
('ADN', 0),
('SNA', 0),
('MKL', 0),
('CN', 0),
('SH', 0);

-- إنشاء جدول المستخدمين
CREATE TABLE IF NOT EXISTS `users` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `username` VARCHAR(50) NOT NULL UNIQUE COMMENT 'اسم المستخدم',
  `password` VARCHAR(255) NOT NULL COMMENT 'كلمة المرور',
  `full_name` VARCHAR(100) NOT NULL COMMENT 'الاسم الكامل',
  `email` VARCHAR(100) UNIQUE COMMENT 'البريد الإلكتروني',
  `phone` VARCHAR(20) COMMENT 'رقم الهاتف',
  `role` ENUM('admin', 'manager', 'employee', 'client') NOT NULL DEFAULT 'employee' COMMENT 'دور المستخدم',
  `branch_id` INT COMMENT 'معرف الفرع',
  `is_active` TINYINT(1) DEFAULT 1 COMMENT 'هل المستخدم نشط',
  `status` ENUM('pending', 'active', 'inactive') NOT NULL DEFAULT 'pending' COMMENT 'حالة المستخدم',
  `registration_date` TIMESTAMP NULL DEFAULT NULL COMMENT 'تاريخ التسجيل',
  `last_login` DATETIME COMMENT 'آخر تسجيل دخول',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث',
  FOREIGN KEY (`branch_id`) REFERENCES `branches`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء مستخدم افتراضي للمسؤول (كلمة المرور: admin123)
INSERT IGNORE INTO `users` (`username`, `password`, `full_name`, `email`, `role`, `is_active`, `status`)
VALUES ('admin', '$2y$10$5VgXuQKKW.tNOhcLBX2TkuH2U5f2CwGQ/f.MJPVqOvnZcI0qQE9Ni', 'مدير النظام', 'admin@example.com', 'admin', 1, 'active');

-- إنشاء جدول الطلبات
CREATE TABLE IF NOT EXISTS `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(20) NOT NULL,
  `client_name` varchar(100) NOT NULL,
  `service_type` varchar(50) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `departure_area` varchar(100) DEFAULT NULL,
  `second_destination` varchar(100) DEFAULT NULL,
  `delivery_area` varchar(100) DEFAULT NULL,
  `goods_name` varchar(100) DEFAULT NULL,
  `goods_type` varchar(50) DEFAULT NULL,
  `country_of_origin` varchar(50) DEFAULT NULL,
  `weight` decimal(10,2) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `unit` varchar(20) DEFAULT NULL,
  `service_fees` decimal(10,2) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `payment_type` varchar(20) DEFAULT NULL,
  `delivery_duration` varchar(50) DEFAULT NULL,
  `amount_paid` decimal(10,2) DEFAULT NULL,
  `remaining_amount` decimal(10,2) DEFAULT NULL,
  `order_upload_date` date DEFAULT NULL,
  `scheduled_delivery_date` date DEFAULT NULL,
  `recipient_name` varchar(100) DEFAULT NULL,
  `phone_number` varchar(20) DEFAULT NULL,
  `delivery_company` varchar(100) DEFAULT NULL,
  `employee_name` varchar(100) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `amount_agreed_with_customer` decimal(10,2) DEFAULT NULL,
  `amount_agreed_with_agent` decimal(10,2) DEFAULT NULL,
  `other_expenses` decimal(10,2) DEFAULT NULL,
  `profit` decimal(10,2) DEFAULT NULL,
  `payment_status` enum('مدفوع','جزئي','غير مدفوع') DEFAULT 'غير مدفوع',
  `status` enum('قيد المعالجة','في الطريق','تم التسليم','ملغى') DEFAULT 'قيد المعالجة',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `archived` tinyint(1) NOT NULL DEFAULT 0,
  `archive_date` date DEFAULT NULL,
  `user_id` INT COMMENT 'معرف المستخدم الذي أنشأ الطلب',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_number` (`order_number`),
  KEY `branch_id` (`branch_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL,
  CONSTRAINT `orders_user_id_fk` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء جدول أرشيف الطلبات
CREATE TABLE IF NOT EXISTS `archived_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `order_number` varchar(20) NOT NULL,
  `client_name` varchar(100) NOT NULL,
  `service_type` varchar(50) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `departure_area` varchar(100) DEFAULT NULL,
  `second_destination` varchar(100) DEFAULT NULL,
  `delivery_area` varchar(100) DEFAULT NULL,
  `goods_name` varchar(100) DEFAULT NULL,
  `goods_type` varchar(50) DEFAULT NULL,
  `country_of_origin` varchar(50) DEFAULT NULL,
  `weight` decimal(10,2) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `unit` varchar(20) DEFAULT NULL,
  `service_fees` decimal(10,2) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `payment_type` varchar(20) DEFAULT NULL,
  `delivery_duration` varchar(50) DEFAULT NULL,
  `amount_paid` decimal(10,2) DEFAULT NULL,
  `remaining_amount` decimal(10,2) DEFAULT NULL,
  `order_upload_date` date DEFAULT NULL,
  `scheduled_delivery_date` date DEFAULT NULL,
  `recipient_name` varchar(100) DEFAULT NULL,
  `phone_number` varchar(20) DEFAULT NULL,
  `delivery_company` varchar(100) DEFAULT NULL,
  `employee_name` varchar(100) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `amount_agreed_with_customer` decimal(10,2) DEFAULT NULL,
  `amount_agreed_with_agent` decimal(10,2) DEFAULT NULL,
  `other_expenses` decimal(10,2) DEFAULT NULL,
  `profit` decimal(10,2) DEFAULT NULL,
  `payment_status` enum('مدفوع','جزئي','غير مدفوع') DEFAULT 'غير مدفوع',
  `status` enum('قيد المعالجة','في الطريق','تم التسليم','ملغى') DEFAULT 'قيد المعالجة',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `archived_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_id` INT COMMENT 'معرف المستخدم الذي أنشأ الطلب',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء جدول الدول
CREATE TABLE IF NOT EXISTS `countries` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(100) NOT NULL COMMENT 'اسم الدولة',
  `code` VARCHAR(3) NOT NULL UNIQUE COMMENT 'رمز الدولة',
  `flag` VARCHAR(255) COMMENT 'مسار علم الدولة',
  `is_active` TINYINT(1) DEFAULT 1 COMMENT 'هل الدولة نشطة',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج بعض الدول الافتراضية
INSERT IGNORE INTO `countries` (`name`, `code`, `flag`, `is_active`) VALUES
('اليمن', 'YE', 'assets/images/flags/yemen.png', 1),
('السعودية', 'SA', 'assets/images/flags/saudi-arabia.png', 1),
('الإمارات', 'AE', 'assets/images/flags/uae.png', 1),
('الصين', 'CN', 'assets/images/flags/china.png', 1),
('مصر', 'EG', 'assets/images/flags/egypt.png', 1),
('عمان', 'OM', 'assets/images/flags/oman.png', 1),
('قطر', 'QA', 'assets/images/flags/qatar.png', 1),
('الكويت', 'KW', 'assets/images/flags/kuwait.png', 1),
('البحرين', 'BH', 'assets/images/flags/bahrain.png', 1);

-- إنشاء جدول لتخزين إعدادات النظام
CREATE TABLE IF NOT EXISTS `system_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(50) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج الإعدادات الافتراضية
INSERT IGNORE INTO `system_settings` (`setting_key`, `setting_value`, `description`) VALUES
('system_name', 'نظام طلبات الشحن', 'اسم النظام'),
('company_name', 'شركة الشحن', 'اسم الشركة'),
('company_logo', 'assets/images/backgrounds/background.png', 'شعار الشركة'),
('currency', 'ريال يمني', 'العملة الافتراضية'),
('auto_archive_days', '30', 'عدد الأيام قبل أرشفة الطلبات تلقائياً');

-- إنشاء جدول سجل النشاط
CREATE TABLE IF NOT EXISTS `activity_log` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT COMMENT 'معرف المستخدم',
  `action` VARCHAR(100) NOT NULL COMMENT 'الإجراء',
  `entity_type` VARCHAR(50) COMMENT 'نوع الكيان',
  `entity_id` INT COMMENT 'معرف الكيان',
  `details` TEXT COMMENT 'تفاصيل النشاط',
  `ip_address` VARCHAR(45) COMMENT 'عنوان IP',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ملاحظة: تم توحيد جميع الجداول والبيانات الأولية في هذا الملف
-- يمكن استخدام هذا الملف لإنشاء قاعدة البيانات من البداية
