<?php
/**
 * ملف إعداد قاعدة البيانات للاستضافة على cPanel
 * يستخدم هذا الملف لإعداد قاعدة البيانات عند تثبيت النظام على استضافة cPanel
 * 
 * @version 1.0
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تعيين وقت التنفيذ الأقصى
set_time_limit(300);

// تعيين حد الذاكرة
ini_set('memory_limit', '256M');

// تحديد المسار الأساسي للمشروع
$base_path = realpath(__DIR__ . '/..');

// تضمين ملف التكوين
require_once $base_path . '/config/config.php';

// التحقق من الأمان - يمكن تعديل هذا الجزء حسب احتياجاتك
$security_token = 'ASDRF43_SECURE_TOKEN'; // قم بتغيير هذا إلى رمز أمان قوي خاص بك
$is_secure = false;

// التحقق من وجود رمز الأمان في الطلب
if (isset($_GET['token']) && $_GET['token'] === $security_token) {
    $is_secure = true;
}

// دالة للتحقق من وجود قاعدة البيانات
function databaseExists($host, $user, $pass, $dbname) {
    try {
        $pdo = new PDO("mysql:host=$host", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $stmt = $pdo->query("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '$dbname'");
        return $stmt->rowCount() > 0;
    } catch (PDOException $e) {
        return false;
    }
}

// دالة للتحقق من وجود جدول
function tableExists($pdo, $table) {
    try {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        return $stmt->rowCount() > 0;
    } catch (PDOException $e) {
        return false;
    }
}

// دالة لتنفيذ ملف SQL
function executeSqlFile($pdo, $file_path) {
    try {
        if (!file_exists($file_path)) {
            return [
                'status' => 'error',
                'message' => "الملف $file_path غير موجود"
            ];
        }
        
        $sql = file_get_contents($file_path);
        
        // تقسيم الملف إلى استعلامات منفصلة
        $queries = explode(';', $sql);
        
        foreach ($queries as $query) {
            $query = trim($query);
            
            if (!empty($query)) {
                $pdo->exec($query);
            }
        }
        
        return [
            'status' => 'success',
            'message' => "تم تنفيذ الملف $file_path بنجاح"
        ];
    } catch (PDOException $e) {
        return [
            'status' => 'error',
            'message' => "خطأ في تنفيذ الملف $file_path: " . $e->getMessage()
        ];
    }
}

// دالة لإنشاء قاعدة البيانات وجداولها
function setupDatabase($host, $user, $pass, $dbname) {
    try {
        // الاتصال بالخادم
        $pdo = new PDO("mysql:host=$host", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // إنشاء قاعدة البيانات إذا لم تكن موجودة
        if (!databaseExists($host, $user, $pass, $dbname)) {
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $results[] = [
                'status' => 'success',
                'message' => "تم إنشاء قاعدة البيانات $dbname بنجاح"
            ];
        } else {
            $results[] = [
                'status' => 'info',
                'message' => "قاعدة البيانات $dbname موجودة بالفعل"
            ];
        }
        
        // استخدام قاعدة البيانات
        $pdo->exec("USE `$dbname`");
        
        // تنفيذ ملف قاعدة البيانات الموحد
        $sql_file = __DIR__ . '/final_unified_database.sql';
        $results[] = executeSqlFile($pdo, $sql_file);
        
        // التحقق من وجود الجداول بعد التنفيذ
        $tables = ['branches', 'order_sequences', 'orders', 'archived_orders', 'users', 'system_settings', 'permissions', 'roles'];
        foreach ($tables as $table) {
            $exists = tableExists($pdo, $table);
            $results[] = [
                'status' => $exists ? 'success' : 'warning',
                'message' => 'جدول ' . $table . ': ' . ($exists ? 'تم إنشاؤه بنجاح' : 'لم يتم إنشاؤه')
            ];
        }
        
        return [
            'status' => 'success',
            'message' => 'تم إعداد قاعدة البيانات بنجاح',
            'details' => $results
        ];
    } catch (PDOException $e) {
        return [
            'status' => 'error',
            'message' => 'خطأ في إعداد قاعدة البيانات: ' . $e->getMessage()
        ];
    }
}

// معالجة الطلب
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $is_secure) {
    // الحصول على بيانات الاتصال من النموذج
    $host = $_POST['db_host'] ?? 'localhost';
    $dbname = $_POST['db_name'] ?? '';
    $username = $_POST['db_user'] ?? '';
    $password = $_POST['db_pass'] ?? '';
    
    // التحقق من وجود البيانات المطلوبة
    if (empty($dbname) || empty($username)) {
        $response = [
            'status' => 'error',
            'message' => 'يرجى تقديم جميع بيانات الاتصال المطلوبة'
        ];
    } else {
        // إعداد قاعدة البيانات
        $response = setupDatabase($host, $username, $password, $dbname);
        
        // إذا نجحت العملية، قم بتحديث ملف بيانات الاتصال
        if ($response['status'] === 'success') {
            $credentials_content = <<<EOT
<?php
/**
 * ملف بيانات الاتصال بقاعدة البيانات للاستضافة على cPanel
 * تم إنشاؤه تلقائيًا بواسطة أداة إعداد قاعدة البيانات
 */

// تعريف ثابت للتحقق من أن الملف تم استدعاؤه من ملف التكوين الرئيسي
if (!defined('SECURE_ACCESS')) {
    // منع الوصول المباشر إلى هذا الملف
    header('HTTP/1.0 403 Forbidden');
    exit('الوصول غير مصرح به');
}

// إعدادات الاتصال بقاعدة البيانات في cPanel
return [
    'db_host' => '$host',
    'db_name' => '$dbname',
    'db_user' => '$username',
    'db_pass' => '$password',
    'use_mysql' => true,
    'sqlite_db_file' => __DIR__ . '/../database/shipping.sqlite'
];
EOT;
            
            $credentials_file = $base_path . '/config/db_credentials.php';
            if (file_put_contents($credentials_file, $credentials_content)) {
                $response['message'] .= ' وتم تحديث ملف بيانات الاتصال';
            } else {
                $response['message'] .= ' ولكن فشل تحديث ملف بيانات الاتصال';
            }
        }
    }
    
    // إرجاع الاستجابة كـ JSON
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعداد قاعدة البيانات للاستضافة على cPanel</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Tajawal', sans-serif;
            padding: 20px;
        }
        .setup-container {
            max-width: 800px;
            margin: 0 auto;
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            padding: 2rem;
        }
        .form-group {
            margin-bottom: 1rem;
        }
        .alert {
            margin-top: 1rem;
        }
        .btn-primary {
            background-color: #0d6efd;
        }
    </style>
</head>
<body>
    <div class="setup-container">
        <h1 class="mb-4">إعداد قاعدة البيانات للاستضافة على cPanel</h1>
        
        <?php if (!$is_secure): ?>
        <div class="alert alert-warning">
            <strong>تنبيه:</strong> يجب تقديم رمز الأمان للوصول إلى هذه الصفحة.
            <p>استخدم الرابط التالي: <code><?php echo $_SERVER['PHP_SELF']; ?>?token=ASDRF43_SECURE_TOKEN</code></p>
        </div>
        <?php else: ?>
        <div class="alert alert-info">
            <strong>ملاحظة:</strong> استخدم هذه الأداة لإعداد قاعدة البيانات عند تثبيت النظام على استضافة cPanel.
        </div>
        
        <form id="setupForm" method="post">
            <div class="form-group">
                <label for="db_host">خادم قاعدة البيانات:</label>
                <input type="text" class="form-control" id="db_host" name="db_host" value="localhost" required>
                <small class="form-text text-muted">عادة ما يكون "localhost" في استضافة cPanel</small>
            </div>
            
            <div class="form-group">
                <label for="db_name">اسم قاعدة البيانات:</label>
                <input type="text" class="form-control" id="db_name" name="db_name" required>
                <small class="form-text text-muted">اسم قاعدة البيانات التي أنشأتها في cPanel</small>
            </div>
            
            <div class="form-group">
                <label for="db_user">اسم المستخدم:</label>
                <input type="text" class="form-control" id="db_user" name="db_user" required>
                <small class="form-text text-muted">اسم المستخدم الذي أنشأته في cPanel</small>
            </div>
            
            <div class="form-group">
                <label for="db_pass">كلمة المرور:</label>
                <input type="password" class="form-control" id="db_pass" name="db_pass" required>
                <small class="form-text text-muted">كلمة المرور التي حددتها في cPanel</small>
            </div>
            
            <button type="submit" class="btn btn-primary">إعداد قاعدة البيانات</button>
        </form>
        
        <div id="result" class="mt-4"></div>
        
        <script>
            document.getElementById('setupForm').addEventListener('submit', function(e) {
                e.preventDefault();
                
                const form = this;
                const resultDiv = document.getElementById('result');
                
                resultDiv.innerHTML = '<div class="alert alert-info">جاري إعداد قاعدة البيانات...</div>';
                
                fetch(form.action + '?token=<?php echo $security_token; ?>', {
                    method: 'POST',
                    body: new FormData(form)
                })
                .then(response => response.json())
                .then(data => {
                    let alertClass = 'alert-success';
                    if (data.status === 'error') {
                        alertClass = 'alert-danger';
                    } else if (data.status === 'warning') {
                        alertClass = 'alert-warning';
                    }
                    
                    let resultHtml = `<div class="alert ${alertClass}">${data.message}</div>`;
                    
                    if (data.details) {
                        resultHtml += '<h4 class="mt-3">تفاصيل العملية:</h4>';
                        resultHtml += '<ul class="list-group">';
                        
                        data.details.forEach(detail => {
                            let itemClass = 'list-group-item';
                            if (detail.status === 'success') {
                                itemClass += ' list-group-item-success';
                            } else if (detail.status === 'error') {
                                itemClass += ' list-group-item-danger';
                            } else if (detail.status === 'warning') {
                                itemClass += ' list-group-item-warning';
                            } else if (detail.status === 'info') {
                                itemClass += ' list-group-item-info';
                            }
                            
                            resultHtml += `<li class="${itemClass}">${detail.message}</li>`;
                        });
                        
                        resultHtml += '</ul>';
                    }
                    
                    resultDiv.innerHTML = resultHtml;
                })
                .catch(error => {
                    resultDiv.innerHTML = `<div class="alert alert-danger">حدث خطأ: ${error.message}</div>`;
                });
            });
        </script>
        <?php endif; ?>
    </div>
</body>
</html>
