<?php
/**
 * ملف إعداد قاعدة البيانات الموحد
 * 
 * يقوم هذا الملف بإنشاء قاعدة البيانات وجداولها وإدراج البيانات الأولية
 * 
 * @version 1.0
 * @author فريق التطوير
 */

// تفعيل عرض الأخطاء
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تعيين الحد الأقصى لوقت التنفيذ
set_time_limit(300);

// تعيين منطقة زمنية افتراضية
date_default_timezone_set('Asia/Riyadh');

// معلومات الاتصال بقاعدة البيانات
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'shipping_db';
$db_charset = 'utf8mb4';

// مسار ملف SQL
$sql_file = __DIR__ . '/final_unified_database.sql';

// التحقق من وجود ملف SQL
if (!file_exists($sql_file)) {
    die("خطأ: ملف SQL غير موجود في المسار: $sql_file");
}

// عرض رأس الصفحة
echo '<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعداد قاعدة البيانات</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 20px;
            background-color: #f5f5f5;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }
        .success {
            color: #27ae60;
            background-color: #d5f5e3;
            padding: 10px;
            border-radius: 5px;
            margin: 10px 0;
        }
        .error {
            color: #c0392b;
            background-color: #f8d7da;
            padding: 10px;
            border-radius: 5px;
            margin: 10px 0;
        }
        .info {
            color: #2980b9;
            background-color: #d6eaf8;
            padding: 10px;
            border-radius: 5px;
            margin: 10px 0;
        }
        pre {
            background-color: #f9f9f9;
            padding: 10px;
            border-radius: 5px;
            overflow-x: auto;
        }
        .btn {
            display: inline-block;
            background-color: #3498db;
            color: #fff;
            padding: 10px 15px;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
        .btn:hover {
            background-color: #2980b9;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>إعداد قاعدة البيانات الموحد</h1>';

// محاولة الاتصال بالخادم
try {
    echo '<div class="info">جاري الاتصال بخادم قاعدة البيانات...</div>';
    
    // إنشاء اتصال بالخادم بدون تحديد قاعدة بيانات
    $pdo = new PDO("mysql:host=$db_host;charset=$db_charset", $db_user, $db_pass);
    
    // تعيين وضع الأخطاء
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo '<div class="success">تم الاتصال بخادم قاعدة البيانات بنجاح.</div>';
    
    // قراءة ملف SQL
    echo '<div class="info">جاري قراءة ملف SQL...</div>';
    $sql = file_get_contents($sql_file);
    
    if (!$sql) {
        throw new Exception("فشل في قراءة ملف SQL.");
    }
    
    echo '<div class="success">تم قراءة ملف SQL بنجاح.</div>';
    
    // تنفيذ استعلامات SQL
    echo '<div class="info">جاري تنفيذ استعلامات SQL...</div>';
    
    // تقسيم الملف إلى استعلامات منفصلة
    $queries = explode(';', $sql);
    $total_queries = count($queries);
    $executed_queries = 0;
    
    foreach ($queries as $query) {
        $query = trim($query);
        
        if (empty($query)) {
            continue;
        }
        
        try {
            $pdo->exec($query);
            $executed_queries++;
        } catch (PDOException $e) {
            echo '<div class="error">خطأ في تنفيذ الاستعلام: ' . htmlspecialchars($e->getMessage()) . '</div>';
            echo '<pre>' . htmlspecialchars($query) . '</pre>';
        }
    }
    
    echo '<div class="success">تم تنفيذ ' . $executed_queries . ' من أصل ' . $total_queries . ' استعلام بنجاح.</div>';
    
    // التحقق من إنشاء قاعدة البيانات والجداول
    echo '<div class="info">جاري التحقق من إنشاء قاعدة البيانات والجداول...</div>';
    
    // الاتصال بقاعدة البيانات المحددة
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=$db_charset", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // الحصول على قائمة الجداول
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    
    echo '<div class="success">تم إنشاء قاعدة البيانات وعدد الجداول: ' . count($tables) . '</div>';
    
    echo '<div class="info">الجداول التي تم إنشاؤها:</div>';
    echo '<ul>';
    foreach ($tables as $table) {
        echo '<li>' . htmlspecialchars($table) . '</li>';
    }
    echo '</ul>';
    
    echo '<div class="success">تم إعداد قاعدة البيانات بنجاح!</div>';
    
    echo '<a href="../index.php" class="btn">العودة إلى الصفحة الرئيسية</a>';
    
} catch (Exception $e) {
    echo '<div class="error">حدث خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
}

echo '</div></body></html>';
?>
