-- ملف قاعدة البيانات الموحد
-- تم توحيد جميع ملفات قاعدة البيانات في هذا الملف
-- آخر تحديث: 2023-08-15

-- إنشاء قاعدة البيانات إذا لم تكن موجودة
CREATE DATABASE IF NOT EXISTS `shipping_db` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- استخدام قاعدة البيانات
USE `shipping_db`;

-- إنشاء جدول الفروع
CREATE TABLE IF NOT EXISTS `branches` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(100) NOT NULL COMMENT 'اسم الفرع',
  `code` VARCHAR(10) NOT NULL UNIQUE COMMENT 'رمز الفرع',
  `address` TEXT DEFAULT NULL COMMENT 'عنوان الفرع',
  `phone` VARCHAR(20) DEFAULT NULL COMMENT 'رقم هاتف الفرع',
  `email` VARCHAR(100) DEFAULT NULL COMMENT 'البريد الإلكتروني للفرع',
  `manager_name` VARCHAR(100) DEFAULT NULL COMMENT 'اسم مدير الفرع',
  `is_active` TINYINT(1) NOT NULL DEFAULT 1 COMMENT 'حالة الفرع (نشط/غير نشط)',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج البيانات الأولية لجدول الفروع
INSERT IGNORE INTO `branches` (`name`, `code`, `address`, `phone`, `email`, `manager_name`, `is_active`) VALUES
('المركز الرئيسي', 'HQ', 'اليمن، حضرموت، المكلا', '05318281', 'hq@al-ahmadigroup.com', 'إبراهيم الأحمدي', 1),
('المكلا', 'MKL', 'اليمن، حضرموت، المكلا', '05318281', 'mukalla@al-ahmadigroup.com', 'أحمد محمد', 1),
('فرع عدن', 'ADN', 'اليمن، عدن', '05318282', 'aden@al-ahmadigroup.com', 'محمد علي', 1),
('فرع صنعاء', 'SNA', 'اليمن، صنعاء', '05318283', 'sanaa@al-ahmadigroup.com', 'علي أحمد', 1),
('فرع شحن', 'SH', 'اليمن، حضرموت، شحن', '05318284', 'shihn@al-ahmadigroup.com', 'سالم عمر', 1),
('فرع الصين', 'CN', 'الصين', '05318285', 'china@al-ahmadigroup.com', 'خالد سعيد', 1);

-- إنشاء جدول تسلسل أرقام الطلبات
CREATE TABLE IF NOT EXISTS `order_sequences` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `branch_code` VARCHAR(10) NOT NULL UNIQUE COMMENT 'رمز الفرع',
  `last_sequence_number` INT NOT NULL DEFAULT 0 COMMENT 'آخر رقم تسلسلي',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج البيانات الأولية لجدول تسلسل أرقام الطلبات
INSERT IGNORE INTO `order_sequences` (`branch_code`, `last_sequence_number`) VALUES
('HQ', 0),
('MKL', 0),
('ADN', 0),
('SNA', 0),
('SH', 0),
('CN', 0);

-- إنشاء جدول المستخدمين
CREATE TABLE IF NOT EXISTS `users` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `username` VARCHAR(50) NOT NULL UNIQUE COMMENT 'اسم المستخدم',
  `password` VARCHAR(255) NOT NULL COMMENT 'كلمة المرور',
  `full_name` VARCHAR(100) NOT NULL COMMENT 'الاسم الكامل',
  `email` VARCHAR(100) NOT NULL UNIQUE COMMENT 'البريد الإلكتروني',
  `phone` VARCHAR(20) DEFAULT NULL COMMENT 'رقم الهاتف',
  `role` ENUM('admin', 'manager', 'employee', 'client') NOT NULL DEFAULT 'employee' COMMENT 'دور المستخدم',
  `status` ENUM('pending', 'active', 'inactive') NOT NULL DEFAULT 'active' COMMENT 'حالة المستخدم',
  `branch_id` INT DEFAULT NULL COMMENT 'معرف الفرع',
  `last_login` DATETIME DEFAULT NULL COMMENT 'آخر تسجيل دخول',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث',
  FOREIGN KEY (`branch_id`) REFERENCES `branches`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج البيانات الأولية لجدول المستخدمين
INSERT IGNORE INTO `users` (`username`, `password`, `full_name`, `email`, `phone`, `role`, `status`, `branch_id`) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'مدير النظام', 'admin@al-ahmadigroup.com', '05318281', 'admin', 'active', 1),
('manager', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'مدير الفرع', 'manager@al-ahmadigroup.com', '05318282', 'manager', 'active', 2),
('employee', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'موظف', 'employee@al-ahmadigroup.com', '05318283', 'employee', 'active', 3);

-- إنشاء جدول الطلبات
CREATE TABLE IF NOT EXISTS `orders` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `order_number` VARCHAR(20) NOT NULL UNIQUE COMMENT 'رقم الطلب',
  `branch_id` INT NOT NULL COMMENT 'معرف الفرع',
  `customer_name` VARCHAR(100) NOT NULL COMMENT 'اسم العميل',
  `customer_phone` VARCHAR(20) DEFAULT NULL COMMENT 'رقم هاتف العميل',
  `customer_email` VARCHAR(100) DEFAULT NULL COMMENT 'البريد الإلكتروني للعميل',
  `shipping_address` TEXT NOT NULL COMMENT 'عنوان الشحن',
  `order_date` DATE NOT NULL COMMENT 'تاريخ الطلب',
  `delivery_date` DATE DEFAULT NULL COMMENT 'تاريخ التسليم',
  `status` ENUM('pending', 'processing', 'shipped', 'delivered', 'cancelled') NOT NULL DEFAULT 'pending' COMMENT 'حالة الطلب',
  `total_amount` DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT 'المبلغ الإجمالي',
  `shipping_cost` DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT 'تكلفة الشحن',
  `payment_method` ENUM('cash', 'credit_card', 'bank_transfer', 'other') NOT NULL DEFAULT 'cash' COMMENT 'طريقة الدفع',
  `payment_status` ENUM('paid', 'unpaid', 'partial') NOT NULL DEFAULT 'unpaid' COMMENT 'حالة الدفع',
  `notes` TEXT DEFAULT NULL COMMENT 'ملاحظات',
  `created_by` INT NOT NULL COMMENT 'معرف المستخدم الذي أنشأ الطلب',
  `updated_by` INT DEFAULT NULL COMMENT 'معرف المستخدم الذي قام بتحديث الطلب',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث',
  FOREIGN KEY (`branch_id`) REFERENCES `branches`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`updated_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء جدول أرشيف الطلبات
CREATE TABLE IF NOT EXISTS `archived_orders` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `order_id` INT NOT NULL COMMENT 'معرف الطلب الأصلي',
  `order_number` VARCHAR(20) NOT NULL COMMENT 'رقم الطلب',
  `branch_id` INT NOT NULL COMMENT 'معرف الفرع',
  `customer_name` VARCHAR(100) NOT NULL COMMENT 'اسم العميل',
  `customer_phone` VARCHAR(20) DEFAULT NULL COMMENT 'رقم هاتف العميل',
  `customer_email` VARCHAR(100) DEFAULT NULL COMMENT 'البريد الإلكتروني للعميل',
  `shipping_address` TEXT NOT NULL COMMENT 'عنوان الشحن',
  `order_date` DATE NOT NULL COMMENT 'تاريخ الطلب',
  `delivery_date` DATE DEFAULT NULL COMMENT 'تاريخ التسليم',
  `status` ENUM('pending', 'processing', 'shipped', 'delivered', 'cancelled') NOT NULL DEFAULT 'pending' COMMENT 'حالة الطلب',
  `total_amount` DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT 'المبلغ الإجمالي',
  `shipping_cost` DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT 'تكلفة الشحن',
  `payment_method` ENUM('cash', 'credit_card', 'bank_transfer', 'other') NOT NULL DEFAULT 'cash' COMMENT 'طريقة الدفع',
  `payment_status` ENUM('paid', 'unpaid', 'partial') NOT NULL DEFAULT 'unpaid' COMMENT 'حالة الدفع',
  `notes` TEXT DEFAULT NULL COMMENT 'ملاحظات',
  `created_by` INT NOT NULL COMMENT 'معرف المستخدم الذي أنشأ الطلب',
  `updated_by` INT DEFAULT NULL COMMENT 'معرف المستخدم الذي قام بتحديث الطلب',
  `archived_by` INT NOT NULL COMMENT 'معرف المستخدم الذي قام بأرشفة الطلب',
  `archived_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الأرشفة',
  `created_at` TIMESTAMP NOT NULL COMMENT 'تاريخ الإنشاء الأصلي',
  `updated_at` TIMESTAMP NOT NULL COMMENT 'تاريخ التحديث الأصلي'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء جدول الدول
CREATE TABLE IF NOT EXISTS `countries` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(100) NOT NULL COMMENT 'اسم الدولة',
  `code` VARCHAR(2) NOT NULL UNIQUE COMMENT 'رمز الدولة',
  `phone_code` VARCHAR(5) DEFAULT NULL COMMENT 'رمز الهاتف',
  `is_active` TINYINT(1) NOT NULL DEFAULT 1 COMMENT 'حالة الدولة (نشطة/غير نشطة)',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج البيانات الأولية لجدول الدول
INSERT IGNORE INTO `countries` (`name`, `code`, `phone_code`, `is_active`) VALUES
('اليمن', 'YE', '+967', 1),
('السعودية', 'SA', '+966', 1),
('الإمارات', 'AE', '+971', 1),
('الصين', 'CN', '+86', 1);

-- إنشاء جدول إعدادات النظام
CREATE TABLE IF NOT EXISTS `system_settings` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `setting_key` VARCHAR(50) NOT NULL UNIQUE COMMENT 'مفتاح الإعداد',
  `setting_value` TEXT DEFAULT NULL COMMENT 'قيمة الإعداد',
  `setting_group` VARCHAR(50) DEFAULT 'general' COMMENT 'مجموعة الإعداد',
  `description` VARCHAR(255) DEFAULT NULL COMMENT 'وصف الإعداد',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج البيانات الأولية لجدول إعدادات النظام
INSERT IGNORE INTO `system_settings` (`setting_key`, `setting_value`, `setting_group`, `description`) VALUES
('company_name', 'مجموعة ابراهيم الاحمدي اليمنية', 'company', 'اسم الشركة'),
('company_address', 'اليمن، حضرموت، المكلا', 'company', 'عنوان الشركة'),
('company_phone', '05318281', 'company', 'رقم هاتف الشركة'),
('company_email', 'ibrahim@al-ahmadigroup.com', 'company', 'البريد الإلكتروني للشركة'),
('company_logo', 'assets/images/logo.png', 'company', 'شعار الشركة'),
('system_name', 'نظام طلبات الشحن', 'system', 'اسم النظام'),
('system_version', '1.0.0', 'system', 'إصدار النظام'),
('currency', 'ريال يمني', 'finance', 'العملة الافتراضية'),
('currency_symbol', 'ر.ي', 'finance', 'رمز العملة'),
('tax_rate', '0', 'finance', 'نسبة الضريبة'),
('default_language', 'ar', 'localization', 'اللغة الافتراضية'),
('timezone', 'Asia/Aden', 'localization', 'المنطقة الزمنية'),
('date_format', 'Y-m-d', 'localization', 'تنسيق التاريخ'),
('time_format', 'H:i:s', 'localization', 'تنسيق الوقت');

-- إنشاء جدول سجل النشاط
CREATE TABLE IF NOT EXISTS `activity_log` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT NOT NULL COMMENT 'معرف المستخدم',
  `action` VARCHAR(100) NOT NULL COMMENT 'الإجراء',
  `details` TEXT DEFAULT NULL COMMENT 'تفاصيل الإجراء',
  `ip_address` VARCHAR(45) DEFAULT NULL COMMENT 'عنوان IP',
  `user_agent` VARCHAR(255) DEFAULT NULL COMMENT 'وكيل المستخدم',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء جدول الصلاحيات
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(50) NOT NULL UNIQUE COMMENT 'اسم الصلاحية',
  `display_name` VARCHAR(100) NOT NULL COMMENT 'الاسم المعروض',
  `description` TEXT DEFAULT NULL COMMENT 'وصف الصلاحية',
  `category` VARCHAR(50) DEFAULT 'general' COMMENT 'فئة الصلاحية',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء جدول الأدوار
CREATE TABLE IF NOT EXISTS `roles` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(50) NOT NULL UNIQUE COMMENT 'اسم الدور',
  `display_name` VARCHAR(100) NOT NULL COMMENT 'الاسم المعروض',
  `description` TEXT DEFAULT NULL COMMENT 'وصف الدور',
  `is_system` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'هل هو دور نظام',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء جدول صلاحيات الدور
CREATE TABLE IF NOT EXISTS `role_permissions` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `role_id` INT NOT NULL COMMENT 'معرف الدور',
  `permission_id` INT NOT NULL COMMENT 'معرف الصلاحية',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  UNIQUE KEY `role_permission_unique` (`role_id`, `permission_id`),
  FOREIGN KEY (`role_id`) REFERENCES `roles`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`permission_id`) REFERENCES `permissions`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إنشاء جدول صلاحيات المستخدم
CREATE TABLE IF NOT EXISTS `user_permissions` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT NOT NULL COMMENT 'معرف المستخدم',
  `permission_id` INT NOT NULL COMMENT 'معرف الصلاحية',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  UNIQUE KEY `user_permission_unique` (`user_id`, `permission_id`),
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`permission_id`) REFERENCES `permissions`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
