-- ملف إنشاء جدول صلاحيات المستخدمين
-- تاريخ الإنشاء: 2023-07-20

-- استخدام قاعدة البيانات
USE `shipping_db`;

-- إنشاء جدول صلاحيات المستخدمين
CREATE TABLE IF NOT EXISTS `user_permissions` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT NOT NULL COMMENT 'معرف المستخدم',
  `permission_id` INT NOT NULL COMMENT 'معرف الصلاحية',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
  UNIQUE KEY `user_permission_unique` (`user_id`, `permission_id`),
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`permission_id`) REFERENCES `permissions`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج صلاحيات افتراضية للمستخدمين
-- يمكن إضافة صلاحيات افتراضية هنا إذا لزم الأمر
