# نظام طلبات الشحن

نظام متكامل لإدارة طلبات الشحن، يتيح إنشاء وتتبع ومراقبة طلبات الشحن بين مختلف الفروع والدول.

## هيكل المشروع

تم تنظيم المشروع وفقًا للهيكل التالي:

```
/
├── api/                  # ملفات API
├── assets/               # الأصول الثابتة (الصور، الأيقونات، إلخ)
│   ├── css/              # ملفات CSS
│   ├── js/               # ملفات JavaScript
│   ├── images/           # الصور
│   └── fonts/            # الخطوط
├── config/               # ملفات التكوين
│   ├── config.php        # ملف التكوين الرئيسي
│   ├── database.php      # إعدادات قاعدة البيانات
│   └── security.php      # إعدادات الأمان
├── database/             # ملفات قاعدة البيانات
│   ├── unified_database.sql      # ملف قاعدة البيانات الموحد لـ MySQL
│   ├── unified_database_sqlite.sql # ملف قاعدة البيانات الموحد لـ SQLite
│   └── migrate_orders.php        # نقل البيانات من localStorage إلى قاعدة البيانات
├── includes/             # مكونات PHP القابلة لإعادة الاستخدام
│   ├── functions.php     # دوال مساعدة
│   ├── sidebar.html      # القائمة الجانبية الموحدة
│   └── template.php      # قالب الصفحات
├── pages/                # صفحات HTML
├── templates/            # قوالب HTML
└── utils/                # أدوات وسكربتات مساعدة
```

## الصفحات الرئيسية

- **login.html**: صفحة تسجيل الدخول
- **index.html**: الصفحة الرئيسية (SPA)
- **dashboard.html**: لوحة التحكم
- **orders.html**: إدارة الطلبات
- **create-order.html**: إنشاء طلب جديد
- **archive.html**: أرشيف الطلبات
- **settings.html**: إعدادات النظام

## متطلبات النظام

- PHP 7.0 أو أعلى
- MySQL 5.7 أو أعلى
- دعم PDO و JSON و mbstring
- متصفح حديث يدعم JavaScript ES6
- دعم HTTPS (موصى به للأمان)

## تثبيت النظام

### التثبيت المحلي (XAMPP)

1. قم بتنزيل وتثبيت [XAMPP](https://www.apachefriends.org/download.html)
2. انسخ ملفات المشروع إلى مجلد `htdocs`
3. قم بإنشاء قاعدة بيانات جديدة باسم `shipping_db`
4. قم باستيراد ملف `database/unified_database.sql` إلى قاعدة البيانات
5. قم بتعديل ملف `config/database.php` بمعلومات الاتصال بقاعدة البيانات
6. افتح المتصفح وانتقل إلى `http://localhost/shipping`

### التثبيت على استضافة

1. **تحميل الملفات**:
   - قم برفع جميع ملفات النظام إلى المجلد الرئيسي للاستضافة (public_html أو www)
   - تأكد من رفع الملفات الخفية مثل .htaccess و web.config

2. **ضبط الصلاحيات**:
   - تأكد من ضبط صلاحيات الملفات إلى 644
   - تأكد من ضبط صلاحيات المجلدات إلى 755

3. **إعدادات النطاق**:
   - قم بتوجيه النطاق الخاص بك إلى مجلد الاستضافة
   - قم بتفعيل شهادة SSL إذا كانت متاحة

4. **تكوين قاعدة البيانات**:
   - قم بإنشاء قاعدة بيانات جديدة
   - قم باستيراد ملف `database/unified_database.sql` إلى قاعدة البيانات MySQL
   - أو استخدم ملف `database/unified_database_sqlite.sql` لقاعدة بيانات SQLite
   - قم بتعديل ملف `config/database.php` بمعلومات الاتصال بقاعدة البيانات

5. **تحديث روابط الموقع**:
   - قم بتحديث الروابط في ملف sitemap.xml لتعكس اسم النطاق الخاص بك
   - استبدل "yourdomain.com" باسم النطاق الفعلي

6. **اختبار الموقع**:
   - تأكد من عمل جميع الصفحات بشكل صحيح
   - تحقق من تحميل جميع الأصول (CSS، JavaScript، الخطوط، الصور)
   - اختبر التوافق مع مختلف المتصفحات والأجهزة

## الميزات الرئيسية

- إنشاء طلبات شحن جديدة
- تتبع حالة الطلبات
- إدارة الفروع والعملاء
- أرشفة الطلبات القديمة تلقائيًا
- عرض إحصائيات وتقارير
- خريطة تفاعلية لمسارات الشحن
- عرض أسعار الشحن للدول المختلفة

## بيانات الدخول الافتراضية

- **اسم المستخدم**: admin
- **كلمة المرور**: admin123

## ملاحظات هامة

- تم تهيئة النظام للعمل مباشرة دون الحاجة لإعدادات إضافية
- تم إضافة ملف .htaccess لضمان توجيه الروابط بشكل صحيح
- تم إضافة ملف web.config للتوافق مع خوادم IIS إذا كانت الاستضافة تعمل على Windows
- الصفحة الرئيسية هي login.html وسيتم توجيه الزوار إليها تلقائياً

## التغييرات التي تم إجراؤها

تم إجراء التغييرات التالية لتنظيف وتنظيم المشروع:

1. **إزالة الملفات المكررة**:
   - تم إزالة ملفات index.html و index.php المكررة
   - تم إزالة ملفات الاختبار (test*.php)
   - تم إزالة ملفات تسجيل الدخول المكررة
   - تم إزالة ملفات التكوين المكررة

2. **توحيد قاعدة البيانات**:
   - تم توحيد جميع ملفات SQL في ملفين رئيسيين (MySQL و SQLite)
   - تم تحسين هيكل الجداول وإضافة تعليقات توضيحية
   - تم إضافة العلاقات بين الجداول باستخدام المفاتيح الأجنبية

3. **تنظيم هيكل المجلدات**:
   - تم إنشاء مجلدات جديدة لتنظيم الملفات
   - تم نقل الملفات إلى المجلدات المناسبة

## الدعم الفني

إذا واجهتك أي مشكلة أثناء عملية التثبيت أو الاستخدام، يرجى التواصل مع فريق الدعم الفني.