# تعليمات التحقق من الطلبات في قاعدة البيانات

## مقدمة

هذا الدليل يشرح كيفية التحقق من الطلبات في قاعدة البيانات باستخدام لوحة تحكم cPanel. يمكنك استخدام هذه الأدوات للتحقق من الطلبات التي تم إنشاؤها في النظام والتأكد من أنها تم حفظها بشكل صحيح في قاعدة البيانات.

## الملفات المتاحة

1. **create_orders_table.sql**: ملف SQL لإنشاء جدول الطلبات في قاعدة البيانات.
2. **check_orders.php**: ملف PHP للتحقق من الطلبات في قاعدة البيانات.
3. **migrate_orders.php**: ملف PHP لنقل الطلبات من localStorage إلى قاعدة البيانات.

## خطوات التحقق من الطلبات

### 1. إنشاء جدول الطلبات

1. قم بتسجيل الدخول إلى لوحة تحكم cPanel.
2. انتقل إلى "قواعد البيانات" > "phpMyAdmin".
3. اختر قاعدة البيانات الخاصة بك من القائمة.
4. انقر على علامة التبويب "SQL".
5. انسخ محتوى ملف `create_orders_table.sql` والصقه في مربع النص.
6. انقر على زر "تنفيذ" لإنشاء جدول الطلبات.

### 2. التحقق من الطلبات

1. قم بتحميل ملف `check_orders.php` إلى مجلد الموقع الخاص بك.
2. قم بتعديل معلومات الاتصال بقاعدة البيانات في الملف (اسم المضيف، اسم قاعدة البيانات، اسم المستخدم، كلمة المرور).
3. قم بزيارة الملف في المتصفح (على سبيل المثال: `https://yourdomain.com/check_orders.php`).
4. ستظهر صفحة تعرض معلومات عن الطلبات في قاعدة البيانات.

### 3. نقل الطلبات من localStorage إلى قاعدة البيانات

1. قم بتحميل ملف `migrate_orders.php` إلى مجلد الموقع الخاص بك.
2. قم بتعديل معلومات الاتصال بقاعدة البيانات في الملف (اسم المضيف، اسم قاعدة البيانات، اسم المستخدم، كلمة المرور).
3. قم بزيارة الملف في المتصفح (على سبيل المثال: `https://yourdomain.com/migrate_orders.php`).
4. اتبع التعليمات على الصفحة للحصول على بيانات الطلبات من localStorage ونقلها إلى قاعدة البيانات.

## الحصول على بيانات الطلبات من localStorage

1. افتح صفحة النظام في المتصفح.
2. اضغط على F12 لفتح أدوات المطور.
3. انتقل إلى علامة التبويب "Console".
4. اكتب الأمر التالي واضغط على Enter:

```javascript
localStorage.getItem('shippingOrders')
```

5. انسخ النتيجة (بدون علامات الاقتباس في البداية والنهاية).
6. الصق النتيجة في مربع النص في صفحة `migrate_orders.php`.
7. انقر على زر "نقل الطلبات" لنقل الطلبات إلى قاعدة البيانات.

## ملاحظات هامة

- تأكد من تعديل معلومات الاتصال بقاعدة البيانات في الملفات PHP قبل استخدامها.
- تأكد من وجود جدول الطلبات في قاعدة البيانات قبل محاولة التحقق من الطلبات أو نقلها.
- يمكنك استخدام ملف `check_orders.php` للتحقق من الطلبات في قاعدة البيانات في أي وقت.
- يمكنك استخدام ملف `migrate_orders.php` لنقل الطلبات من localStorage إلى قاعدة البيانات في أي وقت.

## استكشاف الأخطاء وإصلاحها

### مشكلة: لا يمكن الاتصال بقاعدة البيانات

- تأكد من صحة معلومات الاتصال بقاعدة البيانات (اسم المضيف، اسم قاعدة البيانات، اسم المستخدم، كلمة المرور).
- تأكد من وجود قاعدة البيانات وأن المستخدم لديه صلاحيات الوصول إليها.

### مشكلة: جدول الطلبات غير موجود

- تأكد من تنفيذ ملف `create_orders_table.sql` بنجاح.
- تحقق من وجود جدول الطلبات في قاعدة البيانات باستخدام phpMyAdmin.

### مشكلة: بيانات JSON غير صالحة

- تأكد من نسخ بيانات الطلبات من localStorage بشكل صحيح.
- تأكد من عدم وجود أخطاء في بيانات JSON.

## الدعم الفني

إذا واجهتك أي مشكلة أثناء استخدام هذه الأدوات، يرجى التواصل مع فريق الدعم الفني.
