<?php
/**
 * ملف القوالب
 * يحتوي هذا الملف على دوال لعرض قوالب HTML
 */

/**
 * دالة لعرض رأس الصفحة
 * @param string $title - عنوان الصفحة
 * @param array $styles - ملفات CSS الإضافية
 * @return void
 */
function renderHeader($title = 'نظام طلبات الشحن', $styles = []) {
    global $system_name, $company_name;
    
    // تحديد عنوان الصفحة
    $pageTitle = $title . ' | ' . ($system_name ?? 'نظام طلبات الشحن');
    
    // بدء مخرجات HTML
    ob_start();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    
    <!-- ملفات CSS الأساسية -->
    <link rel="stylesheet" href="assets/css/sidebar.css">
    
    <!-- ملفات CSS الإضافية -->
    <?php foreach ($styles as $style): ?>
    <link rel="stylesheet" href="<?php echo $style; ?>">
    <?php endforeach; ?>
    
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f8f9fa;
        }
        
        .container {
            display: flex;
            min-height: 100vh;
        }
        
        .content {
            flex: 1;
            padding: 20px;
            margin-right: 250px;
        }
        
        @media (max-width: 768px) {
            .content {
                margin-right: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
<?php
    // عرض الشريط الجانبي
    renderSidebar();
    
    // بدء محتوى الصفحة
    echo '<div class="content">';
    
    // إرجاع مخرجات HTML
    echo ob_get_clean();
}

/**
 * دالة لعرض الشريط الجانبي
 * @return void
 */
function renderSidebar() {
    global $system_name, $company_name, $company_logo;
    
    // بدء مخرجات HTML
    ob_start();
?>
<div class="sidebar">
    <div class="sidebar-header">
        <img src="<?php echo $company_logo ?? 'assets/images/logo/company-logo.png'; ?>" alt="<?php echo $company_name ?? 'شركة الشحن'; ?>" class="logo">
        <h3><?php echo $system_name ?? 'نظام طلبات الشحن'; ?></h3>
    </div>
    
    <div class="sidebar-menu">
        <ul>
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> لوحة التحكم</a></li>
            <li><a href="orders.php"><i class="fas fa-shipping-fast"></i> الطلبات</a></li>
            <li><a href="create-order.php"><i class="fas fa-plus-circle"></i> إنشاء طلب جديد</a></li>
            <li><a href="archive.php"><i class="fas fa-archive"></i> الأرشيف</a></li>
            <li><a href="settings.php"><i class="fas fa-cog"></i> الإعدادات</a></li>
            <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
            <li><a href="users.php"><i class="fas fa-users"></i> المستخدمون</a></li>
            <?php endif; ?>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> تسجيل الخروج</a></li>
        </ul>
    </div>
</div>
<?php
    // إرجاع مخرجات HTML
    echo ob_get_clean();
}

/**
 * دالة لعرض تذييل الصفحة
 * @param array $scripts - ملفات JavaScript الإضافية
 * @return void
 */
function renderFooter($scripts = []) {
    // بدء مخرجات HTML
    ob_start();
?>
        </div><!-- نهاية محتوى الصفحة -->
    </div><!-- نهاية الحاوية -->
    
    <!-- ملفات JavaScript الأساسية -->
    <script src="assets/js/spa-router.js"></script>
    
    <!-- ملفات JavaScript الإضافية -->
    <?php foreach ($scripts as $script): ?>
    <script src="<?php echo $script; ?>"></script>
    <?php endforeach; ?>
</body>
</html>
<?php
    // إرجاع مخرجات HTML
    echo ob_get_clean();
}

/**
 * دالة لعرض رسالة نجاح
 * @param string $message - نص الرسالة
 * @return string - كود HTML للرسالة
 */
function renderSuccessMessage($message) {
    return '<div class="alert alert-success">' . $message . '</div>';
}

/**
 * دالة لعرض رسالة خطأ
 * @param string $message - نص الرسالة
 * @return string - كود HTML للرسالة
 */
function renderErrorMessage($message) {
    return '<div class="alert alert-danger">' . $message . '</div>';
}

/**
 * دالة لعرض رسالة تحذير
 * @param string $message - نص الرسالة
 * @return string - كود HTML للرسالة
 */
function renderWarningMessage($message) {
    return '<div class="alert alert-warning">' . $message . '</div>';
}

/**
 * دالة لعرض رسالة معلومات
 * @param string $message - نص الرسالة
 * @return string - كود HTML للرسالة
 */
function renderInfoMessage($message) {
    return '<div class="alert alert-info">' . $message . '</div>';
}

/**
 * دالة لعرض جدول
 * @param array $headers - عناوين الأعمدة
 * @param array $rows - صفوف البيانات
 * @param string $tableClass - فئة الجدول (اختياري)
 * @return string - كود HTML للجدول
 */
function renderTable($headers, $rows, $tableClass = 'table') {
    // بدء مخرجات HTML
    ob_start();
?>
<table class="<?php echo $tableClass; ?>">
    <thead>
        <tr>
            <?php foreach ($headers as $header): ?>
            <th><?php echo $header; ?></th>
            <?php endforeach; ?>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($rows as $row): ?>
        <tr>
            <?php foreach ($row as $cell): ?>
            <td><?php echo $cell; ?></td>
            <?php endforeach; ?>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php
    // إرجاع مخرجات HTML
    return ob_get_clean();
}

/**
 * دالة لعرض نموذج
 * @param string $action - عنوان إرسال النموذج
 * @param array $fields - حقول النموذج
 * @param string $method - طريقة إرسال النموذج (اختياري)
 * @param string $submitText - نص زر الإرسال (اختياري)
 * @param string $formClass - فئة النموذج (اختياري)
 * @return string - كود HTML للنموذج
 */
function renderForm($action, $fields, $method = 'post', $submitText = 'إرسال', $formClass = 'form') {
    // بدء مخرجات HTML
    ob_start();
?>
<form action="<?php echo $action; ?>" method="<?php echo $method; ?>" class="<?php echo $formClass; ?>">
    <?php if ($method === 'post'): ?>
    <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">
    <?php endif; ?>
    
    <?php foreach ($fields as $field): ?>
    <div class="form-group">
        <?php if (isset($field['label'])): ?>
        <label for="<?php echo $field['id']; ?>"><?php echo $field['label']; ?></label>
        <?php endif; ?>
        
        <?php if ($field['type'] === 'textarea'): ?>
        <textarea
            id="<?php echo $field['id']; ?>"
            name="<?php echo $field['name']; ?>"
            class="<?php echo $field['class'] ?? 'form-control'; ?>"
            <?php echo isset($field['required']) && $field['required'] ? 'required' : ''; ?>
            <?php echo isset($field['placeholder']) ? 'placeholder="' . $field['placeholder'] . '"' : ''; ?>
            <?php echo isset($field['rows']) ? 'rows="' . $field['rows'] . '"' : ''; ?>
        ><?php echo $field['value'] ?? ''; ?></textarea>
        <?php elseif ($field['type'] === 'select'): ?>
        <select
            id="<?php echo $field['id']; ?>"
            name="<?php echo $field['name']; ?>"
            class="<?php echo $field['class'] ?? 'form-control'; ?>"
            <?php echo isset($field['required']) && $field['required'] ? 'required' : ''; ?>
        >
            <?php foreach ($field['options'] as $option): ?>
            <option
                value="<?php echo $option['value']; ?>"
                <?php echo isset($field['value']) && $field['value'] === $option['value'] ? 'selected' : ''; ?>
            ><?php echo $option['text']; ?></option>
            <?php endforeach; ?>
        </select>
        <?php else: ?>
        <input
            type="<?php echo $field['type']; ?>"
            id="<?php echo $field['id']; ?>"
            name="<?php echo $field['name']; ?>"
            class="<?php echo $field['class'] ?? 'form-control'; ?>"
            <?php echo isset($field['value']) ? 'value="' . $field['value'] . '"' : ''; ?>
            <?php echo isset($field['required']) && $field['required'] ? 'required' : ''; ?>
            <?php echo isset($field['placeholder']) ? 'placeholder="' . $field['placeholder'] . '"' : ''; ?>
            <?php echo isset($field['min']) ? 'min="' . $field['min'] . '"' : ''; ?>
            <?php echo isset($field['max']) ? 'max="' . $field['max'] . '"' : ''; ?>
            <?php echo isset($field['step']) ? 'step="' . $field['step'] . '"' : ''; ?>
            <?php echo isset($field['pattern']) ? 'pattern="' . $field['pattern'] . '"' : ''; ?>
        >
        <?php endif; ?>
        
        <?php if (isset($field['help'])): ?>
        <small class="form-text text-muted"><?php echo $field['help']; ?></small>
        <?php endif; ?>
    </div>
    <?php endforeach; ?>
    
    <div class="form-group">
        <button type="submit" class="btn btn-primary"><?php echo $submitText; ?></button>
    </div>
</form>
<?php
    // إرجاع مخرجات HTML
    return ob_get_clean();
}
?>
