<?php
// ملف للتحقق من الطلبات في قاعدة البيانات
// يمكن استخدام هذا الملف في لوحة تحكم cPanel للتحقق من الطلبات

// معلومات الاتصال بقاعدة البيانات
$host = 'localhost';
$dbname = 'shipping_system'; // قم بتغيير هذا إلى اسم قاعدة البيانات الخاصة بك
$username = 'root'; // قم بتغيير هذا إلى اسم المستخدم الخاص بك
$password = ''; // قم بتغيير هذا إلى كلمة المرور الخاصة بك

// إنشاء اتصال PDO
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    // ضبط وضع الخطأ إلى استثناء
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // ضبط الوضع الافتراضي لجلب البيانات
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    // تعطيل محاكاة الاستعلامات المعدة
    $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    
    echo "<h1>نظام التحقق من الطلبات</h1>";
    echo "<p>تم الاتصال بقاعدة البيانات بنجاح.</p>";
    
    // التحقق من وجود جدول الطلبات
    $stmt = $pdo->query("SHOW TABLES LIKE 'orders'");
    $tableExists = $stmt->rowCount() > 0;
    
    if (!$tableExists) {
        echo "<p style='color: red;'>جدول الطلبات غير موجود. يرجى إنشاء الجدول أولاً.</p>";
        echo "<p>يمكنك استخدام ملف create_orders_table.sql لإنشاء جدول الطلبات.</p>";
        exit;
    }
    
    // الحصول على عدد الطلبات
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM orders");
    $result = $stmt->fetch();
    $totalOrders = $result['total'];
    
    echo "<p>إجمالي عدد الطلبات في قاعدة البيانات: <strong>$totalOrders</strong></p>";
    
    // الحصول على عدد الطلبات حسب الحالة
    $stmt = $pdo->query("SELECT status, COUNT(*) as count FROM orders GROUP BY status");
    $statusCounts = $stmt->fetchAll();
    
    echo "<h2>عدد الطلبات حسب الحالة:</h2>";
    echo "<ul>";
    foreach ($statusCounts as $status) {
        echo "<li>{$status['status']}: {$status['count']}</li>";
    }
    echo "</ul>";
    
    // الحصول على عدد الطلبات حسب الفرع
    $stmt = $pdo->query("
        SELECT b.name as branch_name, COUNT(o.id) as count 
        FROM orders o 
        LEFT JOIN branches b ON o.branch_id = b.id 
        GROUP BY o.branch_id
    ");
    $branchCounts = $stmt->fetchAll();
    
    echo "<h2>عدد الطلبات حسب الفرع:</h2>";
    echo "<ul>";
    foreach ($branchCounts as $branch) {
        $branchName = $branch['branch_name'] ?: 'غير محدد';
        echo "<li>{$branchName}: {$branch['count']}</li>";
    }
    echo "</ul>";
    
    // عرض آخر 10 طلبات
    $stmt = $pdo->query("
        SELECT o.id, o.order_number, o.client_name, b.name as branch_name, 
               o.departure_area, o.delivery_area, o.status, o.payment_status, 
               o.created_at 
        FROM orders o 
        LEFT JOIN branches b ON o.branch_id = b.id 
        ORDER BY o.created_at DESC 
        LIMIT 10
    ");
    $latestOrders = $stmt->fetchAll();
    
    echo "<h2>آخر 10 طلبات:</h2>";
    
    if (count($latestOrders) > 0) {
        echo "<table border='1' cellpadding='5' cellspacing='0'>";
        echo "<tr>
                <th>#</th>
                <th>رقم الطلب</th>
                <th>اسم العميل</th>
                <th>الفرع</th>
                <th>من</th>
                <th>إلى</th>
                <th>حالة الطلب</th>
                <th>حالة الدفع</th>
                <th>تاريخ الإنشاء</th>
              </tr>";
        
        foreach ($latestOrders as $order) {
            echo "<tr>";
            echo "<td>{$order['id']}</td>";
            echo "<td>{$order['order_number']}</td>";
            echo "<td>{$order['client_name']}</td>";
            echo "<td>{$order['branch_name'] ?: 'غير محدد'}</td>";
            echo "<td>{$order['departure_area']}</td>";
            echo "<td>{$order['delivery_area']}</td>";
            echo "<td>{$order['status']}</td>";
            echo "<td>{$order['payment_status']}</td>";
            echo "<td>{$order['created_at']}</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    } else {
        echo "<p>لا توجد طلبات في قاعدة البيانات.</p>";
    }
    
    // نموذج لإضافة طلب من localStorage إلى قاعدة البيانات
    echo "<h2>إضافة طلب من localStorage إلى قاعدة البيانات:</h2>";
    echo "<p>يمكنك استخدام هذا النموذج لإضافة طلب من localStorage إلى قاعدة البيانات.</p>";
    echo "<form method='post' action=''>";
    echo "<textarea name='order_data' rows='10' cols='80' placeholder='ضع بيانات الطلب من localStorage هنا (بتنسيق JSON)'></textarea><br>";
    echo "<input type='submit' name='add_order' value='إضافة الطلب'>";
    echo "</form>";
    
    // معالجة إضافة طلب من localStorage
    if (isset($_POST['add_order']) && !empty($_POST['order_data'])) {
        try {
            $orderData = json_decode($_POST['order_data'], true);
            
            if (json_last_error() !== JSON_ERROR_NONE) {
                throw new Exception("بيانات JSON غير صالحة: " . json_last_error_msg());
            }
            
            // التحقق من وجود البيانات الأساسية
            if (empty($orderData['orderNumber']) || empty($orderData['clientName'])) {
                throw new Exception("بيانات الطلب غير مكتملة. يجب توفير رقم الطلب واسم العميل على الأقل.");
            }
            
            // البحث عن معرف الفرع
            $branchId = null;
            if (!empty($orderData['branch'])) {
                $stmt = $pdo->prepare("SELECT id FROM branches WHERE name = ?");
                $stmt->execute([$orderData['branch']]);
                $branch = $stmt->fetch();
                if ($branch) {
                    $branchId = $branch['id'];
                }
            }
            
            // إعداد استعلام الإدراج
            $stmt = $pdo->prepare("
                INSERT INTO orders (
                    order_number, client_name, service_type, branch_id, 
                    departure_area, second_destination, delivery_area, goods_name, goods_type, 
                    country_of_origin, weight, quantity, unit, service_fees, 
                    currency, payment_type, delivery_duration, amount_paid, remaining_amount, 
                    order_upload_date, scheduled_delivery_date, recipient_name, phone_number, delivery_company, 
                    employee_name, notes, amount_agreed_with_customer, amount_agreed_with_agent, other_expenses, 
                    profit, payment_status, status
                ) VALUES (
                    :order_number, :client_name, :service_type, :branch_id, 
                    :departure_area, :second_destination, :delivery_area, :goods_name, :goods_type, 
                    :country_of_origin, :weight, :quantity, :unit, :service_fees, 
                    :currency, :payment_type, :delivery_duration, :amount_paid, :remaining_amount, 
                    :order_upload_date, :scheduled_delivery_date, :recipient_name, :phone_number, :delivery_company, 
                    :employee_name, :notes, :amount_agreed_with_customer, :amount_agreed_with_agent, :other_expenses, 
                    :profit, :payment_status, :status
                )
            ");
            
            // تنفيذ الاستعلام مع البيانات
            $stmt->execute([
                ':order_number' => $orderData['orderNumber'],
                ':client_name' => $orderData['clientName'],
                ':service_type' => $orderData['serviceType'] ?? null,
                ':branch_id' => $branchId,
                ':departure_area' => $orderData['departureArea'] ?? null,
                ':second_destination' => $orderData['secondDestination'] ?? null,
                ':delivery_area' => $orderData['deliveryArea'] ?? null,
                ':goods_name' => $orderData['goodsName'] ?? null,
                ':goods_type' => $orderData['goodsType'] ?? null,
                ':country_of_origin' => $orderData['countryOfOrigin'] ?? null,
                ':weight' => $orderData['weight'] ?? null,
                ':quantity' => $orderData['quantity'] ?? null,
                ':unit' => $orderData['unit'] ?? null,
                ':service_fees' => $orderData['serviceFees'] ?? null,
                ':currency' => $orderData['currency'] ?? null,
                ':payment_type' => $orderData['paymentType'] ?? null,
                ':delivery_duration' => $orderData['deliveryDuration'] ?? null,
                ':amount_paid' => $orderData['amountPaid'] ?? null,
                ':remaining_amount' => $orderData['remainingAmount'] ?? null,
                ':order_upload_date' => $orderData['orderUploadDate'] ?? null,
                ':scheduled_delivery_date' => $orderData['scheduledDeliveryDate'] ?? null,
                ':recipient_name' => $orderData['recipientName'] ?? null,
                ':phone_number' => $orderData['phoneNumber'] ?? null,
                ':delivery_company' => $orderData['deliveryCompany'] ?? null,
                ':employee_name' => $orderData['employeeName'] ?? null,
                ':notes' => $orderData['notes'] ?? null,
                ':amount_agreed_with_customer' => $orderData['amountAgreedWithCustomer'] ?? null,
                ':amount_agreed_with_agent' => $orderData['amountAgreedWithAgent'] ?? null,
                ':other_expenses' => $orderData['otherExpenses'] ?? null,
                ':profit' => $orderData['profit'] ?? null,
                ':payment_status' => $orderData['paymentStatus'] ?? 'غير مدفوع',
                ':status' => $orderData['status'] ?? 'قيد المعالجة'
            ]);
            
            echo "<p style='color: green;'>تم إضافة الطلب بنجاح!</p>";
            
            // إعادة تحميل الصفحة لتحديث البيانات
            echo "<script>setTimeout(function() { window.location.reload(); }, 2000);</script>";
            
        } catch (Exception $e) {
            echo "<p style='color: red;'>خطأ: " . $e->getMessage() . "</p>";
        }
    }
    
} catch (PDOException $e) {
    // في حالة فشل الاتصال
    die("<h1>فشل الاتصال بقاعدة البيانات</h1><p>" . $e->getMessage() . "</p>");
}
?>
