<?php
// تضمين ملف التحقق من تسجيل الدخول
require_once 'check_auth.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | إنشاء طلب جديد</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    :root {
      --primary: #4f46e5;
      --primary-light: #818cf8;
      --secondary: #f59e0b;
      --dark: #1e293b;
      --light: #f8fafc;
    }

    @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap');

    body {
      font-family: 'Tajawal', sans-serif;
      background-color: #f1f5f9;
      color: var(--dark);
    }

    /* تصميم المحتوى الرئيسي */
    main {
      width: 100%;
      margin: 0 auto;
      max-width: 1400px;
    }

    /* تصميم النموذج */
    .form-input {
      width: 100%;
      padding: 0.75rem 1rem;
      border: 1.5px solid #e2e8f0;
      border-radius: 0.5rem;
      background-color: #fff;
      color: #1e293b;
      transition: all 0.3s ease;
      font-size: 0.95rem;
    }

    .form-input:focus {
      outline: none;
      border-color: #818cf8;
      box-shadow: 0 0 0 3px rgba(129, 140, 248, 0.15);
    }

    .form-input::placeholder {
      color: #94a3b8;
      opacity: 0.7;
    }

    .form-input:hover {
      border-color: #cbd5e1;
    }

    .form-input[readonly], .form-input[disabled] {
      background-color: #f8fafc;
      cursor: not-allowed;
    }

    /* تصميم أقسام النموذج */
    .form-section {
      border: 1px solid #e2e8f0;
      border-radius: 0.75rem;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
      background-color: #f8fafc;
      box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
      transition: all 0.3s ease;
    }

    .form-section:hover {
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
      border-color: #cbd5e1;
    }

    .form-section-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: #1e40af;
      margin-bottom: 1.25rem;
      padding-bottom: 0.75rem;
      border-bottom: 1px solid #e2e8f0;
      display: flex;
      align-items: center;
    }

    .form-section-title i {
      margin-left: 0.5rem;
      color: #4f46e5;
    }

    /* تصميم الأزرار */
    .btn {
      padding: 0.75rem 1.5rem;
      border-radius: 0.5rem;
      font-weight: 600;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      transition: all 0.3s ease;
      cursor: pointer;
    }

    .btn-primary {
      background-color: #4f46e5;
      color: white;
      box-shadow: 0 4px 6px rgba(79, 70, 229, 0.25);
    }

    .btn-primary:hover {
      background-color: #4338ca;
      transform: translateY(-2px);
      box-shadow: 0 6px 10px rgba(79, 70, 229, 0.3);
    }

    .btn-secondary {
      background-color: #f1f5f9;
      color: #334155;
      border: 1px solid #cbd5e1;
    }

    .btn-secondary:hover {
      background-color: #e2e8f0;
      color: #1e293b;
    }

    /* تصميم متجاوب للنموذج */
    @media (max-width: 768px) {
      main {
        width: 100%;
      }

      .form-section {
        padding: 1rem;
      }
    }
  </style>
</head>

<body class="bg-gray-50">

  <!-- المحتوى الرئيسي -->
  <main class="min-h-screen w-full">
    <!-- شريط التنقل العلوي -->
    <header class="bg-white shadow-sm sticky top-0 z-20">
      <div class="flex items-center justify-between p-4">
        <!-- زر العودة للرئيسية -->
        <a href="../index.php" class="text-gray-600 hover:text-indigo-600 flex items-center">
          <i class="fas fa-home text-xl ml-2"></i>
          <span>الرئيسية</span>
        </a>

        <!-- عنوان الصفحة -->
        <div class="text-center flex-1">
          <h1 class="text-xl font-bold text-gray-800">إنشاء طلب جديد</h1>
        </div>

        <!-- معلومات المستخدم -->
        <div class="flex items-center space-x-2 space-x-reverse">
          <div class="text-right">
            <p class="font-medium text-sm"><?php echo htmlspecialchars($currentUser['full_name']); ?></p>
            <p class="text-xs text-gray-500"><?php echo htmlspecialchars($currentUser['role']); ?></p>
          </div>
          <div
            class="h-10 w-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 font-bold">
            <?php echo mb_substr($currentUser['full_name'], 0, 1, 'UTF-8'); ?>
          </div>
        </div>
      </div>
    </header>

    <!-- محتوى الصفحة -->
    <div class="p-6">
      <!-- رأس الصفحة -->
      <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <div>
          <h1 class="text-2xl font-bold text-gray-800 flex items-center">
            <i class="fas fa-plus-circle text-indigo-600 ml-3"></i>
            إنشاء طلب جديد
          </h1>
        </div>
      </div>

      <!-- نموذج إنشاء الطلب -->
      <div class="bg-white rounded-xl shadow-sm overflow-hidden animate-fadeIn">
        <div class="p-6 max-w-full overflow-x-auto">
          <form id="shipmentForm" class="grid grid-cols-1 gap-6 w-full">
            <!-- المعلومات الأساسية -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-info-circle text-indigo-500"></i>
                <span>المعلومات الأساسية للطلب</span>
              </h3>
              <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">رقم الطلب</label>
                  <div class="relative">
                    <input type="text" id="orderNumber" name="orderNumber" readonly class="form-input w-full bg-gray-50 text-indigo-700 font-medium" placeholder="سيتم إنشاؤه تلقائياً">
                    <i class="fas fa-hashtag absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">اسم العميل <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="text" id="clientName" name="clientName" required class="form-input w-full" placeholder="أدخل اسم العميل">
                    <i class="fas fa-user absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">نوع الخدمة <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="text" id="serviceType" name="serviceType" required class="form-input w-full" placeholder="أدخل نوع الخدمة">
                    <i class="fas fa-cog absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
              </div>
            </div>

            <!-- معلومات البضاعة -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-box text-amber-500"></i>
                <span>معلومات البضاعة</span>
              </h3>
              <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">اسم البضاعة <span class="text-red-500">*</span></label>
                  <input type="text" id="goodsName" name="goodsName" required class="form-input w-full" placeholder="أدخل اسم البضاعة">
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">نوع البضاعة <span class="text-red-500">*</span></label>
                  <input type="text" id="goodsType" name="goodsType" required class="form-input w-full" placeholder="أدخل نوع البضاعة">
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">بلد المنشأ <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="text" id="countryOfOrigin" name="countryOfOrigin" required class="form-input w-full" placeholder="أدخل بلد المنشأ">
                    <i class="fas fa-globe absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">الوزن <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="number" id="weight" name="weight" step="0.1" required class="form-input w-full" placeholder="أدخل الوزن">
                    <i class="fas fa-weight absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
              </div>
            </div>

            <!-- معلومات الفرع والمناطق -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-map-marker-alt text-red-500"></i>
                <span>معلومات الفرع والمناطق</span>
              </h3>
              <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">الفرع <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <select id="branch" name="branch" required class="form-input w-full">
                      <option value="">اختر الفرع</option>
                      <option value="عدن" data-code="ADN">عدن</option>
                      <option value="صنعاء" data-code="SNA">صنعاء</option>
                      <option value="المكلا" data-code="MKL">المكلا</option>
                      <option value="الصين" data-code="CN">الصين</option>
                      <option value="شحن" data-code="SH">شحن</option>
                    </select>
                    <i class="fas fa-building absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">منطقة المغادرة <span class="text-red-500">*</span></label>
                  <input type="text" id="departureArea" name="departureArea" required class="form-input w-full" placeholder="أدخل منطقة المغادرة">
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">الوجهة الثانية</label>
                  <input type="text" id="secondDestination" name="secondDestination" class="form-input w-full" placeholder="أدخل الوجهة الثانية">
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">منطقة التسليم <span class="text-red-500">*</span></label>
                  <input type="text" id="deliveryArea" name="deliveryArea" required class="form-input w-full" placeholder="أدخل منطقة التسليم">
                </div>
              </div>
            </div>

            <!-- معلومات الدفع -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-credit-card text-purple-500"></i>
                <span>معلومات الدفع</span>
              </h3>
              <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">رسوم الخدمة <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="number" id="serviceFees" name="serviceFees" required class="form-input w-full" placeholder="أدخل رسوم الخدمة">
                    <i class="fas fa-dollar-sign absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">العملة <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <select id="currency" name="currency" required class="form-input w-full">
                      <option value="دولار">دولار</option>
                      <option value="سعودي">سعودي</option>
                      <option value="يمني">يمني</option>
                    </select>
                    <i class="fas fa-money-bill absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">نوع الدفع <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <select id="paymentType" name="paymentType" required class="form-input w-full">
                      <option value="">اختر نوع الدفع</option>
                      <option value="نقدي">نقدي</option>
                      <option value="تحويل بنكي">تحويل بنكي</option>
                      <option value="بطاقة ائتمان">بطاقة ائتمان</option>
                    </select>
                    <i class="fas fa-wallet absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
              </div>

              <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">مدة التسليم <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="text" id="deliveryDuration" name="deliveryDuration" required class="form-input w-full" placeholder="أدخل مدة التسليم">
                    <i class="fas fa-clock absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">المبلغ المدفوع <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="number" id="amountPaid" name="amountPaid" required class="form-input w-full" placeholder="أدخل المبلغ المدفوع">
                    <i class="fas fa-dollar-sign absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">المبلغ المتبقي</label>
                  <div class="relative">
                    <input type="number" id="remainingAmount" name="remainingAmount" readonly class="form-input w-full bg-gray-50" placeholder="يتم الحساب تلقائياً">
                    <i class="fas fa-calculator absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
              </div>
            </div>

            <!-- التواريخ -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-calendar-alt text-teal-500"></i>
                <span>تواريخ الطلب</span>
              </h3>
              <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">تاريخ رفع الطلب <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="date" id="orderUploadDate" name="orderUploadDate" required class="form-input w-full">
                    <i class="fas fa-calendar-plus absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">تاريخ التسليم المجدول <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="date" id="scheduledDeliveryDate" name="scheduledDeliveryDate" required class="form-input w-full">
                    <i class="fas fa-calendar-check absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
              </div>
            </div>

            <!-- معلومات المستلم -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-user-check text-indigo-500"></i>
                <span>معلومات المستلم والموظف المسؤول</span>
              </h3>
              <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">اسم المستلم <span class="text-red-500">*</span></label>
                  <input type="text" id="recipientName" name="recipientName" required class="form-input w-full" placeholder="أدخل اسم المستلم">
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">رقم الهاتف <span class="text-red-500">*</span></label>
                  <input type="tel" id="phoneNumber" name="phoneNumber" required class="form-input w-full" placeholder="أدخل رقم الهاتف">
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">شركة التوصيل</label>
                  <input type="text" id="deliveryCompany" name="deliveryCompany" class="form-input w-full" placeholder="أدخل اسم شركة التوصيل">
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">اسم الموظف المسؤول <span class="text-red-500">*</span></label>
                  <input type="text" id="responsibleEmployee" name="responsibleEmployee" required class="form-input w-full" value="<?php echo htmlspecialchars($currentUser['full_name']); ?>" readonly>
                </div>
              </div>
            </div>

            <!-- معلومات المبالغ والربح -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-money-bill-wave text-green-600"></i>
                <span>المعلومات المالية وحساب الربح</span>
              </h3>
              <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">المبلغ المتفق مع العميل <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="number" id="amountAgreedWithCustomer" name="amountAgreedWithCustomer" required class="form-input w-full pr-10" placeholder="أدخل المبلغ المتفق مع العميل" oninput="calculateProfit()">
                    <i class="fas fa-dollar-sign absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">المبلغ المتفق مع الوكيل <span class="text-red-500">*</span></label>
                  <div class="relative">
                    <input type="number" id="amountAgreedWithAgent" name="amountAgreedWithAgent" required class="form-input w-full pr-10" placeholder="أدخل المبلغ المتفق مع الوكيل" oninput="calculateProfit()">
                    <i class="fas fa-dollar-sign absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">مصاريف أخرى</label>
                  <div class="relative">
                    <input type="number" id="otherExpenses" name="otherExpenses" class="form-input w-full pr-10" placeholder="أدخل المصاريف الأخرى" oninput="calculateProfit()">
                    <i class="fas fa-dollar-sign absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">الربح</label>
                  <div class="relative">
                    <input type="number" id="profit" name="profit" readonly class="form-input w-full bg-gray-50 pr-10 font-bold text-green-600" placeholder="يتم الحساب تلقائياً">
                    <i class="fas fa-calculator absolute left-3 top-3 text-gray-400"></i>
                  </div>
                </div>
              </div>
            </div>

            <!-- حالة الطلب -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-tasks text-blue-500"></i>
                <span>حالة الطلب</span>
              </h3>
              <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">حالة الطلب <span class="text-red-500">*</span></label>
                  <select id="orderStatus" name="orderStatus" required class="form-input w-full">
                    <option value="جديد">جديد</option>
                    <option value="قيد المعالجة">قيد المعالجة</option>
                    <option value="تم الشحن">تم الشحن</option>
                    <option value="في الطريق">في الطريق</option>
                    <option value="تم التسليم">تم التسليم</option>
                    <option value="ملغي">ملغي</option>
                  </select>
                </div>
                <div>
                  <label class="block text-sm font-medium text-gray-700 mb-1">حالة الدفع <span class="text-red-500">*</span></label>
                  <select id="paymentStatus" name="paymentStatus" required class="form-input w-full">
                    <option value="غير مدفوع">غير مدفوع</option>
                    <option value="مدفوع جزئياً">مدفوع جزئياً</option>
                    <option value="مدفوع بالكامل">مدفوع بالكامل</option>
                  </select>
                </div>
              </div>
            </div>

            <!-- الملاحظات -->
            <div class="form-section bg-white rounded-lg shadow-sm p-6 mb-6 border border-gray-200 hover:border-indigo-300 transition-all duration-300">
              <h3 class="form-section-title">
                <i class="fas fa-sticky-note text-yellow-500"></i>
                <span>ملاحظات إضافية</span>
              </h3>
              <div>
                <textarea id="notes" name="notes" rows="3" class="form-input w-full" placeholder="أدخل أي ملاحظات إضافية حول الطلب..."></textarea>
                <p class="text-xs text-gray-500 mt-2">
                  <i class="fas fa-info-circle ml-1"></i>
                  يمكنك إضافة أي معلومات إضافية متعلقة بالطلب هنا، مثل تعليمات خاصة للتسليم أو متطلبات خاصة للعميل.
                </p>
              </div>
            </div>

            <!-- أزرار الإجراءات -->
            <div class="flex flex-col md:flex-row gap-4 mt-6 sticky bottom-0 bg-white p-4 rounded-lg shadow-lg border border-gray-200 z-10">
              <button type="button" id="submitOrderBtn" class="btn btn-primary flex-1 max-w-xs">
                <i class="fas fa-paper-plane ml-2"></i>
                <span>إرسال الطلب</span>
              </button>
              <button type="button" id="saveAsDraftBtn" class="btn bg-blue-500 hover:bg-blue-600 text-white flex-1 max-w-xs">
                <i class="fas fa-save ml-2"></i>
                <span>حفظ كمسودة</span>
              </button>
              <button type="reset" class="btn btn-secondary flex-1 max-w-xs">
                <i class="fas fa-undo ml-2"></i>
                <span>إعادة تعيين</span>
              </button>
              <a href="../index.php" class="btn bg-gray-500 hover:bg-gray-600 text-white flex-1 max-w-xs">
                <i class="fas fa-home ml-2"></i>
                <span>العودة للرئيسية</span>
              </a>
            </div>
          </form>
        </div>
      </div>
    </div>
  </main>

  <!-- تضمين ملفات JavaScript -->
  <script src="js/order-form.js"></script>
  <script src="js/form-handler.js"></script>

  <!-- تضمين مكتبة SweetAlert2 للتنبيهات الجميلة -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
    /**
     * دالة لحساب الربح تلقائياً
     * تحسب الربح بناءً على المبلغ المتفق مع العميل والمبلغ المتفق مع الوكيل والمصاريف الأخرى
     */
    function calculateProfit() {
      const amountWithCustomer = parseFloat(document.getElementById('amountAgreedWithCustomer').value) || 0;
      const amountWithAgent = parseFloat(document.getElementById('amountAgreedWithAgent').value) || 0;
      const otherExpenses = parseFloat(document.getElementById('otherExpenses').value) || 0;

      const profit = amountWithCustomer - amountWithAgent - otherExpenses;
      const profitField = document.getElementById('profit');

      profitField.value = profit.toFixed(2);

      // تغيير لون الربح بناءً على القيمة
      if (profit > 0) {
        profitField.classList.remove('text-red-600', 'text-gray-600');
        profitField.classList.add('text-green-600');
      } else if (profit < 0) {
        profitField.classList.remove('text-green-600', 'text-gray-600');
        profitField.classList.add('text-red-600');
      } else {
        profitField.classList.remove('text-green-600', 'text-red-600');
        profitField.classList.add('text-gray-600');
      }
    }

    /**
     * دالة لحساب المبلغ المتبقي تلقائياً
     * تحسب المبلغ المتبقي بناءً على رسوم الخدمة والمبلغ المدفوع
     */
    function calculateRemainingAmount() {
      const serviceFee = parseFloat(document.getElementById('serviceFees').value) || 0;
      const amountPaid = parseFloat(document.getElementById('amountPaid').value) || 0;

      const remainingAmount = serviceFee - amountPaid;
      const remainingField = document.getElementById('remainingAmount');

      remainingField.value = remainingAmount.toFixed(2);

      // تحديث حالة الدفع تلقائياً
      const paymentStatusField = document.getElementById('paymentStatus');

      if (remainingAmount <= 0) {
        paymentStatusField.value = 'مدفوع بالكامل';
      } else if (amountPaid > 0) {
        paymentStatusField.value = 'مدفوع جزئياً';
      } else {
        paymentStatusField.value = 'غير مدفوع';
      }
    }

    /**
     * دالة لإنشاء رقم طلب جديد
     * تنشئ رقم طلب بناءً على رمز الفرع المحدد
     */
    function generateOrderNumber() {
      const branchSelect = document.getElementById('branch');
      const orderNumberField = document.getElementById('orderNumber');

      if (!branchSelect || !orderNumberField) return;

      const selectedOption = branchSelect.options[branchSelect.selectedIndex];
      if (!selectedOption || !selectedOption.value) return;

      // الحصول على رمز الفرع
      const branchCode = selectedOption.getAttribute('data-code');
      if (!branchCode) return;

      // إظهار مؤشر التحميل
      orderNumberField.value = 'جاري إنشاء رقم الطلب...';

      // الحصول على التاريخ الحالي
      const now = new Date();
      const year = now.getFullYear().toString().substr(-2);
      const month = (now.getMonth() + 1).toString().padStart(2, '0');

      // إنشاء رقم تسلسلي عشوائي (في الإصدار النهائي يجب استبداله برقم من قاعدة البيانات)
      const randomNum = Math.floor(Math.random() * 1000).toString().padStart(3, '0');

      // تنسيق رقم الطلب: رمز الفرع + السنة + الشهر + رقم تسلسلي
      const orderNumber = `${branchCode}${year}${month}-${randomNum}`;

      // محاكاة طلب AJAX للحصول على رقم الطلب من الخادم
      setTimeout(() => {
        orderNumberField.value = orderNumber;

        // إضافة تأثير بصري لتأكيد إنشاء الرقم
        orderNumberField.classList.add('bg-green-50', 'border-green-300');
        setTimeout(() => {
          orderNumberField.classList.remove('bg-green-50', 'border-green-300');
        }, 1500);
      }, 800);
    }

    /**
     * دالة للتحقق من صحة النموذج
     * تتحقق من إدخال جميع الحقول المطلوبة
     */
    function validateForm() {
      const requiredFields = document.querySelectorAll('input[required], select[required], textarea[required]');
      let isValid = true;

      requiredFields.forEach(field => {
        if (!field.value.trim()) {
          field.classList.add('border-red-500');
          if (!field.nextElementSibling || !field.nextElementSibling.classList.contains('error-message')) {
            const errorMsg = document.createElement('p');
            errorMsg.className = 'error-message text-red-500 text-xs mt-1';
            errorMsg.textContent = 'هذا الحقل مطلوب';
            field.parentNode.insertBefore(errorMsg, field.nextSibling);
          }
          isValid = false;
        } else {
          field.classList.remove('border-red-500');
          if (field.nextElementSibling && field.nextElementSibling.classList.contains('error-message')) {
            field.nextElementSibling.remove();
          }
        }
      });

      return isValid;
    }

    /**
     * دالة لإرسال النموذج
     * تتحقق من صحة النموذج وترسل البيانات إلى الخادم
     */
    function submitForm() {
      if (!validateForm()) {
        // عرض رسالة خطأ
        Swal.fire({
          icon: 'error',
          title: 'خطأ في النموذج',
          text: 'يرجى ملء جميع الحقول المطلوبة',
          confirmButtonText: 'حسناً'
        });
        return;
      }

      // عرض تأكيد قبل الإرسال
      Swal.fire({
        icon: 'question',
        title: 'تأكيد إرسال الطلب',
        text: 'هل أنت متأكد من إرسال الطلب؟',
        showCancelButton: true,
        confirmButtonText: 'نعم، إرسال',
        cancelButtonText: 'إلغاء'
      }).then((result) => {
        if (result.isConfirmed) {
          // محاكاة إرسال النموذج
          const submitBtn = document.getElementById('submitOrderBtn');
          submitBtn.disabled = true;
          submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin ml-2"></i> <span>جاري الإرسال...</span>';

          // في الإصدار النهائي، يجب استبدال هذا بإرسال حقيقي للبيانات
          setTimeout(() => {
            Swal.fire({
              icon: 'success',
              title: 'تم إرسال الطلب بنجاح',
              text: 'تم إنشاء الطلب برقم: ' + document.getElementById('orderNumber').value,
              confirmButtonText: 'حسناً'
            }).then(() => {
              // إعادة توجيه المستخدم إلى صفحة إدارة الطلبات
              window.location.href = 'orders.php';
            });
          }, 1500);
        }
      });
    }

    /**
     * دالة لحفظ الطلب كمسودة
     */
    function saveAsDraft() {
      // عرض تأكيد قبل الحفظ
      Swal.fire({
        icon: 'question',
        title: 'حفظ كمسودة',
        text: 'هل تريد حفظ الطلب كمسودة؟',
        showCancelButton: true,
        confirmButtonText: 'نعم، حفظ',
        cancelButtonText: 'إلغاء'
      }).then((result) => {
        if (result.isConfirmed) {
          // محاكاة حفظ المسودة
          const draftBtn = document.getElementById('saveAsDraftBtn');
          draftBtn.disabled = true;
          draftBtn.innerHTML = '<i class="fas fa-spinner fa-spin ml-2"></i> <span>جاري الحفظ...</span>';

          setTimeout(() => {
            Swal.fire({
              icon: 'success',
              title: 'تم الحفظ بنجاح',
              text: 'تم حفظ الطلب كمسودة',
              confirmButtonText: 'حسناً'
            }).then(() => {
              draftBtn.disabled = false;
              draftBtn.innerHTML = '<i class="fas fa-save ml-2"></i> <span>حفظ كمسودة</span>';
            });
          }, 1000);
        }
      });
    }

    // تنفيذ الدوال عند تحميل الصفحة
    document.addEventListener('DOMContentLoaded', function() {
      // تعيين تاريخ اليوم كتاريخ افتراضي لرفع الطلب
      if (document.getElementById('orderUploadDate')) {
        document.getElementById('orderUploadDate').valueAsDate = new Date();
      }

      // إضافة مستمعي الأحداث لحساب المبلغ المتبقي
      if (document.getElementById('serviceFees')) {
        document.getElementById('serviceFees').addEventListener('input', calculateRemainingAmount);
      }

      if (document.getElementById('amountPaid')) {
        document.getElementById('amountPaid').addEventListener('input', calculateRemainingAmount);
      }

      // إضافة مستمع الحدث لإنشاء رقم الطلب عند تغيير الفرع
      if (document.getElementById('branch')) {
        document.getElementById('branch').addEventListener('change', generateOrderNumber);
      }

      // إضافة مستمعي الأحداث لأزرار النموذج
      if (document.getElementById('submitOrderBtn')) {
        document.getElementById('submitOrderBtn').addEventListener('click', submitForm);
      }

      if (document.getElementById('saveAsDraftBtn')) {
        document.getElementById('saveAsDraftBtn').addEventListener('click', saveAsDraft);
      }

      // تنفيذ حساب الربح والمبلغ المتبقي عند تحميل الصفحة
      calculateProfit();
      calculateRemainingAmount();
    });
  </script>
