<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>تسجيل الدخول - مجموعة ابراهيم الاحمدي اليمنية</title>
  <!-- Font Awesome للأيقونات -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- خط Tajawal -->
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <!-- ملف CSS المميز الجديد -->
  <link rel="stylesheet" href="/assets/css/premium-login.css">
  <style>
    /* تنسيق قائمة اختيار الفرع */
    select.login-input {
      appearance: none;
      -webkit-appearance: none;
      -moz-appearance: none;
      background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23f8b500' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
      background-repeat: no-repeat;
      background-position: left 1rem center;
      background-size: 1rem;
      padding-left: 2.5rem;
    }

    select.login-input option {
      color: #333;
      background-color: #fff;
      padding: 0.5rem;
    }

    .branch-code {
      color: #f8b500;
      font-size: 0.9em;
      margin-right: 0.3rem;
    }

    /* تحسين مظهر قائمة الفروع */
    select.login-input option:hover,
    select.login-input option:focus {
      background-color: #fff8e6;
    }

    select.login-input option:first-child {
      font-weight: bold;
      border-bottom: 1px solid #eee;
    }

    /* تنسيق التعليمات التوضيحية */
    .branch-info {
      margin-top: -5px;
      margin-bottom: 20px;
      text-align: center;
    }

    .branch-hint {
      font-size: 0.85rem;
      color: rgba(255, 255, 255, 0.8);
      font-style: italic;
      line-height: 1.5;
      padding: 8px;
      border-radius: 8px;
      background-color: rgba(255, 255, 255, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.2);
      animation: pulse 2s infinite ease-in-out;
    }

    /* تأثير النبض */
    @keyframes pulse {
      0%, 100% { opacity: 0.8; transform: scale(1); }
      50% { opacity: 1; transform: scale(1.02); }
    }

    /* تأثير الظهور التدريجي */
    @keyframes fadeIn {
      0% { opacity: 0; transform: translateY(10px); }
      100% { opacity: 1; transform: translateY(0); }
    }

    .branch-hint strong {
      color: #f8b500;
      font-weight: bold;
      display: block;
      margin-top: 4px;
    }

    /* تنسيق زر التموج */
    .ripple {
      position: absolute;
      background: radial-gradient(circle, rgba(255, 255, 255, 0.7) 0%, rgba(248, 181, 0, 0.5) 50%, rgba(248, 181, 0, 0.2) 100%);
      border-radius: 50%;
      transform: scale(0);
      animation: ripple 0.8s cubic-bezier(0.11, 0.65, 0.33, 1);
      pointer-events: none;
    }

    @keyframes ripple {
      0% {
        transform: scale(0);
        opacity: 0.8;
      }
      100% {
        transform: scale(5);
        opacity: 0;
      }
    }
  </style>
</head>

<body class="premium-login">
  <!-- خلفية متحركة -->
  <div class="premium-background"></div>

  <!-- الجسيمات المتحركة -->
  <div class="particles"></div>

  <!-- الخطوط الذهبية -->
  <div class="gold-lines"></div>

  <!-- حاوية النموذج -->
  <div class="login-container">
    <a href="/" class="close-btn" title="العودة للصفحة الرئيسية">
      <i class="fas fa-times"></i>
    </a>

    <!-- شعار الشركة -->
    <div class="company-logo">
      <img src="/assets/images/logo.png" alt="مجموعة ابراهيم الاحمدي اليمنية" class="logo-image">
    </div>

    <h2 class="login-title">تسجيل الدخول</h2>

    <form id="loginForm" action="/login" method="post">
      <!-- رمز CSRF للحماية من هجمات CSRF -->
      <input type="hidden" name="csrf_token" value="<?php echo $auth->generateCSRFToken(); ?>">

      <div class="input-group">
        <input type="email" name="email" class="login-input" placeholder="البريد الإلكتروني" required>
        <i class="fas fa-envelope input-icon"></i>
      </div>

      <div class="input-group">
        <input type="password" name="password" id="password" class="login-input" placeholder="كلمة المرور" required>
        <i class="fas fa-lock input-icon"></i>
      </div>

      <div class="input-group branch-selection" id="branch-selection">
        <select name="branch_id" id="branch_id" class="login-input">
          <option value="" disabled selected>اختر الفرع</option>
          <?php foreach ($branches as $branch): ?>
          <option value="<?php echo $branch['id']; ?>">
            <?php
            // تنسيق اسم الفرع بشكل موحد
            $displayName = $branch['name'];
            $displayCode = $branch['code'];

            // إذا كان الاسم لا يبدأ بكلمة "فرع" وليس المركز الرئيسي، أضف كلمة "فرع"
            if (strpos($displayName, 'فرع') === false && $displayName != 'المركز الرئيسي') {
                $displayName = 'فرع ' . $displayName;
            }

            echo htmlspecialchars($displayName);
            ?>
            <?php if (!empty($displayCode)): ?>
            <span class="branch-code">(<?php echo htmlspecialchars($displayCode); ?>)</span>
            <?php endif; ?>
          </option>
          <?php endforeach; ?>
        </select>
        <i class="fas fa-building input-icon"></i>
      </div>

      <div class="branch-info" id="branch-info">
        <p class="branch-hint">سيتم عرض البيانات والإحصائيات الخاصة بالفرع المحدد</p>
      </div>

      <div class="remember-forgot">
        <div class="checkbox-container">
          <input type="checkbox" id="remember" name="remember" class="auth-checkbox">
          <label for="remember">تذكرني</label>
        </div>
        <a href="/forgot-password" class="forgot-password">نسيت كلمة المرور؟</a>
      </div>

      <?php if (isset($_SESSION['login_error'])): ?>
      <div class="error-message">
        <?php echo $_SESSION['login_error']; unset($_SESSION['login_error']); ?>
      </div>
      <?php endif; ?>

      <?php if (isset($_SESSION['login_success'])): ?>
      <div class="success-message">
        <?php echo $_SESSION['login_success']; unset($_SESSION['login_success']); ?>
      </div>
      <?php endif; ?>

      <button type="submit" class="login-button">
        <i class="fas fa-sign-in-alt button-icon"></i>
        تسجيل الدخول
      </button>
    </form>

  </div>

  <!-- ملف JavaScript للتأثيرات -->
  <script src="/assets/js/premium-login-effects.js"></script>

  <!-- سكريبت للتحقق من مدير النظام -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const emailInput = document.querySelector('input[name="email"]');
      const branchSelection = document.getElementById('branch-selection');
      const branchInfo = document.getElementById('branch-info');
      const branchSelect = document.getElementById('branch_id');

      // إضافة مستمع لحدث تغيير البريد الإلكتروني
      emailInput.addEventListener('blur', function() {
        const email = this.value.trim().toLowerCase();

        // التحقق مما إذا كان البريد الإلكتروني هو بريد مدير النظام
        if (email === 'admin@al-ahmadigroup.com' || email === 'admin') {
          // إخفاء حقل اختيار الفرع
          branchSelection.style.display = 'none';
          branchInfo.style.display = 'none';

          // إزالة خاصية required من حقل اختيار الفرع
          branchSelect.removeAttribute('required');
        } else {
          // إظهار حقل اختيار الفرع
          branchSelection.style.display = 'block';
          branchInfo.style.display = 'block';

          // إضافة خاصية required إلى حقل اختيار الفرع
          branchSelect.setAttribute('required', 'required');
        }
      });

      // التحقق من البريد الإلكتروني عند تحميل الصفحة
      if (emailInput.value.trim().toLowerCase() === 'admin@al-ahmadigroup.com' || emailInput.value.trim().toLowerCase() === 'admin') {
        // إخفاء حقل اختيار الفرع
        branchSelection.style.display = 'none';
        branchInfo.style.display = 'none';

        // إزالة خاصية required من حقل اختيار الفرع
        branchSelect.removeAttribute('required');
      }
    });
  </script>
</body>

</html>
