<?php
// تعيين عنوان الصفحة والصفحة النشطة
$pageTitle = 'لوحة التحكم';
$activePage = 'dashboard';

// بدء مخزن مؤقت للمحتوى
ob_start();
?>

<!-- بطاقات الإحصائيات -->
<div class="stats-cards">
  <div class="stat-card">
    <div class="stat-icon">
      <i class="fas fa-shipping-fast"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">إجمالي الطلبات</h3>
      <p class="stat-value"><?php echo number_format($totalOrders); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon pending">
      <i class="fas fa-clock"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">قيد المعالجة</h3>
      <p class="stat-value"><?php echo number_format($pendingOrders); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon in-transit">
      <i class="fas fa-truck"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">قيد التوصيل</h3>
      <p class="stat-value"><?php echo number_format($inTransitOrders); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon delivered">
      <i class="fas fa-check-circle"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">تم التسليم</h3>
      <p class="stat-value"><?php echo number_format($deliveredOrders); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon cancelled">
      <i class="fas fa-times-circle"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">ملغى</h3>
      <p class="stat-value"><?php echo number_format($cancelledOrders); ?></p>
    </div>
  </div>
  
  <?php if ($isAdmin): ?>
  <div class="stat-card">
    <div class="stat-icon users">
      <i class="fas fa-users"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">المستخدمين</h3>
      <p class="stat-value"><?php echo number_format($totalUsers); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon branches">
      <i class="fas fa-building"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">الفروع</h3>
      <p class="stat-value"><?php echo number_format($totalBranches); ?></p>
    </div>
  </div>
  <?php endif; ?>
</div>

<!-- أقسام الإحصائيات -->
<div class="dashboard-sections">
  <!-- أفضل الموظفين أداءً -->
  <div class="dashboard-section">
    <div class="section-header">
      <h2 class="section-title">
        <i class="fas fa-user-tie"></i>
        أفضل الموظفين أداءً
      </h2>
    </div>
    <div class="section-content">
      <div class="top-performers">
        <?php foreach ($topEmployees as $employee): ?>
        <div class="performer-card">
          <div class="performer-avatar">
            <i class="fas fa-user"></i>
          </div>
          <div class="performer-details">
            <h3 class="performer-name"><?php echo htmlspecialchars($employee['name']); ?></h3>
            <p class="performer-stats">
              <span class="performer-orders"><?php echo number_format($employee['orders']); ?> طلب</span>
              <span class="performer-revenue"><?php echo number_format($employee['revenue']); ?> ريال</span>
            </p>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
  
  <!-- أفضل الفروع أداءً -->
  <div class="dashboard-section">
    <div class="section-header">
      <h2 class="section-title">
        <i class="fas fa-building"></i>
        أفضل الفروع أداءً
      </h2>
    </div>
    <div class="section-content">
      <div class="top-branches">
        <?php foreach ($topBranches as $branch): ?>
        <div class="branch-card">
          <div class="branch-icon">
            <i class="fas fa-building"></i>
          </div>
          <div class="branch-details">
            <h3 class="branch-name"><?php echo htmlspecialchars($branch['name']); ?></h3>
            <p class="branch-stats">
              <span class="branch-orders"><?php echo number_format($branch['orders']); ?> طلب</span>
              <span class="branch-revenue"><?php echo number_format($branch['revenue']); ?> ريال</span>
            </p>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>

<!-- الطلبات الأخيرة -->
<div class="dashboard-section recent-orders-section">
  <div class="section-header">
    <h2 class="section-title">
      <i class="fas fa-clipboard-list"></i>
      الطلبات الأخيرة
    </h2>
    <a href="/orders" class="view-all-link">عرض الكل</a>
  </div>
  <div class="section-content">
    <div class="table-responsive">
      <table class="data-table">
        <thead>
          <tr>
            <th>رقم الطلب</th>
            <th>اسم العميل</th>
            <th>الفرع</th>
            <th>التاريخ</th>
            <th>الحالة</th>
            <th>الإجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php if (empty($recentOrders)): ?>
          <tr>
            <td colspan="6" class="text-center">لا توجد طلبات حديثة</td>
          </tr>
          <?php else: ?>
            <?php foreach ($recentOrders as $order): ?>
            <tr>
              <td><?php echo htmlspecialchars($order['order_number']); ?></td>
              <td><?php echo htmlspecialchars($order['customer_name']); ?></td>
              <td><?php echo htmlspecialchars($order['branch_name']); ?></td>
              <td><?php echo date('Y-m-d', strtotime($order['created_at'])); ?></td>
              <td>
                <span class="status-badge status-<?php echo strtolower(str_replace(' ', '-', $order['status'])); ?>">
                  <?php echo htmlspecialchars($order['status']); ?>
                </span>
              </td>
              <td>
                <div class="actions">
                  <a href="/orders/view/<?php echo $order['id']; ?>" class="action-btn view-btn" title="عرض التفاصيل">
                    <i class="fas fa-eye"></i>
                  </a>
                </div>
              </td>
            </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php
// الحصول على محتوى المخزن المؤقت
$content = ob_get_clean();

// تضمين القالب الرئيسي
include dirname(__DIR__) . '/layouts/main.php';
?>
