<?php
// بدء مخزن مؤقت للمحتوى
ob_start();
?>

<div class="form-container">
  <div class="form-header">
    <h2 class="form-title">
      <i class="fas fa-plus-circle"></i>
      إنشاء طلب جديد
    </h2>
  </div>

  <form action="/orders/store" method="post" class="main-form">
    <!-- رمز CSRF للحماية من هجمات CSRF -->
    <input type="hidden" name="csrf_token" value="<?php echo $auth->generateCSRFToken(); ?>">

    <div class="form-section">
      <h3 class="section-title">معلومات الطلب</h3>

      <div class="form-row">
        <div class="form-group">
          <label for="branch_id">الفرع <span class="required">*</span></label>
          <select id="branch_id" name="branch_id" class="form-control" required>
            <option value="" disabled selected>اختر الفرع</option>
            <?php foreach ($branches as $branch): ?>
            <option value="<?php echo $branch['id']; ?>" <?php echo (count($branches) === 1) ? 'selected' : ''; ?>>
              <?php echo htmlspecialchars($branch['name']); ?>
              <?php if (!empty($branch['code'])): ?>
              (<?php echo htmlspecialchars($branch['code']); ?>)
              <?php endif; ?>
            </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label for="employee_name">اسم الموظف <span class="required">*</span></label>
          <input type="text" id="employee_name" name="employee_name" class="form-control" value="<?php echo htmlspecialchars($user['full_name']); ?>" required>
        </div>
      </div>
    </div>

    <div class="form-section">
      <h3 class="section-title">معلومات العميل</h3>

      <div class="form-row">
        <div class="form-group">
          <label for="customer_name">اسم العميل <span class="required">*</span></label>
          <input type="text" id="customer_name" name="customer_name" class="form-control" required>
        </div>

        <div class="form-group">
          <label for="customer_phone">رقم الهاتف</label>
          <input type="text" id="customer_phone" name="customer_phone" class="form-control" placeholder="05xxxxxxxx" pattern="05[0-9]{8}">
          <small class="form-text">يجب أن يبدأ الرقم بـ 05 ويتكون من 10 أرقام</small>
        </div>
      </div>

      <div class="form-row">
        <div class="form-group full-width">
          <label for="customer_address">العنوان</label>
          <textarea id="customer_address" name="customer_address" class="form-control" rows="2"></textarea>
        </div>
      </div>
    </div>

    <div class="form-section">
      <h3 class="section-title">تفاصيل الطلب</h3>

      <div class="form-row">
        <div class="form-group full-width">
          <label for="order_details">تفاصيل الطلب <span class="required">*</span></label>
          <textarea id="order_details" name="order_details" class="form-control" rows="4" required></textarea>
        </div>
      </div>

      <div class="form-row">
        <div class="form-group">
          <label for="amount_paid">المبلغ المدفوع</label>
          <div class="input-group">
            <input type="number" id="amount_paid" name="amount_paid" class="form-control" min="0" step="0.01" value="0">
            <div class="input-group-append">
              <span class="input-group-text">ريال</span>
            </div>
          </div>
        </div>

        <div class="form-group">
          <label for="status">حالة الطلب</label>
          <select id="status" name="status" class="form-control">
            <?php foreach ($config['order_statuses'] as $statusOption): ?>
            <option value="<?php echo htmlspecialchars($statusOption); ?>" <?php echo ($statusOption === 'قيد المعالجة') ? 'selected' : ''; ?>>
              <?php echo htmlspecialchars($statusOption); ?>
            </option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>
    </div>

    <div class="form-actions">
      <button type="submit" class="btn btn-primary">
        <i class="fas fa-save"></i>
        حفظ الطلب
      </button>
      <a href="/orders" class="btn btn-secondary">
        <i class="fas fa-times"></i>
        إلغاء
      </a>
    </div>
  </form>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    // التحقق من صحة رقم الهاتف
    const phoneInput = document.getElementById('customer_phone');
    phoneInput.addEventListener('input', function() {
      const phonePattern = /^05[0-9]{8}$/;
      if (this.value && !phonePattern.test(this.value)) {
        this.setCustomValidity('يجب أن يبدأ الرقم بـ 05 ويتكون من 10 أرقام');
      } else {
        this.setCustomValidity('');
      }
    });

    // التحقق من صحة المبلغ المدفوع
    const amountInput = document.getElementById('amount_paid');
    amountInput.addEventListener('input', function() {
      if (parseFloat(this.value) < 0) {
        this.setCustomValidity('يجب أن يكون المبلغ أكبر من أو يساوي صفر');
      } else {
        this.setCustomValidity('');
      }
    });
  });
</script>

<?php
// الحصول على محتوى المخزن المؤقت
$content = ob_get_clean();

// تضمين القالب الرئيسي
include dirname(__DIR__) . '/layouts/main.php';
?>
