<?php
// بدء مخزن مؤقت للمحتوى
ob_start();

// دالة مساعدة لبناء سلسلة الاستعلام
function buildQueryString($excludeParams = []) {
    $params = $_GET;
    foreach ($excludeParams as $param) {
        unset($params[$param]);
    }

    if (empty($params)) {
        return '';
    }

    return '&' . http_build_query($params);
}
?>

<!-- قسم البحث والفلترة -->
<div class="search-section">
  <form action="/orders" method="get" class="search-form">
    <div class="search-row">
      <div class="search-group">
        <label for="search">بحث:</label>
        <input type="text" id="search" name="search" value="<?php echo htmlspecialchars($search ?? ''); ?>" placeholder="رقم الطلب أو اسم العميل">
      </div>

      <div class="search-group">
        <label for="status">الحالة:</label>
        <select id="status" name="status">
          <option value="">جميع الحالات</option>
          <?php foreach ($config['order_statuses'] as $statusOption): ?>
          <option value="<?php echo htmlspecialchars($statusOption); ?>" <?php echo ($status === $statusOption) ? 'selected' : ''; ?>>
            <?php echo htmlspecialchars($statusOption); ?>
          </option>
          <?php endforeach; ?>
        </select>
      </div>

      <?php if ($isAdmin): ?>
      <div class="search-group">
        <label for="branch_id">الفرع:</label>
        <select id="branch_id" name="branch_id">
          <option value="">جميع الفروع</option>
          <?php foreach ($branches as $branchOption): ?>
          <option value="<?php echo $branchOption['id']; ?>" <?php echo ($branchId == $branchOption['id']) ? 'selected' : ''; ?>>
            <?php echo htmlspecialchars($branchOption['name']); ?>
          </option>
          <?php endforeach; ?>
        </select>
      </div>
      <?php endif; ?>
    </div>

    <div class="search-row">
      <div class="search-group">
        <label for="start_date">من تاريخ:</label>
        <input type="date" id="start_date" name="start_date" value="<?php echo htmlspecialchars($startDate ?? ''); ?>">
      </div>

      <div class="search-group">
        <label for="end_date">إلى تاريخ:</label>
        <input type="date" id="end_date" name="end_date" value="<?php echo htmlspecialchars($endDate ?? ''); ?>">
      </div>

      <div class="search-buttons">
        <button type="submit" class="btn btn-primary">
          <i class="fas fa-search"></i>
          بحث
        </button>
        <a href="/orders" class="btn btn-secondary">
          <i class="fas fa-redo"></i>
          إعادة تعيين
        </a>
      </div>
    </div>
  </form>
</div>

<!-- قسم النتائج -->
<div class="results-section">
  <div class="results-header">
    <h3 class="results-title">
      <i class="fas fa-clipboard-list"></i>
      قائمة الطلبات
      <span class="results-count">(<?php echo number_format($totalOrders); ?>)</span>
    </h3>

    <div class="results-actions">
      <a href="/orders/create" class="btn btn-success">
        <i class="fas fa-plus"></i>
        إنشاء طلب جديد
      </a>
    </div>
  </div>

  <div class="table-responsive">
    <table class="data-table">
      <thead>
        <tr>
          <th>رقم الطلب</th>
          <th>اسم العميل</th>
          <th>الفرع</th>
          <th>الموظف</th>
          <th>التاريخ</th>
          <th>المبلغ</th>
          <th>الحالة</th>
          <th>الإجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($orders)): ?>
        <tr>
          <td colspan="8" class="text-center">لا توجد طلبات</td>
        </tr>
        <?php else: ?>
          <?php foreach ($orders as $order): ?>
          <tr>
            <td><?php echo htmlspecialchars($order['order_number']); ?></td>
            <td><?php echo htmlspecialchars($order['customer_name']); ?></td>
            <td><?php echo htmlspecialchars($order['branch_name']); ?></td>
            <td><?php echo htmlspecialchars($order['employee_name']); ?></td>
            <td><?php echo date('Y-m-d', strtotime($order['created_at'])); ?></td>
            <td class="text-left"><?php echo number_format($order['amount_paid'], 2); ?> ريال</td>
            <td>
              <span class="status-badge status-<?php echo strtolower(str_replace(' ', '-', $order['status'])); ?>">
                <?php echo htmlspecialchars($order['status']); ?>
              </span>
            </td>
            <td>
              <div class="actions">
                <a href="/orders/view/<?php echo $order['id']; ?>" class="action-btn view-btn" title="عرض التفاصيل">
                  <i class="fas fa-eye"></i>
                </a>
                <a href="/orders/print/<?php echo $order['id']; ?>" class="action-btn print-btn" title="طباعة الطلب" target="_blank">
                  <i class="fas fa-print"></i>
                </a>
              </div>
            </td>
          </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <!-- ترقيم الصفحات -->
  <?php if ($totalPages > 1): ?>
  <div class="pagination">
    <ul class="pagination-list">
      <?php if ($page > 1): ?>
      <li class="pagination-item">
        <a href="/orders?page=1<?php echo buildQueryString(['page']); ?>" class="pagination-link">
          <i class="fas fa-angle-double-right"></i>
        </a>
      </li>
      <li class="pagination-item">
        <a href="/orders?page=<?php echo $page - 1; ?><?php echo buildQueryString(['page']); ?>" class="pagination-link">
          <i class="fas fa-angle-right"></i>
        </a>
      </li>
      <?php endif; ?>

      <?php
      $startPage = max(1, $page - 2);
      $endPage = min($totalPages, $page + 2);

      for ($i = $startPage; $i <= $endPage; $i++):
      ?>
      <li class="pagination-item <?php echo ($i === $page) ? 'active' : ''; ?>">
        <a href="/orders?page=<?php echo $i; ?><?php echo buildQueryString(['page']); ?>" class="pagination-link">
          <?php echo $i; ?>
        </a>
      </li>
      <?php endfor; ?>

      <?php if ($page < $totalPages): ?>
      <li class="pagination-item">
        <a href="/orders?page=<?php echo $page + 1; ?><?php echo buildQueryString(['page']); ?>" class="pagination-link">
          <i class="fas fa-angle-left"></i>
        </a>
      </li>
      <li class="pagination-item">
        <a href="/orders?page=<?php echo $totalPages; ?><?php echo buildQueryString(['page']); ?>" class="pagination-link">
          <i class="fas fa-angle-double-left"></i>
        </a>
      </li>
      <?php endif; ?>
    </ul>
  </div>
  <?php endif; ?>
</div>

<?php
// الحصول على محتوى المخزن المؤقت
$content = ob_get_clean();

// تضمين القالب الرئيسي
include dirname(__DIR__) . '/layouts/main.php';
?>
