<?php
// بدء مخزن مؤقت للمحتوى
ob_start();
?>

<div class="order-details-container">
  <div class="order-header">
    <div class="order-title">
      <h2>
        <i class="fas fa-clipboard-check"></i>
        تفاصيل الطلب: <?php echo htmlspecialchars($order['order_number']); ?>
      </h2>
    </div>

    <div class="order-actions">
      <a href="/orders/print/<?php echo $order['id']; ?>" class="btn btn-primary" target="_blank">
        <i class="fas fa-print"></i>
        طباعة
      </a>
      <a href="/orders" class="btn btn-secondary">
        <i class="fas fa-arrow-right"></i>
        العودة للقائمة
      </a>
    </div>
  </div>

  <div class="order-status-bar">
    <div class="status-label">حالة الطلب:</div>
    <div class="status-value">
      <span class="status-badge status-<?php echo strtolower(str_replace(' ', '-', $order['status'])); ?>">
        <?php echo htmlspecialchars($order['status']); ?>
      </span>
    </div>

    <form action="/orders/update-status/<?php echo $order['id']; ?>" method="post" class="status-form">
      <!-- رمز CSRF للحماية من هجمات CSRF -->
      <input type="hidden" name="csrf_token" value="<?php echo $auth->generateCSRFToken(); ?>">

      <div class="status-select">
        <select name="status" id="status" class="form-control">
          <?php foreach ($config['order_statuses'] as $statusOption): ?>
          <option value="<?php echo htmlspecialchars($statusOption); ?>" <?php echo ($statusOption === $order['status']) ? 'selected' : ''; ?>>
            <?php echo htmlspecialchars($statusOption); ?>
          </option>
          <?php endforeach; ?>
        </select>
      </div>

      <button type="submit" class="btn btn-sm btn-primary">
        <i class="fas fa-save"></i>
        تحديث الحالة
      </button>
    </form>
  </div>

  <div class="order-sections">
    <div class="order-section">
      <h3 class="section-title">معلومات الطلب</h3>

      <div class="info-grid">
        <div class="info-item">
          <div class="info-label">رقم الطلب:</div>
          <div class="info-value"><?php echo htmlspecialchars($order['order_number']); ?></div>
        </div>

        <div class="info-item">
          <div class="info-label">تاريخ الإنشاء:</div>
          <div class="info-value"><?php echo date('Y-m-d H:i', strtotime($order['created_at'])); ?></div>
        </div>

        <div class="info-item">
          <div class="info-label">الفرع:</div>
          <div class="info-value"><?php echo htmlspecialchars($order['branch_name']); ?></div>
        </div>

        <div class="info-item">
          <div class="info-label">الموظف:</div>
          <div class="info-value"><?php echo htmlspecialchars($order['employee_name']); ?></div>
        </div>

        <div class="info-item">
          <div class="info-label">المبلغ المدفوع:</div>
          <div class="info-value"><?php echo number_format($order['amount_paid'], 2); ?> ريال</div>
        </div>
      </div>
    </div>

    <div class="order-section">
      <h3 class="section-title">معلومات العميل</h3>

      <div class="info-grid">
        <div class="info-item">
          <div class="info-label">اسم العميل:</div>
          <div class="info-value"><?php echo htmlspecialchars($order['customer_name']); ?></div>
        </div>

        <div class="info-item">
          <div class="info-label">رقم الهاتف:</div>
          <div class="info-value">
            <?php if (!empty($order['customer_phone'])): ?>
            <a href="tel:<?php echo htmlspecialchars($order['customer_phone']); ?>" class="phone-link">
              <?php echo htmlspecialchars($order['customer_phone']); ?>
              <i class="fas fa-phone"></i>
            </a>
            <?php else: ?>
            <span class="text-muted">غير متوفر</span>
            <?php endif; ?>
          </div>
        </div>

        <div class="info-item full-width">
          <div class="info-label">العنوان:</div>
          <div class="info-value">
            <?php if (!empty($order['customer_address'])): ?>
            <?php echo nl2br(htmlspecialchars($order['customer_address'])); ?>
            <?php else: ?>
            <span class="text-muted">غير متوفر</span>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>

    <div class="order-section">
      <h3 class="section-title">تفاصيل الطلب</h3>

      <div class="order-details-text">
        <?php echo nl2br(htmlspecialchars($order['order_details'])); ?>
      </div>
    </div>
  </div>
</div>

<?php
// الحصول على محتوى المخزن المؤقت
$content = ob_get_clean();

// تضمين القالب الرئيسي
include dirname(__DIR__) . '/layouts/main.php';
?>
