<?php
// بدء مخزن مؤقت للمحتوى
ob_start();
?>

<!-- قسم التصفية والتنقل -->
<div class="report-controls">
  <div class="date-navigation">
    <a href="/reports/monthly?month=<?php echo $currentMonth - 1; ?>&year=<?php echo ($currentMonth == 1) ? $currentYear - 1 : $currentYear; ?>" class="nav-btn">
      <i class="fas fa-chevron-right"></i>
      الشهر السابق
    </a>
    
    <div class="current-period">
      <form action="/reports/monthly" method="get" class="period-form">
        <div class="form-row">
          <div class="form-group">
            <label for="month">الشهر:</label>
            <select name="month" id="month" class="form-control" onchange="this.form.submit()">
              <?php foreach ($arabicMonths as $monthNum => $monthName): ?>
              <option value="<?php echo $monthNum; ?>" <?php echo ($monthNum == $currentMonth) ? 'selected' : ''; ?>>
                <?php echo $monthName; ?>
              </option>
              <?php endforeach; ?>
            </select>
          </div>
          
          <div class="form-group">
            <label for="year">السنة:</label>
            <select name="year" id="year" class="form-control" onchange="this.form.submit()">
              <?php for ($i = date('Y') - 2; $i <= date('Y') + 1; $i++): ?>
              <option value="<?php echo $i; ?>" <?php echo ($i == $currentYear) ? 'selected' : ''; ?>>
                <?php echo $i; ?>
              </option>
              <?php endfor; ?>
            </select>
          </div>
          
          <?php if ($isAdmin): ?>
          <div class="form-group">
            <label for="branch_id">الفرع:</label>
            <select name="branch_id" id="branch_id" class="form-control" onchange="this.form.submit()">
              <option value="">جميع الفروع</option>
              <?php foreach ($branches as $branchOption): ?>
              <option value="<?php echo $branchOption['id']; ?>" <?php echo ($branchId == $branchOption['id']) ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($branchOption['name']); ?>
              </option>
              <?php endforeach; ?>
            </select>
          </div>
          <?php endif; ?>
        </div>
      </form>
      
      <div class="period-info">
        <i class="fas fa-calendar-alt"></i>
        <?php echo $arabicMonths[$currentMonth] . ' ' . $currentYear; ?>
      </div>
    </div>
    
    <a href="/reports/monthly?month=<?php echo $currentMonth + 1; ?>&year=<?php echo ($currentMonth == 12) ? $currentYear + 1 : $currentYear; ?>" class="nav-btn">
      الشهر التالي
      <i class="fas fa-chevron-left"></i>
    </a>
  </div>
  
  <div class="report-actions">
    <a href="/reports/export-excel?type=monthly&start_date=<?php echo $startDateFormatted; ?>&end_date=<?php echo $endDateFormatted; ?><?php echo !empty($branchId) ? '&branch_id=' . $branchId : ''; ?>" class="btn btn-success">
      <i class="fas fa-file-excel"></i>
      تصدير Excel
    </a>
    <a href="/reports/print?type=monthly&start_date=<?php echo $startDateFormatted; ?>&end_date=<?php echo $endDateFormatted; ?><?php echo !empty($branchId) ? '&branch_id=' . $branchId : ''; ?>" class="btn btn-primary" target="_blank">
      <i class="fas fa-print"></i>
      طباعة
    </a>
  </div>
</div>

<!-- قسم الإحصائيات -->
<div class="stats-cards">
  <div class="stat-card">
    <div class="stat-icon">
      <i class="fas fa-shipping-fast"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">إجمالي الطلبات</h3>
      <p class="stat-value"><?php echo number_format($monthlyStats['total'] ?? 0); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon pending">
      <i class="fas fa-clock"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">قيد المعالجة</h3>
      <p class="stat-value"><?php echo number_format($monthlyStats['pending'] ?? 0); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon in-transit">
      <i class="fas fa-truck"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">قيد التوصيل</h3>
      <p class="stat-value"><?php echo number_format($monthlyStats['in_transit'] ?? 0); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon delivered">
      <i class="fas fa-check-circle"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">تم التسليم</h3>
      <p class="stat-value"><?php echo number_format($monthlyStats['delivered'] ?? 0); ?></p>
    </div>
  </div>
  
  <div class="stat-card">
    <div class="stat-icon cancelled">
      <i class="fas fa-times-circle"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">ملغى</h3>
      <p class="stat-value"><?php echo number_format($monthlyStats['cancelled'] ?? 0); ?></p>
    </div>
  </div>
  
  <div class="stat-card revenue">
    <div class="stat-icon">
      <i class="fas fa-money-bill-wave"></i>
    </div>
    <div class="stat-content">
      <h3 class="stat-title">إجمالي الإيرادات</h3>
      <p class="stat-value"><?php echo number_format($monthlyStats['total_revenue'] ?? 0, 2); ?> ريال</p>
    </div>
  </div>
</div>

<!-- قائمة الطلبات الشهرية -->
<div class="report-section">
  <div class="section-header">
    <h2 class="section-title">
      <i class="fas fa-clipboard-list"></i>
      قائمة الطلبات الشهرية
    </h2>
  </div>
  
  <div class="table-responsive">
    <table class="data-table">
      <thead>
        <tr>
          <th>رقم الطلب</th>
          <th>اسم العميل</th>
          <th>الفرع</th>
          <th>الموظف</th>
          <th>التاريخ</th>
          <th>المبلغ</th>
          <th>الحالة</th>
          <th>الإجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($monthlyOrders)): ?>
        <tr>
          <td colspan="8" class="text-center">لا توجد طلبات في هذا الشهر</td>
        </tr>
        <?php else: ?>
          <?php foreach ($monthlyOrders as $order): ?>
          <tr>
            <td><?php echo htmlspecialchars($order['order_number']); ?></td>
            <td><?php echo htmlspecialchars($order['customer_name']); ?></td>
            <td><?php echo htmlspecialchars($order['branch_name']); ?></td>
            <td><?php echo htmlspecialchars($order['employee_name']); ?></td>
            <td><?php echo date('Y-m-d', strtotime($order['created_at'])); ?></td>
            <td class="text-left"><?php echo number_format($order['amount_paid'], 2); ?> ريال</td>
            <td>
              <span class="status-badge status-<?php echo strtolower(str_replace(' ', '-', $order['status'])); ?>">
                <?php echo htmlspecialchars($order['status']); ?>
              </span>
            </td>
            <td>
              <div class="actions">
                <a href="/orders/view/<?php echo $order['id']; ?>" class="action-btn view-btn" title="عرض التفاصيل">
                  <i class="fas fa-eye"></i>
                </a>
                <a href="/orders/print/<?php echo $order['id']; ?>" class="action-btn print-btn" title="طباعة الطلب" target="_blank">
                  <i class="fas fa-print"></i>
                </a>
              </div>
            </td>
          </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
// الحصول على محتوى المخزن المؤقت
$content = ob_get_clean();

// تضمين القالب الرئيسي
include dirname(__DIR__) . '/layouts/main.php';
?>
