<?php
// بدء مخزن مؤقت للمحتوى
ob_start();
?>

<div class="page-header">
  <h2 class="page-title">
    <i class="fas fa-users"></i>
    إدارة المستخدمين
  </h2>

  <div class="page-actions">
    <a href="/users/create" class="btn btn-primary">
      <i class="fas fa-user-plus"></i>
      إضافة مستخدم جديد
    </a>
  </div>
</div>

<div class="table-responsive">
  <table class="data-table">
    <thead>
      <tr>
        <th>#</th>
        <th>اسم المستخدم</th>
        <th>الاسم الكامل</th>
        <th>البريد الإلكتروني</th>
        <th>الصلاحية</th>
        <th>الفرع</th>
        <th>الحالة</th>
        <th>تاريخ الإنشاء</th>
        <th>الإجراءات</th>
      </tr>
    </thead>
    <tbody>
      <?php if (empty($users)): ?>
      <tr>
        <td colspan="9" class="text-center">لا يوجد مستخدمين</td>
      </tr>
      <?php else: ?>
        <?php foreach ($users as $index => $userItem): ?>
        <tr>
          <td><?php echo $index + 1; ?></td>
          <td><?php echo htmlspecialchars($userItem['username']); ?></td>
          <td><?php echo htmlspecialchars($userItem['full_name']); ?></td>
          <td><?php echo htmlspecialchars($userItem['email']); ?></td>
          <td>
            <span class="role-badge role-<?php echo strtolower($userItem['role']); ?>">
              <?php
              switch ($userItem['role']) {
                  case 'admin':
                      echo 'مدير النظام';
                      break;
                  case 'manager':
                      echo 'مدير';
                      break;
                  case 'user':
                      echo 'مستخدم';
                      break;
                  default:
                      echo htmlspecialchars($userItem['role']);
              }
              ?>
            </span>
          </td>
          <td>
            <?php
            // الحصول على اسم الفرع
            $branchName = 'غير محدد';
            if (!empty($userItem['branch_id'])) {
                foreach ($branches as $branch) {
                    if ($branch['id'] == $userItem['branch_id']) {
                        $branchName = $branch['name'];
                        break;
                    }
                }
            }
            echo htmlspecialchars($branchName);
            ?>
          </td>
          <td>
            <span class="status-badge status-<?php echo $userItem['is_active'] ? 'active' : 'inactive'; ?>">
              <?php echo $userItem['is_active'] ? 'نشط' : 'غير نشط'; ?>
            </span>
          </td>
          <td><?php echo date('Y-m-d', strtotime($userItem['created_at'])); ?></td>
          <td>
            <div class="actions">
              <a href="/users/edit/<?php echo $userItem['id']; ?>" class="action-btn edit-btn" title="تعديل">
                <i class="fas fa-edit"></i>
              </a>

              <?php if ($userItem['id'] != $user['id']): // لا يمكن حذف المستخدم الحالي ?>
              <button type="button" class="action-btn delete-btn" title="حذف" data-toggle="modal" data-target="#deleteModal" data-id="<?php echo $userItem['id']; ?>" data-name="<?php echo htmlspecialchars($userItem['full_name']); ?>">
                <i class="fas fa-trash-alt"></i>
              </button>
              <?php endif; ?>
            </div>
          </td>
        </tr>
        <?php endforeach; ?>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<!-- نافذة تأكيد الحذف -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        هل أنت متأكد من حذف المستخدم <span id="userName"></span>؟
      </div>
      <div class="modal-footer">
        <form action="/users/delete" method="post" id="deleteForm">
          <!-- رمز CSRF للحماية من هجمات CSRF -->
          <input type="hidden" name="csrf_token" value="<?php echo $auth->generateCSRFToken(); ?>">
          <input type="hidden" name="user_id" id="userId">

          <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
          <button type="submit" class="btn btn-danger">حذف</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    // تحديث بيانات نافذة تأكيد الحذف
    const deleteModal = document.getElementById('deleteModal');
    if (deleteModal) {
      deleteModal.addEventListener('show.bs.modal', function(event) {
        const button = event.relatedTarget;
        const userId = button.getAttribute('data-id');
        const userName = button.getAttribute('data-name');

        document.getElementById('userId').value = userId;
        document.getElementById('userName').textContent = userName;
      });
    }
  });
</script>

<?php
// الحصول على محتوى المخزن المؤقت
$content = ob_get_clean();

// تضمين القالب الرئيسي
include dirname(__DIR__) . '/layouts/main.php';
?>
