<?php
/**
 * ملف إعدادات قاعدة البيانات
 * يحتوي على إعدادات الاتصال بقاعدة البيانات
 */

// تعريف ثابت للتحقق من الوصول الآمن
define('SECURE_ACCESS', true);

// التحقق من وجود ملف بيانات الاتصال
$db_credentials_file = __DIR__ . '/db_credentials.php';

if (file_exists($db_credentials_file)) {
    // استيراد بيانات الاتصال من الملف
    $db_credentials = require $db_credentials_file;

    // تعيين متغيرات الاتصال
    $db_host = $db_credentials['db_host'];
    $db_name = $db_credentials['db_name'];
    $db_user = $db_credentials['db_user'];
    $db_pass = $db_credentials['db_pass'];
    $use_mysql = $db_credentials['use_mysql'];
    $sqlite_db_file = $db_credentials['sqlite_db_file'];
} else {
    // إذا لم يكن الملف موجودًا، استخدم القيم الافتراضية
    $db_host = 'localhost';
    $db_name = 'shipping_db';
    $db_user = 'root';
    $db_pass = '';
    $use_mysql = false; // استخدام SQLite بدلاً من MySQL
    $sqlite_db_file = dirname(__DIR__) . '/database/shipping.sqlite';

    // تسجيل تحذير
    error_log('تحذير: ملف بيانات الاتصال بقاعدة البيانات غير موجود. يتم استخدام القيم الافتراضية.');

    // إنشاء ملف بيانات الاتصال
    $db_credentials_content = <<<EOT
<?php
/**
 * ملف بيانات الاتصال بقاعدة البيانات
 * يحتوي على بيانات الاتصال بقاعدة البيانات
 */

// التحقق من الوصول الآمن
if (!defined('SECURE_ACCESS')) {
    exit('غير مسموح بالوصول المباشر');
}

return [
    'db_host' => 'localhost',
    'db_name' => 'shipping_db',
    'db_user' => 'root',
    'db_pass' => '',
    'use_mysql' => true,
    'sqlite_db_file' => dirname(__DIR__) . '/database/shipping.sqlite'
];
EOT;

    // حفظ ملف بيانات الاتصال
    file_put_contents($db_credentials_file, $db_credentials_content);
}

// إرجاع إعدادات قاعدة البيانات
return [
    'db_host' => $db_host,
    'db_name' => $db_name,
    'db_user' => $db_user,
    'db_pass' => $db_pass,
    'use_mysql' => $use_mysql,
    'sqlite_db_file' => $sqlite_db_file,

    // إعدادات PDO
    'pdo_options' => [
        \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
        \PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC,
        \PDO::ATTR_EMULATE_PREPARES => false
    ],

    // إعدادات التخزين المؤقت
    'query_cache_enabled' => true,
    'query_cache_lifetime' => 300 // 5 دقائق
];
