/**
 * ملف JavaScript الرئيسي للنظام
 * يحتوي على جميع الوظائف المستخدمة في النظام
 */

document.addEventListener('DOMContentLoaded', function() {
  // تبديل الشريط الجانبي
  const sidebarToggle = document.querySelector('.sidebar-toggle');
  const sidebar = document.querySelector('.sidebar');
  const mainContent = document.querySelector('.main-content');
  
  if (sidebarToggle && sidebar && mainContent) {
    sidebarToggle.addEventListener('click', function() {
      sidebar.classList.toggle('active');
    });
  }
  
  // إغلاق التنبيهات
  const alertCloseButtons = document.querySelectorAll('.alert-close');
  
  alertCloseButtons.forEach(function(button) {
    button.addEventListener('click', function() {
      const alert = this.parentElement;
      alert.style.opacity = '0';
      setTimeout(function() {
        alert.style.display = 'none';
      }, 300);
    });
  });
  
  // إخفاء التنبيهات تلقائيًا بعد 5 ثوانٍ
  const alerts = document.querySelectorAll('.alert');
  
  alerts.forEach(function(alert) {
    setTimeout(function() {
      alert.style.opacity = '0';
      setTimeout(function() {
        alert.style.display = 'none';
      }, 300);
    }, 5000);
  });
  
  // تفعيل القوائم المنسدلة
  const dropdownToggles = document.querySelectorAll('.dropdown-toggle');
  
  dropdownToggles.forEach(function(toggle) {
    toggle.addEventListener('click', function(e) {
      e.preventDefault();
      const dropdown = this.nextElementSibling;
      dropdown.classList.toggle('show');
    });
  });
  
  // إغلاق القوائم المنسدلة عند النقر خارجها
  document.addEventListener('click', function(e) {
    dropdownToggles.forEach(function(toggle) {
      const dropdown = toggle.nextElementSibling;
      if (!toggle.contains(e.target) && !dropdown.contains(e.target) && dropdown.classList.contains('show')) {
        dropdown.classList.remove('show');
      }
    });
  });
  
  // تفعيل النوافذ المنبثقة
  const modalTriggers = document.querySelectorAll('[data-toggle="modal"]');
  
  modalTriggers.forEach(function(trigger) {
    trigger.addEventListener('click', function() {
      const modalId = this.getAttribute('data-target');
      const modal = document.querySelector(modalId);
      
      if (modal) {
        // تحديث بيانات النافذة المنبثقة
        const event = new CustomEvent('show.bs.modal', {
          bubbles: true,
          cancelable: true,
          detail: { relatedTarget: this }
        });
        
        modal.dispatchEvent(event);
        
        // عرض النافذة المنبثقة
        modal.style.display = 'block';
        modal.classList.add('show');
        document.body.classList.add('modal-open');
        
        // إضافة خلفية داكنة
        const backdrop = document.createElement('div');
        backdrop.className = 'modal-backdrop fade show';
        document.body.appendChild(backdrop);
      }
    });
  });
  
  // إغلاق النوافذ المنبثقة
  const modalCloseButtons = document.querySelectorAll('[data-dismiss="modal"]');
  
  modalCloseButtons.forEach(function(button) {
    button.addEventListener('click', function() {
      const modal = this.closest('.modal');
      
      if (modal) {
        modal.classList.remove('show');
        setTimeout(function() {
          modal.style.display = 'none';
          document.body.classList.remove('modal-open');
          
          // إزالة الخلفية الداكنة
          const backdrop = document.querySelector('.modal-backdrop');
          if (backdrop) {
            backdrop.remove();
          }
        }, 300);
      }
    });
  });
  
  // إغلاق النوافذ المنبثقة عند النقر خارجها
  document.addEventListener('click', function(e) {
    const modals = document.querySelectorAll('.modal.show');
    
    modals.forEach(function(modal) {
      if (e.target === modal) {
        modal.classList.remove('show');
        setTimeout(function() {
          modal.style.display = 'none';
          document.body.classList.remove('modal-open');
          
          // إزالة الخلفية الداكنة
          const backdrop = document.querySelector('.modal-backdrop');
          if (backdrop) {
            backdrop.remove();
          }
        }, 300);
      }
    });
  });
  
  // تفعيل التبويبات
  const tabLinks = document.querySelectorAll('[data-toggle="tab"]');
  
  tabLinks.forEach(function(link) {
    link.addEventListener('click', function(e) {
      e.preventDefault();
      
      // إزالة الفئة النشطة من جميع الروابط
      tabLinks.forEach(function(tab) {
        tab.classList.remove('active');
        tab.parentElement.classList.remove('active');
      });
      
      // إضافة الفئة النشطة إلى الرابط الحالي
      this.classList.add('active');
      this.parentElement.classList.add('active');
      
      // إخفاء جميع محتويات التبويبات
      const tabContents = document.querySelectorAll('.tab-pane');
      tabContents.forEach(function(content) {
        content.classList.remove('active');
        content.classList.remove('show');
      });
      
      // عرض محتوى التبويب المحدد
      const targetId = this.getAttribute('href');
      const targetContent = document.querySelector(targetId);
      
      if (targetContent) {
        targetContent.classList.add('active');
        setTimeout(function() {
          targetContent.classList.add('show');
        }, 50);
      }
    });
  });
  
  // تفعيل التحقق من صحة النماذج
  const forms = document.querySelectorAll('form');
  
  forms.forEach(function(form) {
    form.addEventListener('submit', function(e) {
      if (!form.checkValidity()) {
        e.preventDefault();
        e.stopPropagation();
      }
      
      form.classList.add('was-validated');
    });
  });
  
  // تنسيق حقول التاريخ
  const dateInputs = document.querySelectorAll('input[type="date"]');
  
  dateInputs.forEach(function(input) {
    // تعيين التاريخ الافتراضي إذا كان فارغًا
    if (!input.value) {
      const today = new Date();
      const year = today.getFullYear();
      const month = String(today.getMonth() + 1).padStart(2, '0');
      const day = String(today.getDate()).padStart(2, '0');
      
      // تعيين التاريخ الافتراضي فقط إذا كان الحقل يحتوي على الفئة 'default-today'
      if (input.classList.contains('default-today')) {
        input.value = `${year}-${month}-${day}`;
      }
    }
  });
  
  // تنسيق حقول الأرقام
  const numberInputs = document.querySelectorAll('input[type="number"]');
  
  numberInputs.forEach(function(input) {
    input.addEventListener('input', function() {
      // التحقق من القيمة الدنيا
      if (this.hasAttribute('min') && parseFloat(this.value) < parseFloat(this.getAttribute('min'))) {
        this.setCustomValidity(`يجب أن تكون القيمة أكبر من أو تساوي ${this.getAttribute('min')}`);
      } else {
        this.setCustomValidity('');
      }
    });
  });
  
  // تنسيق حقول البريد الإلكتروني
  const emailInputs = document.querySelectorAll('input[type="email"]');
  
  emailInputs.forEach(function(input) {
    input.addEventListener('input', function() {
      const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      
      if (this.value && !emailPattern.test(this.value)) {
        this.setCustomValidity('يرجى إدخال عنوان بريد إلكتروني صالح');
      } else {
        this.setCustomValidity('');
      }
    });
  });
  
  // تنسيق حقول الهاتف
  const phoneInputs = document.querySelectorAll('input[pattern]');
  
  phoneInputs.forEach(function(input) {
    input.addEventListener('input', function() {
      const pattern = new RegExp(this.getAttribute('pattern'));
      
      if (this.value && !pattern.test(this.value)) {
        this.setCustomValidity('يرجى إدخال رقم هاتف صالح');
      } else {
        this.setCustomValidity('');
      }
    });
  });
});
