<?php
/**
 * نقطة الدخول الرئيسية للتطبيق
 *
 * هذا الملف يقوم بتهيئة التطبيق وتوجيه الطلبات إلى المتحكمات المناسبة
 *
 * @version 1.0
 * @author فريق التطوير
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تحديد مسار المجلد الرئيسي
define('ROOT_PATH', dirname(__DIR__));

// تسجيل الأخطاء في ملف
ini_set('log_errors', 1);
ini_set('error_log', ROOT_PATH . '/storage/logs/error.log');

try {
    // تضمين ملف التحميل التلقائي
    require_once ROOT_PATH . '/vendor/autoload.php';

    // تضمين ملف التكوين
    $config = require_once ROOT_PATH . '/config/config.php';

    // بدء الجلسة
    session_name($config['session_name']);
    session_start();

    // تهيئة الموجه
    $router = \App\Core\Router::getInstance();

    // توجيه الطلب
    $router->dispatch();
} catch (Exception $e) {
    // تسجيل الخطأ
    error_log("خطأ في تنفيذ التطبيق: " . $e->getMessage());

    // عرض رسالة الخطأ
    echo "<h1>حدث خطأ</h1>";
    echo "<p>نعتذر، حدث خطأ أثناء تنفيذ التطبيق.</p>";
    echo "<p>الرجاء المحاولة مرة أخرى لاحقًا.</p>";

    // عرض تفاصيل الخطأ في وضع التطوير
    if (defined('DEVELOPMENT_MODE') && DEVELOPMENT_MODE) {
        echo "<h2>تفاصيل الخطأ:</h2>";
        echo "<pre>" . $e->getMessage() . "</pre>";
        echo "<h3>مكدس الاستدعاء:</h3>";
        echo "<pre>" . $e->getTraceAsString() . "</pre>";
    }
}
