<?php
// تضمين ملف التحقق من تسجيل الدخول
require_once 'check_auth.php';

// إعادة توجيه المستخدم إلى صفحة التقارير الأسبوعية
$report_type = (isset($_SESSION['role']) && ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'manager')) ? 'admin' : 'user';
header("Location: weekly_reports.php?type=$report_type");
exit;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | تقارير النظام</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.css">
  <style>
    :root {
      --primary: #4f46e5;
      --primary-light: #818cf8;
      --secondary: #f59e0b;
      --dark: #1e293b;
      --light: #f8fafc;
    }

    @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap');

    body {
      font-family: 'Tajawal', sans-serif;
      background-color: #f1f5f9;
      color: var(--dark);
    }

    /* تصميم المحتوى الرئيسي */
    .main-content {
      transition: margin-right 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    /* كروت التقارير */
    .report-card {
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .report-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    /* أزرار */
    .btn-primary {
      background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
      transition: all 0.3s ease;
      box-shadow: 0 4px 6px -1px rgba(79, 70, 229, 0.3);
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 15px -3px rgba(79, 70, 229, 0.4);
    }

    /* تأثيرات الحركة */
    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(10px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .animate-fadeIn {
      animation: fadeIn 0.5s ease-out forwards;
    }

    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
      width: 8px;
      height: 8px;
    }

    ::-webkit-scrollbar-track {
      background: #f1f5f9;
    }

    ::-webkit-scrollbar-thumb {
      background-color: #c7d2fe;
      border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
      background-color: #a5b4fc;
    }

    /* تصميم الرسوم البيانية */
    .chart-container {
      position: relative;
      height: 300px;
      width: 100%;
    }
  </style>
</head>

<body class="bg-gray-50">

  <!-- تضمين القائمة الجانبية المشتركة -->
  <?php include_once '../includes/sidebar.php'; ?>

  <!-- المحتوى الرئيسي -->
  <main class="main-content mr-[280px] p-6">
    <!-- عنوان الصفحة -->
    <div class="flex justify-between items-center mb-6">
      <h1 class="text-2xl font-bold text-gray-800">تقارير النظام</h1>
      <div class="flex space-x-2 space-x-reverse">
        <button onclick="window.location.href='create.php'" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300">
          <i class="fas fa-plus ml-2"></i>
          <span>إنشاء تقرير جديد</span>
        </button>
      </div>
    </div>

    <!-- أنواع التقارير -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
      <div class="report-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 ml-3">
            <i class="fas fa-file-invoice text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">تقارير الطلبات</h3>
        </div>
        <p class="text-gray-600 mb-4">عرض تقارير تفصيلية عن الطلبات حسب الفترة الزمنية والفرع والحالة.</p>
        <a href="orders.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>عرض التقارير</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>

      <div class="report-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-green-100 flex items-center justify-center text-green-600 ml-3">
            <i class="fas fa-money-bill-wave text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">التقارير المالية</h3>
        </div>
        <p class="text-gray-600 mb-4">عرض تقارير مالية تفصيلية عن الإيرادات والمصروفات والأرباح.</p>
        <a href="financial.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>عرض التقارير</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>

      <div class="report-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center text-purple-600 ml-3">
            <i class="fas fa-users text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">تقارير العملاء</h3>
        </div>
        <p class="text-gray-600 mb-4">عرض تقارير تفصيلية عن العملاء وطلباتهم ومعدلات الشراء.</p>
        <a href="customers.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>عرض التقارير</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>
    </div>

    <!-- ملخص التقارير -->
    <div class="bg-white rounded-xl shadow-sm p-6 mb-8">
      <h2 class="text-xl font-bold mb-4 flex items-center">
        <i class="fas fa-chart-line text-indigo-600 ml-2"></i>
        <span>ملخص الأداء</span>
      </h2>

      <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- رسم بياني للطلبات -->
        <div>
          <h3 class="text-lg font-medium mb-3">الطلبات حسب الشهر</h3>
          <div class="chart-container">
            <canvas id="ordersChart"></canvas>
          </div>
        </div>

        <!-- رسم بياني للإيرادات -->
        <div>
          <h3 class="text-lg font-medium mb-3">الإيرادات حسب الشهر</h3>
          <div class="chart-container">
            <canvas id="revenueChart"></canvas>
          </div>
        </div>
      </div>
    </div>

    <!-- التقارير الأخيرة -->
    <div class="bg-white rounded-xl shadow-sm p-6">
      <h2 class="text-xl font-bold mb-4 flex items-center">
        <i class="fas fa-history text-indigo-600 ml-2"></i>
        <span>التقارير الأخيرة</span>
      </h2>

      <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
          <thead class="bg-gray-50">
            <tr>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                اسم التقرير
              </th>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                النوع
              </th>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                تاريخ الإنشاء
              </th>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                بواسطة
              </th>
              <th scope="col" class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">
                إجراء
              </th>
            </tr>
          </thead>
          <tbody class="bg-white divide-y divide-gray-200">
            <tr>
              <td class="px-3 py-4 whitespace-nowrap">
                <div class="text-sm font-medium text-gray-900">تقرير الطلبات الشهري</div>
              </td>
              <td class="px-3 py-4 whitespace-nowrap">
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                  طلبات
                </span>
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500">
                2023-05-01
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500">
                أحمد محمد
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500 text-center">
                <a href="#" class="text-indigo-600 hover:text-indigo-900 ml-3"><i class="fas fa-eye"></i></a>
                <a href="#" class="text-green-600 hover:text-green-900 ml-3"><i class="fas fa-download"></i></a>
              </td>
            </tr>
            <tr>
              <td class="px-3 py-4 whitespace-nowrap">
                <div class="text-sm font-medium text-gray-900">تقرير الإيرادات الربع سنوي</div>
              </td>
              <td class="px-3 py-4 whitespace-nowrap">
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                  مالي
                </span>
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500">
                2023-04-15
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500">
                محمد علي
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500 text-center">
                <a href="#" class="text-indigo-600 hover:text-indigo-900 ml-3"><i class="fas fa-eye"></i></a>
                <a href="#" class="text-green-600 hover:text-green-900 ml-3"><i class="fas fa-download"></i></a>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </main>

  <!-- سكريبت الرسوم البيانية -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // بيانات الطلبات
      const ordersCtx = document.getElementById('ordersChart').getContext('2d');
      const ordersChart = new Chart(ordersCtx, {
        type: 'bar',
        data: {
          labels: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو'],
          datasets: [{
            label: 'عدد الطلبات',
            data: [12, 19, 15, 25, 22, 30],
            backgroundColor: 'rgba(79, 70, 229, 0.6)',
            borderColor: 'rgba(79, 70, 229, 1)',
            borderWidth: 1
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          scales: {
            y: {
              beginAtZero: true
            }
          }
        }
      });

      // بيانات الإيرادات
      const revenueCtx = document.getElementById('revenueChart').getContext('2d');
      const revenueChart = new Chart(revenueCtx, {
        type: 'line',
        data: {
          labels: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو'],
          datasets: [{
            label: 'الإيرادات (بالريال)',
            data: [12000, 19000, 15000, 25000, 22000, 30000],
            backgroundColor: 'rgba(16, 185, 129, 0.2)',
            borderColor: 'rgba(16, 185, 129, 1)',
            borderWidth: 2,
            tension: 0.3
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          scales: {
            y: {
              beginAtZero: true
            }
          }
        }
      });
    });
  </script>
</body>

</html>
