<?php
// عرض جميع الأخطاء للمساعدة في التشخيص
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>اختبار الاتصال بقاعدة البيانات</h1>";

// معلومات الاتصال بقاعدة البيانات
$host = 'localhost';
$dbname = 'shipping_db';
$username = 'root';
$password = '';

// اختبار الاتصال بالخادم أولاً (بدون تحديد قاعدة البيانات)
try {
    $serverConn = new PDO("mysql:host=$host", $username, $password);
    $serverConn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<p style='color:green'>تم الاتصال بخادم قاعدة البيانات بنجاح.</p>";
    
    // التحقق من وجود قاعدة البيانات
    $stmt = $serverConn->query("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '$dbname'");
    $dbExists = $stmt->rowCount() > 0;
    
    if (!$dbExists) {
        echo "<p style='color:red'>قاعدة البيانات '$dbname' غير موجودة.</p>";
    } else {
        echo "<p style='color:green'>قاعدة البيانات '$dbname' موجودة.</p>";
        
        // الاتصال بقاعدة البيانات
        try {
            $dbConn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
            $dbConn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            echo "<p style='color:green'>تم الاتصال بقاعدة البيانات '$dbname' بنجاح.</p>";
            
            // التحقق من وجود الجداول
            $tables = ['branches', 'orders', 'users', 'order_sequences'];
            $existingTables = [];
            $missingTables = [];
            
            foreach ($tables as $table) {
                $stmt = $dbConn->query("SHOW TABLES LIKE '$table'");
                if ($stmt->rowCount() > 0) {
                    $existingTables[] = $table;
                } else {
                    $missingTables[] = $table;
                }
            }
            
            if (count($existingTables) > 0) {
                echo "<h2>الجداول الموجودة:</h2>";
                echo "<ul>";
                foreach ($existingTables as $table) {
                    echo "<li>$table</li>";
                }
                echo "</ul>";
            }
            
            if (count($missingTables) > 0) {
                echo "<h2>الجداول غير الموجودة:</h2>";
                echo "<ul>";
                foreach ($missingTables as $table) {
                    echo "<li>$table</li>";
                }
                echo "</ul>";
            }
            
        } catch (PDOException $e) {
            echo "<p style='color:red'>فشل الاتصال بقاعدة البيانات '$dbname': " . $e->getMessage() . "</p>";
        }
    }
    
} catch (PDOException $e) {
    echo "<p style='color:red'>فشل الاتصال بخادم قاعدة البيانات: " . $e->getMessage() . "</p>";
}
?>
