<?php
/**
 * ملف للتحقق من الاتصال بقاعدة البيانات MySQL
 */

// تعيين رأس HTTP للتعامل مع الترميز العربي
header('Content-Type: text/html; charset=utf-8');

// معلومات الاتصال بقاعدة البيانات
$host = '127.0.0.1';      // استخدام عنوان IP بدلاً من localhost
$username = 'root';       // اسم المستخدم الافتراضي في XAMPP
$password = '';           // كلمة المرور الافتراضية في XAMPP فارغة

// محاولة الاتصال بخادم MySQL بدون تحديد قاعدة بيانات
try {
    // إنشاء اتصال PDO بدون تحديد قاعدة البيانات
    $pdo = new PDO("mysql:host=$host;charset=utf8mb4", $username, $password);
    
    // تعيين وضع الخطأ إلى استثناء
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // الحصول على قائمة قواعد البيانات
    $stmt = $pdo->query("SHOW DATABASES");
    $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // الحصول على معلومات المستخدم
    $stmt = $pdo->query("SELECT USER(), CURRENT_USER()");
    $userInfo = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // الحصول على إصدار MySQL
    $stmt = $pdo->query("SELECT VERSION()");
    $version = $stmt->fetchColumn();
    
    // الحصول على حالة خادم MySQL
    $stmt = $pdo->query("SHOW STATUS");
    $status = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $status[$row['Variable_name']] = $row['Value'];
    }
    
    // الحصول على متغيرات النظام
    $stmt = $pdo->query("SHOW VARIABLES LIKE 'character_set%'");
    $variables = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $variables[$row['Variable_name']] = $row['Value'];
    }
    
    // الحصول على معلومات المستخدمين
    try {
        $stmt = $pdo->query("SELECT User, Host, plugin, authentication_string FROM mysql.user");
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $users = [['User' => 'غير متاح', 'Host' => 'غير متاح', 'plugin' => 'غير متاح', 'authentication_string' => 'غير متاح']];
    }
    
    // تحديد ما إذا كان المستخدم يتطلب كلمة مرور
    $requiresPassword = false;
    foreach ($users as $user) {
        if ($user['User'] === 'root' && !empty($user['authentication_string'])) {
            $requiresPassword = true;
            break;
        }
    }
    
    // تحديد ما إذا كان يمكن إنشاء قاعدة بيانات
    try {
        $testDbName = 'test_db_' . time();
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$testDbName`");
        $pdo->exec("DROP DATABASE `$testDbName`");
        $canCreateDatabase = true;
    } catch (PDOException $e) {
        $canCreateDatabase = false;
    }
    
    // تحديد حالة الاتصال
    $connectionStatus = 'تم الاتصال بنجاح';
    $connectionStatusClass = 'success';
} catch (PDOException $e) {
    // في حالة حدوث خطأ
    $connectionStatus = 'فشل الاتصال: ' . $e->getMessage();
    $connectionStatusClass = 'danger';
    $databases = [];
    $userInfo = ['USER()' => 'غير متاح', 'CURRENT_USER()' => 'غير متاح'];
    $version = 'غير متاح';
    $status = [];
    $variables = [];
    $users = [];
    $requiresPassword = true;
    $canCreateDatabase = false;
}
?>

<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>التحقق من اتصال MySQL</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1, h2 {
            color: #333;
        }
        .alert {
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 4px;
        }
        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-warning {
            background-color: #fff3cd;
            color: #856404;
            border: 1px solid #ffeeba;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 8px;
            text-align: right;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .section {
            margin-bottom: 30px;
        }
        .btn {
            display: inline-block;
            padding: 8px 16px;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            border: none;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #45a049;
        }
        .btn-primary {
            background-color: #007bff;
        }
        .btn-primary:hover {
            background-color: #0069d9;
        }
        .btn-danger {
            background-color: #dc3545;
        }
        .btn-danger:hover {
            background-color: #c82333;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>التحقق من اتصال MySQL</h1>
        
        <div class="alert alert-<?php echo $connectionStatusClass; ?>">
            <strong>حالة الاتصال:</strong> <?php echo $connectionStatus; ?>
        </div>
        
        <?php if ($connectionStatusClass === 'success'): ?>
            <div class="section">
                <h2>معلومات الاتصال</h2>
                <table>
                    <tr>
                        <th>المضيف</th>
                        <td><?php echo $host; ?></td>
                    </tr>
                    <tr>
                        <th>اسم المستخدم</th>
                        <td><?php echo $username; ?></td>
                    </tr>
                    <tr>
                        <th>المستخدم الحالي</th>
                        <td><?php echo $userInfo['USER()']; ?></td>
                    </tr>
                    <tr>
                        <th>المستخدم الفعلي</th>
                        <td><?php echo $userInfo['CURRENT_USER()']; ?></td>
                    </tr>
                    <tr>
                        <th>إصدار MySQL</th>
                        <td><?php echo $version; ?></td>
                    </tr>
                    <tr>
                        <th>يتطلب كلمة مرور</th>
                        <td><?php echo $requiresPassword ? 'نعم' : 'لا'; ?></td>
                    </tr>
                    <tr>
                        <th>يمكن إنشاء قاعدة بيانات</th>
                        <td><?php echo $canCreateDatabase ? 'نعم' : 'لا'; ?></td>
                    </tr>
                </table>
            </div>
            
            <div class="section">
                <h2>قواعد البيانات المتاحة</h2>
                <?php if (count($databases) > 0): ?>
                    <table>
                        <tr>
                            <th>#</th>
                            <th>اسم قاعدة البيانات</th>
                        </tr>
                        <?php foreach ($databases as $index => $database): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo $database; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                <?php else: ?>
                    <div class="alert alert-warning">لا توجد قواعد بيانات متاحة.</div>
                <?php endif; ?>
            </div>
            
            <div class="section">
                <h2>المستخدمون</h2>
                <?php if (count($users) > 0): ?>
                    <table>
                        <tr>
                            <th>اسم المستخدم</th>
                            <th>المضيف</th>
                            <th>طريقة المصادقة</th>
                            <th>كلمة المرور</th>
                        </tr>
                        <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?php echo $user['User']; ?></td>
                                <td><?php echo $user['Host']; ?></td>
                                <td><?php echo $user['plugin']; ?></td>
                                <td><?php echo empty($user['authentication_string']) ? 'فارغة' : 'موجودة'; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                <?php else: ?>
                    <div class="alert alert-warning">لا يمكن عرض معلومات المستخدمين.</div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <div class="section">
            <a href="mysql_password_reset.php" class="btn btn-primary">إعادة تعيين كلمة مرور MySQL</a>
            <a href="index.php" class="btn">العودة إلى الصفحة الرئيسية</a>
        </div>
    </div>
</body>
</html>
