<?php
/**
 * صفحة تسجيل دخول بسيطة
 * تستخدم هذه الصفحة لتسجيل الدخول بشكل بسيط
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// بدء الجلسة
session_start();

// تضمين ملف التكوين
require_once 'config/config.php';

// التحقق من طريقة الطلب
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // الحصول على بيانات النموذج
    $email = sanitizeInput($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    // التحقق من البيانات
    if (empty($email) || empty($password)) {
        $error = 'يرجى إدخال البريد الإلكتروني وكلمة المرور.';
    } else {
        // تسجيل الدخول بشكل مباشر (للاختبار فقط)
        $_SESSION['user_id'] = 1;
        $_SESSION['username'] = 'admin';
        $_SESSION['full_name'] = 'مدير النظام';
        $_SESSION['email'] = 'admin@example.com';
        $_SESSION['role'] = 'admin';
        $_SESSION['branch_id'] = 1;
        $_SESSION['logged_in'] = true;
        
        // توجيه المستخدم إلى لوحة التحكم
        header('Location: admin/dashboard-direct.php');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - نظام طلبات الشحن</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700&display=swap');
        
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f1f5f9;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background: linear-gradient(135deg, #1a4b7c 0%, #3a8dca 100%);
        }
        
        .login-container {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            padding: 30px;
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .login-header h1 {
            color: #1a4b7c;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .login-header img {
            max-width: 150px;
            height: auto;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #1e293b;
        }
        
        .form-control {
            width: 100%;
            padding: 12px;
            border: 1px solid #cbd5e1;
            border-radius: 5px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-control:focus {
            outline: none;
            border-color: #3a8dca;
            box-shadow: 0 0 0 3px rgba(58, 141, 202, 0.1);
        }
        
        .btn {
            display: block;
            width: 100%;
            padding: 12px;
            background-color: #1a4b7c;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .btn:hover {
            background-color: #3a8dca;
        }
        
        .error-message {
            background-color: #fee2e2;
            color: #b91c1c;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <img src="<?php echo $company_logo; ?>" alt="شعار الشركة">
            <h1>تسجيل الدخول</h1>
            <p>أدخل بيانات الدخول للوصول إلى لوحة التحكم</p>
        </div>
        
        <?php if (isset($error)): ?>
            <div class="error-message">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <form method="post" action="">
            <div class="form-group">
                <label for="email">البريد الإلكتروني</label>
                <input type="email" id="email" name="email" class="form-control" placeholder="أدخل البريد الإلكتروني" required>
            </div>
            
            <div class="form-group">
                <label for="password">كلمة المرور</label>
                <input type="password" id="password" name="password" class="form-control" placeholder="أدخل كلمة المرور" required>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn">تسجيل الدخول</button>
            </div>
        </form>
        
        <div style="text-align: center; margin-top: 20px;">
            <p>للتجربة استخدم:</p>
            <p>البريد الإلكتروني: admin@example.com</p>
            <p>كلمة المرور: أي كلمة مرور</p>
        </div>
    </div>
</body>
</html>
