<?php
// تضمين ملف التحقق من تسجيل الدخول
require_once 'check_auth.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | مركز الدعم</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    :root {
      --primary: #4f46e5;
      --primary-light: #818cf8;
      --secondary: #f59e0b;
      --dark: #1e293b;
      --light: #f8fafc;
    }

    @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap');

    body {
      font-family: 'Tajawal', sans-serif;
      background-color: #f1f5f9;
      color: var(--dark);
    }

    /* تصميم المحتوى الرئيسي */
    .main-content {
      transition: margin-right 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    /* كروت الدعم */
    .support-card {
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .support-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    /* أزرار */
    .btn-primary {
      background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
      transition: all 0.3s ease;
      box-shadow: 0 4px 6px -1px rgba(79, 70, 229, 0.3);
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 15px -3px rgba(79, 70, 229, 0.4);
    }

    /* تأثيرات الحركة */
    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(10px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .animate-fadeIn {
      animation: fadeIn 0.5s ease-out forwards;
    }

    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
      width: 8px;
      height: 8px;
    }

    ::-webkit-scrollbar-track {
      background: #f1f5f9;
    }

    ::-webkit-scrollbar-thumb {
      background-color: #c7d2fe;
      border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
      background-color: #a5b4fc;
    }
  </style>
</head>

<body class="bg-gray-50">

  <!-- تضمين القائمة الجانبية المشتركة -->
  <?php include_once '../includes/sidebar.php'; ?>

  <!-- المحتوى الرئيسي -->
  <main class="main-content mr-[280px] p-6">
    <!-- عنوان الصفحة -->
    <div class="flex justify-between items-center mb-6">
      <h1 class="text-2xl font-bold text-gray-800">مركز الدعم</h1>
      <div class="flex space-x-2 space-x-reverse">
        <?php if (hasPermission('support_contact_admin')): ?>
        <button onclick="window.location.href='ticket.php'" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300">
          <i class="fas fa-plus ml-2"></i>
          <span>تذكرة جديدة</span>
        </button>
        <?php endif; ?>
      </div>
    </div>

    <!-- بطاقة الترحيب -->
    <div class="bg-gradient-to-l from-indigo-500 to-indigo-600 rounded-xl shadow-md p-6 mb-8 text-white">
      <div class="flex items-center">
        <div class="w-16 h-16 bg-white/20 rounded-full flex items-center justify-center mr-6">
          <i class="fas fa-headset text-3xl"></i>
        </div>
        <div>
          <h2 class="text-xl font-bold mb-2">مرحباً بك في مركز الدعم</h2>
          <p class="text-indigo-100">نحن هنا لمساعدتك في حل أي مشكلة قد تواجهها أثناء استخدام النظام.</p>
        </div>
      </div>
    </div>

    <!-- خيارات الدعم -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
      <div class="support-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 ml-3">
            <i class="fas fa-question-circle text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">الأسئلة الشائعة</h3>
        </div>
        <p class="text-gray-600 mb-4">إجابات على الأسئلة المتكررة حول استخدام النظام والمشكلات الشائعة.</p>
        <a href="faq.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>عرض الأسئلة الشائعة</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>

      <div class="support-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-green-100 flex items-center justify-center text-green-600 ml-3">
            <i class="fas fa-ticket-alt text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">تذاكر الدعم</h3>
        </div>
        <p class="text-gray-600 mb-4">إدارة تذاكر الدعم الفني الخاصة بك ومتابعة حالتها.</p>
        <a href="tickets.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>عرض التذاكر</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>

      <div class="support-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center text-purple-600 ml-3">
            <i class="fas fa-book text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">دليل المستخدم</h3>
        </div>
        <p class="text-gray-600 mb-4">دليل شامل لاستخدام النظام وشرح جميع الميزات والوظائف.</p>
        <a href="manual.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>عرض الدليل</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>
    </div>

    <!-- تذاكر الدعم الحالية -->
    <div class="bg-white rounded-xl shadow-sm p-6 mb-8">
      <h2 class="text-xl font-bold mb-4 flex items-center">
        <i class="fas fa-ticket-alt text-indigo-600 ml-2"></i>
        <span>تذاكر الدعم الحالية</span>
      </h2>

      <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
          <thead class="bg-gray-50">
            <tr>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                رقم التذكرة
              </th>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                العنوان
              </th>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                القسم
              </th>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                تاريخ الإنشاء
              </th>
              <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                الحالة
              </th>
              <th scope="col" class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">
                إجراء
              </th>
            </tr>
          </thead>
          <tbody class="bg-white divide-y divide-gray-200">
            <tr>
              <td class="px-3 py-4 whitespace-nowrap">
                <div class="text-sm font-medium text-gray-900">#1001</div>
              </td>
              <td class="px-3 py-4 whitespace-nowrap">
                <div class="text-sm text-gray-900">مشكلة في إنشاء طلب جديد</div>
              </td>
              <td class="px-3 py-4 whitespace-nowrap">
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                  الطلبات
                </span>
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500">
                2023-05-01
              </td>
              <td class="px-3 py-4 whitespace-nowrap">
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                  قيد المعالجة
                </span>
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500 text-center">
                <a href="ticket-details.php?id=1001" class="text-indigo-600 hover:text-indigo-900"><i class="fas fa-eye"></i></a>
              </td>
            </tr>
            <tr>
              <td class="px-3 py-4 whitespace-nowrap">
                <div class="text-sm font-medium text-gray-900">#1002</div>
              </td>
              <td class="px-3 py-4 whitespace-nowrap">
                <div class="text-sm text-gray-900">استفسار حول التقارير</div>
              </td>
              <td class="px-3 py-4 whitespace-nowrap">
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-purple-100 text-purple-800">
                  التقارير
                </span>
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500">
                2023-04-28
              </td>
              <td class="px-3 py-4 whitespace-nowrap">
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                  مغلقة
                </span>
              </td>
              <td class="px-3 py-4 whitespace-nowrap text-sm text-gray-500 text-center">
                <a href="ticket-details.php?id=1002" class="text-indigo-600 hover:text-indigo-900"><i class="fas fa-eye"></i></a>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>

    <!-- معلومات الاتصال -->
    <div class="bg-white rounded-xl shadow-sm p-6">
      <h2 class="text-xl font-bold mb-4 flex items-center">
        <i class="fas fa-phone-alt text-indigo-600 ml-2"></i>
        <span>معلومات الاتصال</span>
      </h2>

      <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="flex items-start">
          <div class="w-10 h-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 ml-3 mt-1">
            <i class="fas fa-envelope"></i>
          </div>
          <div>
            <h3 class="text-md font-semibold mb-1">البريد الإلكتروني</h3>
            <p class="text-gray-600">support@example.com</p>
          </div>
        </div>

        <div class="flex items-start">
          <div class="w-10 h-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 ml-3 mt-1">
            <i class="fas fa-phone"></i>
          </div>
          <div>
            <h3 class="text-md font-semibold mb-1">رقم الهاتف</h3>
            <p class="text-gray-600">+967 123456789</p>
          </div>
        </div>

        <div class="flex items-start">
          <div class="w-10 h-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 ml-3 mt-1">
            <i class="fas fa-clock"></i>
          </div>
          <div>
            <h3 class="text-md font-semibold mb-1">ساعات العمل</h3>
            <p class="text-gray-600">السبت - الخميس: 9:00 ص - 5:00 م</p>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- سكريبت الصفحة -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // يمكن إضافة أي سكريبت خاص بصفحة الدعم هنا
    });
  </script>
</body>

</html>
