<?php
/**
 * صفحة إنشاء تذكرة دعم فني جديدة
 * تتيح للمستخدم العادي إنشاء تذكرة دعم فني جديدة للتواصل مع الإدارة
 */

// بدء الجلسة
session_start();

// تضمين ملف التكوين
require_once '../config/config.php';

// تضمين ملف إدارة الصلاحيات
require_once '../includes/permissions.php';

// التحقق من حالة تسجيل الدخول
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    // إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
    header('Location: ../auth/login.php');
    exit;
}

// التحقق من صلاحية التواصل مع الإدارة
if (!hasPermission('support_contact_admin')) {
    // إعادة توجيه المستخدم إلى صفحة رفض الوصول
    header('Location: ../auth/access_denied.php');
    exit;
}

// الحصول على معلومات المستخدم
$user = [
    'id' => $_SESSION['user_id'] ?? 0,
    'username' => $_SESSION['username'] ?? '',
    'full_name' => $_SESSION['full_name'] ?? 'المستخدم',
    'email' => $_SESSION['email'] ?? '',
    'role' => $_SESSION['role'] ?? 'user',
    'branch_id' => $_SESSION['branch_id'] ?? null
];

// معالجة إرسال النموذج
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // التحقق من البيانات المرسلة
    $subject = trim($_POST['subject'] ?? '');
    $category = trim($_POST['category'] ?? '');
    $priority = trim($_POST['priority'] ?? '');
    $message = trim($_POST['message'] ?? '');

    // التحقق من صحة البيانات
    if (empty($subject) || empty($category) || empty($priority) || empty($message)) {
        $error_message = 'يرجى ملء جميع الحقول المطلوبة';
    } else {
        try {
            // إنشاء تذكرة جديدة
            $stmt = $pdo->prepare("
                INSERT INTO support_tickets
                (user_id, subject, category, priority, message, status, created_at)
                VALUES
                (?, ?, ?, ?, ?, 'جديدة', NOW())
            ");

            $stmt->execute([
                $user['id'],
                $subject,
                $category,
                $priority,
                $message
            ]);

            $ticket_id = $pdo->lastInsertId();

            // إرسال إشعار للإدارة (يمكن إضافة هذه الوظيفة لاحقاً)

            $success_message = 'تم إنشاء تذكرة الدعم بنجاح. رقم التذكرة: #' . $ticket_id;

            // إعادة تعيين النموذج
            $subject = $category = $priority = $message = '';
        } catch (PDOException $e) {
            $error_message = 'حدث خطأ أثناء إنشاء التذكرة: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | إنشاء تذكرة دعم</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="../assets/css/unified-design.css">
</head>

<body class="bg-gray-50">

  <!-- تضمين القائمة الجانبية المشتركة -->
  <?php include_once '../includes/sidebar.php'; ?>

  <!-- المحتوى الرئيسي -->
  <main class="main-content mr-[280px] p-6">
    <!-- عنوان الصفحة -->
    <div class="flex justify-between items-center mb-6">
      <h1 class="text-2xl font-bold text-gray-800">إنشاء تذكرة دعم جديدة</h1>
      <div class="flex space-x-2 space-x-reverse">
        <a href="index.php" class="bg-gray-200 hover:bg-gray-300 text-gray-700 px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300">
          <i class="fas fa-arrow-right ml-2"></i>
          <span>العودة</span>
        </a>
      </div>
    </div>

    <?php if (!empty($success_message)): ?>
    <div class="bg-green-100 border-r-4 border-green-500 text-green-700 p-4 mb-6 rounded-md">
      <div class="flex items-center">
        <i class="fas fa-check-circle ml-3 text-green-500"></i>
        <p><?php echo $success_message; ?></p>
      </div>
    </div>
    <?php endif; ?>

    <?php if (!empty($error_message)): ?>
    <div class="bg-red-100 border-r-4 border-red-500 text-red-700 p-4 mb-6 rounded-md">
      <div class="flex items-center">
        <i class="fas fa-exclamation-circle ml-3 text-red-500"></i>
        <p><?php echo $error_message; ?></p>
      </div>
    </div>
    <?php endif; ?>

    <!-- نموذج إنشاء تذكرة -->
    <div class="bg-white rounded-xl shadow-sm p-6 mb-8">
      <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
          <div>
            <label for="subject" class="block text-sm font-medium text-gray-700 mb-2">عنوان التذكرة <span class="text-red-500">*</span></label>
            <input type="text" id="subject" name="subject" value="<?php echo isset($subject) ? htmlspecialchars($subject) : ''; ?>" required
              class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
          </div>

          <div>
            <label for="category" class="block text-sm font-medium text-gray-700 mb-2">القسم <span class="text-red-500">*</span></label>
            <select id="category" name="category" required
              class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
              <option value="" disabled <?php echo !isset($category) ? 'selected' : ''; ?>>اختر القسم</option>
              <option value="الطلبات" <?php echo isset($category) && $category === 'الطلبات' ? 'selected' : ''; ?>>الطلبات</option>
              <option value="التقارير" <?php echo isset($category) && $category === 'التقارير' ? 'selected' : ''; ?>>التقارير</option>
              <option value="الحساب" <?php echo isset($category) && $category === 'الحساب' ? 'selected' : ''; ?>>الحساب</option>
              <option value="أخرى" <?php echo isset($category) && $category === 'أخرى' ? 'selected' : ''; ?>>أخرى</option>
            </select>
          </div>
        </div>

        <div class="mb-6">
          <label for="priority" class="block text-sm font-medium text-gray-700 mb-2">الأولوية <span class="text-red-500">*</span></label>
          <div class="flex space-x-4 space-x-reverse">
            <label class="inline-flex items-center">
              <input type="radio" name="priority" value="منخفضة" <?php echo isset($priority) && $priority === 'منخفضة' ? 'checked' : ''; ?> required
                class="form-radio h-5 w-5 text-indigo-600">
              <span class="mr-2 text-gray-700">منخفضة</span>
            </label>
            <label class="inline-flex items-center">
              <input type="radio" name="priority" value="متوسطة" <?php echo isset($priority) && $priority === 'متوسطة' ? 'checked' : ''; ?> required
                class="form-radio h-5 w-5 text-indigo-600">
              <span class="mr-2 text-gray-700">متوسطة</span>
            </label>
            <label class="inline-flex items-center">
              <input type="radio" name="priority" value="عالية" <?php echo isset($priority) && $priority === 'عالية' ? 'checked' : ''; ?> required
                class="form-radio h-5 w-5 text-indigo-600">
              <span class="mr-2 text-gray-700">عالية</span>
            </label>
          </div>
        </div>

        <div class="mb-6">
          <label for="message" class="block text-sm font-medium text-gray-700 mb-2">وصف المشكلة <span class="text-red-500">*</span></label>
          <textarea id="message" name="message" rows="6" required
            class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-indigo-500 focus:border-indigo-500"><?php echo isset($message) ? htmlspecialchars($message) : ''; ?></textarea>
        </div>

        <div class="flex justify-end">
          <button type="submit"
            class="bg-indigo-600 hover:bg-indigo-700 text-white px-6 py-2 rounded-lg font-medium transition-colors duration-300">
            <i class="fas fa-paper-plane ml-2"></i>
            <span>إرسال التذكرة</span>
          </button>
        </div>
      </form>
    </div>

    <!-- نصائح للمستخدم -->
    <div class="bg-blue-50 border border-blue-200 rounded-xl p-6">
      <h3 class="text-lg font-semibold text-blue-800 mb-3 flex items-center">
        <i class="fas fa-lightbulb text-yellow-500 ml-2"></i>
        <span>نصائح لتذكرة دعم فعالة</span>
      </h3>
      <ul class="list-disc list-inside space-y-2 text-blue-700">
        <li>قم بوصف المشكلة بشكل واضح ومفصل</li>
        <li>أضف أي رسائل خطأ ظهرت لك بالضبط</li>
        <li>اذكر الخطوات التي اتبعتها قبل حدوث المشكلة</li>
        <li>حدد الأولوية بناءً على مدى تأثير المشكلة على عملك</li>
      </ul>
    </div>
  </main>

  <!-- سكريبت الصفحة -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // يمكن إضافة أي سكريبت خاص بصفحة إنشاء التذكرة هنا
    });
  </script>
</body>

</html>
