<?php
/**
 * ملف رأس الصفحة المشترك
 * يستخدم في جميع صفحات النظام
 */

// بدء الجلسة إذا لم تكن قد بدأت
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// تضمين ملف التكوين
require_once __DIR__ . '/../config/config.php';

// التحقق من تسجيل الدخول إذا كانت الصفحة تتطلب ذلك
$require_login = $require_login ?? true;
if ($require_login && !isLoggedIn()) {
    header('Location: login.php');
    exit;
}

// الحصول على معلومات المستخدم
$user_id = $_SESSION['user_id'] ?? 0;
$user_name = $_SESSION['user_name'] ?? 'زائر';
$user_role = $_SESSION['user_role'] ?? '';
$branch_id = $_SESSION['branch_id'] ?? 0;

// الحصول على اسم الفرع
$branch_name = '';
if (!empty($branch_id)) {
    $branch_name = getBranchName($pdo, $branch_id);
}

// تحديد الصفحة النشطة
$active_page = $active_page ?? '';

// تحديد عنوان الصفحة
$page_title = $page_title ?? $system_name;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    
    <!-- روابط CSS -->
    <link rel="stylesheet" href="<?php echo $base_url; ?>/assets/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>/assets/css/all.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>/assets/css/style.css">
    
    <!-- روابط CSS إضافية -->
    <?php if (isset($extra_css)): ?>
        <?php foreach ($extra_css as $css): ?>
            <link rel="stylesheet" href="<?php echo $base_url . $css; ?>">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body>
    <!-- القائمة العلوية -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="<?php echo $base_url; ?>/index.php">
                <img src="<?php echo $base_url; ?>/<?php echo $company_logo; ?>" alt="<?php echo htmlspecialchars($company_name); ?>" height="40" class="d-inline-block align-text-top me-2">
                <?php echo htmlspecialchars($system_name); ?>
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain" aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarMain">
                <?php if (isLoggedIn()): ?>
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link <?php echo $active_page === 'dashboard' ? 'active' : ''; ?>" href="<?php echo $base_url; ?>/dashboard.php">
                            <i class="fas fa-tachometer-alt"></i> لوحة التحكم
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a class="nav-link <?php echo $active_page === 'orders' ? 'active' : ''; ?>" href="<?php echo $base_url; ?>/orders.php">
                            <i class="fas fa-shipping-fast"></i> الطلبات
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a class="nav-link <?php echo $active_page === 'create-order' ? 'active' : ''; ?>" href="<?php echo $base_url; ?>/create-order.php">
                            <i class="fas fa-plus-circle"></i> طلب جديد
                        </a>
                    </li>
                    
                    <?php if (hasPermission('manager')): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo in_array($active_page, ['reports', 'statistics']) ? 'active' : ''; ?>" href="#" id="reportsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-chart-bar"></i> التقارير
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="reportsDropdown">
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/reports/monthly.php">
                                    <i class="fas fa-calendar-alt"></i> تقرير شهري
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/reports/branches.php">
                                    <i class="fas fa-code-branch"></i> تقرير الفروع
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/reports/financial.php">
                                    <i class="fas fa-dollar-sign"></i> تقرير مالي
                                </a>
                            </li>
                        </ul>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (hasPermission('admin')): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo in_array($active_page, ['users', 'branches', 'settings']) ? 'active' : ''; ?>" href="#" id="adminDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-cogs"></i> الإدارة
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="adminDropdown">
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/users.php">
                                    <i class="fas fa-users"></i> المستخدمين
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/branches.php">
                                    <i class="fas fa-code-branch"></i> الفروع
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/settings.php">
                                    <i class="fas fa-cog"></i> الإعدادات
                                </a>
                            </li>
                        </ul>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a class="nav-link <?php echo $active_page === 'archive' ? 'active' : ''; ?>" href="<?php echo $base_url; ?>/archive.php">
                            <i class="fas fa-archive"></i> الأرشيف
                        </a>
                    </li>
                </ul>
                
                <div class="d-flex">
                    <div class="dropdown">
                        <a class="btn btn-outline-light dropdown-toggle" href="#" role="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-user"></i> <?php echo htmlspecialchars($user_name); ?>
                            <?php if (!empty($branch_name)): ?>
                                <span class="badge bg-light text-dark"><?php echo htmlspecialchars($branch_name); ?></span>
                            <?php endif; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/profile.php">
                                    <i class="fas fa-id-card"></i> الملف الشخصي
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/change-password.php">
                                    <i class="fas fa-key"></i> تغيير كلمة المرور
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item" href="<?php echo $base_url; ?>/logout.php">
                                    <i class="fas fa-sign-out-alt"></i> تسجيل الخروج
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </nav>
    
    <!-- محتوى الصفحة الرئيسي -->
    <main class="container py-4">
        <?php if (!empty($page_title)): ?>
        <h1 class="mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
        <?php endif; ?>
        
        <?php
        // عرض رسائل النجاح
        if (isset($_SESSION['success_message'])) {
            echo '<div class="alert alert-success alert-dismissible fade show" role="alert">';
            echo htmlspecialchars($_SESSION['success_message']);
            echo '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
            echo '</div>';
            unset($_SESSION['success_message']);
        }
        
        // عرض رسائل الخطأ
        if (isset($_SESSION['error_message'])) {
            echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
            echo htmlspecialchars($_SESSION['error_message']);
            echo '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
            echo '</div>';
            unset($_SESSION['error_message']);
        }
        ?>
