<?php
// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// معلومات PHP
echo "<h1>اختبار النظام</h1>";
echo "<h2>معلومات PHP</h2>";
echo "<p>إصدار PHP: " . phpversion() . "</p>";
echo "<p>نظام التشغيل: " . PHP_OS . "</p>";
echo "<p>مسار PHP: " . PHP_BINARY . "</p>";

// التحقق من الإضافات
echo "<h2>الإضافات المطلوبة</h2>";
$required_extensions = [
    'pdo',
    'pdo_mysql',
    'mbstring',
    'json',
    'gd',
    'xml',
    'curl',
    'zip'
];

echo "<ul>";
foreach ($required_extensions as $extension) {
    if (extension_loaded($extension)) {
        echo "<li style='color: green;'>$extension: متوفر ✓</li>";
    } else {
        echo "<li style='color: red;'>$extension: غير متوفر ✗</li>";
    }
}
echo "</ul>";

// التحقق من صلاحيات المجلدات
echo "<h2>صلاحيات المجلدات</h2>";
$directories = [
    '.',
    'logs',
    'uploads',
    'backups',
    'config',
    'includes',
    'utils'
];

echo "<ul>";
foreach ($directories as $directory) {
    if (file_exists($directory)) {
        if (is_writable($directory)) {
            echo "<li style='color: green;'>$directory: قابل للكتابة ✓</li>";
        } else {
            echo "<li style='color: red;'>$directory: غير قابل للكتابة ✗</li>";
        }
    } else {
        echo "<li style='color: orange;'>$directory: غير موجود !</li>";
    }
}
echo "</ul>";

// التحقق من الاتصال بقاعدة البيانات
echo "<h2>الاتصال بقاعدة البيانات</h2>";
try {
    // محاولة تضمين ملف الاتصال بقاعدة البيانات
    if (file_exists('config/db_connection.php')) {
        include_once 'config/db_connection.php';
        
        if (isset($conn) && $conn) {
            echo "<p style='color: green;'>تم الاتصال بقاعدة البيانات بنجاح ✓</p>";
            
            // التحقق من وجود الجداول
            $tables = [
                'users',
                'orders',
                'branches',
                'activity_log'
            ];
            
            echo "<h3>الجداول</h3>";
            echo "<ul>";
            
            foreach ($tables as $table) {
                try {
                    $stmt = $conn->query("SELECT 1 FROM $table LIMIT 1");
                    echo "<li style='color: green;'>$table: موجود ✓</li>";
                } catch (PDOException $e) {
                    echo "<li style='color: red;'>$table: غير موجود ✗</li>";
                }
            }
            
            echo "</ul>";
        } else {
            echo "<p style='color: red;'>فشل الاتصال بقاعدة البيانات ✗</p>";
        }
    } else {
        echo "<p style='color: red;'>ملف الاتصال بقاعدة البيانات غير موجود ✗</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>خطأ: " . $e->getMessage() . " ✗</p>";
}

// التحقق من الملفات الأساسية
echo "<h2>الملفات الأساسية</h2>";
$required_files = [
    'config/config.php',
    'config/db_config.php',
    'config/db_connection.php',
    'includes/common.php',
    'includes/helpers.php',
    'includes/auth.php',
    'ASDRF43/unified-dashboard.php',
    'auth/login.php',
    'auth/logout.php',
    'orders/orders.php',
    'reports/weekly_reports.php',
    'reports/monthly_reports.php',
    'api/reports.php',
    'api/orders.php'
];

echo "<ul>";
foreach ($required_files as $file) {
    if (file_exists($file)) {
        echo "<li style='color: green;'>$file: موجود ✓</li>";
    } else {
        echo "<li style='color: red;'>$file: غير موجود ✗</li>";
    }
}
echo "</ul>";

// عرض المتغيرات العامة
echo "<h2>المتغيرات العامة</h2>";
echo "<pre>";
print_r($_SERVER);
echo "</pre>";

// عرض معلومات التكوين
echo "<h2>معلومات التكوين</h2>";
echo "<pre>";
print_r(ini_get_all());
echo "</pre>";
?>
